/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class BlockSlab
extends Block {
    private Block modelBlock;
    private int modelBlockMetadata;

    public BlockSlab(int id, Block modelBlock) {
        this(id, modelBlock, 0);
    }

    public BlockSlab(int id, Block modelBlock, int modelBlockMetadata) {
        super(id, modelBlock.blockMaterial);
        this.atlasIndices = modelBlock.atlasIndices;
        this.modelBlock = modelBlock;
        this.modelBlockMetadata = modelBlockMetadata;
        this.setHardness(modelBlock.blockHardness);
        this.setResistance(modelBlock.blockResistance / 3.0f);
        this.setStepSound(modelBlock.stepSound);
        this.setLightValue(lightValue[modelBlock.blockID]);
        this.setLightOpacity(1);
    }

    @Override
    public void setBlockBoundsBasedOnState(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k) & 3;
        if (l == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        } else if (l == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else if (l == 2) {
            this.setBlockBounds(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k) & 3;
        if (l == 0) {
            return AxisAlignedBB.getBoundingBoxFromPool(i, j, k, (float)i + 1.0f, (float)j + 0.5f, (float)k + 1.0f);
        }
        if (l == 1) {
            return AxisAlignedBB.getBoundingBoxFromPool(i, j, k, i + 1, (float)j + 1.0f, (float)k + 1.0f);
        }
        return AxisAlignedBB.getBoundingBoxFromPool(i, (float)j + 0.5f, k, (float)i + 1.0f, (float)j + 1.0f, (float)k + 1.0f);
    }

    @Override
    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlockOnCondition(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        return (meta & 3) == 1;
    }

    @Override
    public boolean canPlaceOnSurfaceOnCondition(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        return (meta & 3) != 0;
    }

    @Override
    public void dropBlockWhenCrushed(World world, int i, int j, int k, int l) {
        if ((l & 3) == 1) {
            world.dropItem(i, j, k, new ItemStack(this.blockID, 2, l & 0xF0));
        } else {
            world.dropItem(i, j, k, new ItemStack(this.blockID, 1, l & 0xF0));
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(i, this.modelBlockMetadata);
    }

    @Override
    public int getBlockTextureFromSide(int i) {
        return this.modelBlock.getBlockTextureFromSide(i);
    }

    @Override
    public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(l, this.modelBlockMetadata);
    }

    @Override
    public int tickRate() {
        return this.modelBlock.tickRate();
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return this.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public void velocityToAddToEntity(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
        this.modelBlock.velocityToAddToEntity(world, i, j, k, entity, vec3d);
    }

    @Override
    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    @Override
    public boolean canCollideCheck(int i, boolean flag) {
        return this.modelBlock.canCollideCheck(i, flag);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        return world.getBlockId(i, j - 1, k) == this.blockID || world.getBlockId(i, j + 1, k) == this.blockID || super.canPlaceBlockAt(world, i, j, k);
    }

    @Override
    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
        this.modelBlock.onEntityWalking(world, i, j, k, entity);
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        this.modelBlock.updateTick(world, i, j, k, random);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return this.modelBlock.blockActivated(world, i, j, k, entityplayer);
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int i, int j, int k) {
        this.modelBlock.onBlockDestroyedByExplosion(world, i, j, k);
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Direction side, EntityLiving player, double sideHeight) {
        Direction dir = player.getVerticalPlacementDirection(side, sideHeight);
        if (dir == Direction.DOWN) {
            world.setBlockMetadataWithNotify(x, y, z, 0);
        }
        if (dir == Direction.UP) {
            world.setBlockMetadataWithNotify(x, y, z, 2);
        }
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        this.onNeighborBlockChange(world, i, j, k, 0);
        this.modelBlock.onBlockAdded(world, i, j, k);
    }

    @Override
    public int getRenderBlockPass() {
        return this.modelBlock.getRenderBlockPass();
    }

    @Override
    public float getExplosionResistance(Entity entity) {
        return this.modelBlock.getExplosionResistance(entity);
    }

    @Override
    public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.modelBlock.getBlockBrightness(iblockaccess, i, j, k);
    }

    @Override
    public void onBlockDestroyedByPlayer(World world, int i, int j, int k, int l) {
        this.modelBlock.onBlockDestroyedByPlayer(world, i, j, k, this.modelBlockMetadata);
    }

    @Override
    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        this.modelBlock.onBlockClicked(world, i, j, k, entityplayer);
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        this.modelBlock.randomDisplayTick(world, i, j, k, random);
    }

    @Override
    protected int damageDropped(int damage) {
        return 0;
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return (metadata & 3) == 1 ? 2 : 1;
    }
}

