/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityTNTPrimed;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.World;

public class BlockTNT
extends Block {
    public BlockTNT(int i) {
        super(i, Material.tnt);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        if (world.isBlockIndirectlyGettingPowered(i, j, k)) {
            this.ignite(world, i, j, k, true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (l > 0 && Block.blocksList[l].canProvidePower() && world.isBlockIndirectlyGettingPowered(i, j, k)) {
            this.ignite(world, i, j, k, true);
        }
    }

    @Override
    public int quantityDropped(int metadata, Random random) {
        return 0;
    }

    @Override
    public void onBlockDestroyedByPlayer(World world, int i, int j, int k, int l) {
        if (!world.isMultiplayerAndNotHost) {
            world.dropItem(i, j, k, new ItemStack(Block.tnt));
        }
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int i, int j, int k) {
        EntityTNTPrimed entity = new EntityTNTPrimed(world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f);
        entity.fuse = world.rand.nextInt(entity.fuse / 4) + entity.fuse / 8;
        world.entityJoinedWorld(entity);
    }

    public void ignite(World world, int x, int y, int z, boolean sound) {
        this.ignite(world, x, y, z, null, sound);
    }

    public void ignite(World world, int x, int y, int z, EntityPlayer player, boolean sound) {
        if (world.isMultiplayerAndNotHost) {
            world.playSoundEffect((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "random.fuse", 1.0f, 1.0f);
            if (player != null && player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().itemID == Item.toolFirestriker.itemID) {
                player.inventory.getCurrentItem().damageItem(1, player);
            }
            return;
        }
        world.setBlockWithNotify(x, y, z, 0);
        EntityTNTPrimed e = new EntityTNTPrimed(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
        world.entityJoinedWorld(e);
        world.playSoundAtEntity(e, "random.fuse", 1.0f, 1.0f);
        if (player != null && player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().itemID == Item.toolFirestriker.itemID) {
            player.inventory.getCurrentItem().damageItem(1, player);
        }
    }

    @Override
    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.toolFirestriker.itemID) {
            world.setBlockMetadata(i, j, k, 1);
        }
        super.onBlockClicked(world, i, j, k, entityplayer);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (entityplayer.inventory.getCurrentItem() != null && entityplayer.inventory.getCurrentItem().itemID == Item.toolFirestriker.itemID) {
            this.ignite(world, i, j, k, entityplayer, true);
            return true;
        }
        return super.blockActivated(world, i, j, k, entityplayer);
    }
}

