/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFlower;
import net.minecraft.src.BlockMoss;
import net.minecraft.src.ColorizerGrass;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Season;
import net.minecraft.src.StatList;
import net.minecraft.src.World;

public class BlockTallGrass
extends BlockFlower {
    public BlockTallGrass(int i) {
        super(i);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.8f, 0.5f + f);
    }

    @Override
    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int l) {
        if (!world.isMultiplayerAndNotHost && entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().itemID == Item.toolShears.itemID) {
            entityplayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            world.dropItem(i, j, k, new ItemStack(this.blockID, 1, 0));
        } else {
            super.harvestBlock(world, entityplayer, i, j, k, l);
        }
    }

    @Override
    public int getRenderColor(int i) {
        return ColorizerGrass.getGrassColor(0.5, 0.5);
    }

    @Override
    public int colorMultiplier(World world, IBlockAccess iblockaccess, int i, int j, int k) {
        Season season;
        long l1 = i * 3129871 + k * 6129781 + j;
        l1 = l1 * l1 * 42317861L + l1 * 11L;
        i = (int)((long)i + (l1 >> 14 & 0x1FL));
        j = (int)((long)j + (l1 >> 19 & 0x1FL));
        k = (int)((long)k + (l1 >> 24 & 0x1FL));
        double localTemperature = iblockaccess.getWorldChunkManager().getTemperature(i, k);
        double localHumidity = iblockaccess.getWorldChunkManager().getHumidity(i, k);
        int baseGrassColor = ColorizerGrass.getGrassColor(localTemperature, localHumidity);
        if (world != null && (season = world.getCurrentSeason()) != null) {
            float progress = (float)world.dayInSeason / (float)(season.lengthTicks / Minecraft.DAY_LENGTH_TICKS);
            baseGrassColor = season.modifyGrassColorizer(baseGrassColor, progress > 0.5f ? world.getNextSeason() : world.getLastSeason(), Math.abs(progress - 0.5f));
        }
        return baseGrassColor;
    }

    @Override
    public int idDropped(int i, Random random) {
        return -1;
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int i) {
        Block block = Block.getBlock(i);
        if (block != null && block instanceof BlockMoss) {
            return true;
        }
        return super.canThisPlantGrowOnThisBlockID(i);
    }
}

