/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class BlockTorch
extends Block {
    public BlockTorch(int i) {
        super(i, Material.circuits);
        this.setTickOnLoad(true);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 2;
    }

    private boolean canPlaceOnTop(World world, int i, int j, int k) {
        int id = world.getBlockId(i, j, k);
        return world.isBlockNormalCube(i, j, k) || id == Block.fencePlanksOak.blockID || id == Block.fencePlanksOakPainted.blockID;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int i, int j, int k) {
        if (world.isBlockNormalCube(i - 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            return true;
        }
        if (world.isBlockNormalCube(i, j, k + 1)) {
            return true;
        }
        return world.canPlaceOnSurfaceOfBlock(i, j - 1, k);
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Direction side, EntityLiving player, double sideHeight) {
        int l = Direction.getLegacySide(side);
        int i1 = world.getBlockMetadata(x, y, z);
        if (l == 1 && this.canPlaceOnTop(world, x, y - 1, z)) {
            i1 = 5;
        }
        if (l == 2 && world.isBlockNormalCube(x, y, z + 1)) {
            i1 = 4;
        }
        if (l == 3 && world.isBlockNormalCube(x, y, z - 1)) {
            i1 = 3;
        }
        if (l == 4 && world.isBlockNormalCube(x + 1, y, z)) {
            i1 = 2;
        }
        if (l == 5 && world.isBlockNormalCube(x - 1, y, z)) {
            i1 = 1;
        }
        world.setBlockMetadataWithNotify(x, y, z, i1);
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        super.updateTick(world, i, j, k, random);
        if (world.getBlockMetadata(i, j, k) == 0) {
            this.onBlockAdded(world, i, j, k);
        }
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        if (world.isBlockNormalCube(i - 1, j, k)) {
            world.setBlockMetadataWithNotify(i, j, k, 1);
        } else if (world.isBlockNormalCube(i + 1, j, k)) {
            world.setBlockMetadataWithNotify(i, j, k, 2);
        } else if (world.isBlockNormalCube(i, j, k - 1)) {
            world.setBlockMetadataWithNotify(i, j, k, 3);
        } else if (world.isBlockNormalCube(i, j, k + 1)) {
            world.setBlockMetadataWithNotify(i, j, k, 4);
        } else if (this.canPlaceOnTop(world, i, j - 1, k)) {
            world.setBlockMetadataWithNotify(i, j, k, 5);
        }
        this.dropTorchIfCantStay(world, i, j, k);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (this.dropTorchIfCantStay(world, i, j, k)) {
            int i1 = world.getBlockMetadata(i, j, k);
            boolean flag = false;
            if (!world.isBlockNormalCube(i - 1, j, k) && i1 == 1) {
                flag = true;
            }
            if (!world.isBlockNormalCube(i + 1, j, k) && i1 == 2) {
                flag = true;
            }
            if (!world.isBlockNormalCube(i, j, k - 1) && i1 == 3) {
                flag = true;
            }
            if (!world.isBlockNormalCube(i, j, k + 1) && i1 == 4) {
                flag = true;
            }
            if (!this.canPlaceOnTop(world, i, j - 1, k) && i1 == 5) {
                flag = true;
            }
            if (flag) {
                this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
                world.setBlockWithNotify(i, j, k, 0);
            }
        }
    }

    private boolean dropTorchIfCantStay(World world, int i, int j, int k) {
        if (!this.canPlaceBlockAt(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
            return false;
        }
        return true;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        int l = world.getBlockMetadata(i, j, k) & 7;
        float f = 0.15f;
        if (l == 1) {
            this.setBlockBounds(0.0f, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
        } else if (l == 2) {
            this.setBlockBounds(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0f, 0.8f, 0.5f + f);
        } else if (l == 3) {
            this.setBlockBounds(0.5f - f, 0.2f, 0.0f, 0.5f + f, 0.8f, f * 2.0f);
        } else if (l == 4) {
            this.setBlockBounds(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0f);
        } else {
            float f1 = 0.1f;
            this.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f1, 0.5f + f1, 0.6f, 0.5f + f1);
        }
        return super.collisionRayTrace(world, i, j, k, vec3d, vec3d1);
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        int l = world.getBlockMetadata(i, j, k);
        double d = (float)i + 0.5f;
        double d1 = (float)j + 0.7f;
        double d2 = (float)k + 0.5f;
        double d3 = 0.22f;
        double d4 = 0.27f;
        if (l == 1) {
            world.spawnParticle("smoke", d - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d - d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (l == 2) {
            world.spawnParticle("smoke", d + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d + d4, d1 + d3, d2, 0.0, 0.0, 0.0);
        } else if (l == 3) {
            world.spawnParticle("smoke", d, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d, d1 + d3, d2 - d4, 0.0, 0.0, 0.0);
        } else if (l == 4) {
            world.spawnParticle("smoke", d, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d, d1 + d3, d2 + d4, 0.0, 0.0, 0.0);
        } else {
            world.spawnParticle("smoke", d, d1, d2, 0.0, 0.0, 0.0);
            world.spawnParticle("flame", d, d1, d2, 0.0, 0.0, 0.0);
        }
    }
}

