/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.Chunk;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MapGenBase;
import net.minecraft.src.MapGenCavesHell;
import net.minecraft.src.NoiseGeneratorOctaves;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenFire;
import net.minecraft.src.WorldGenFlowers;
import net.minecraft.src.WorldGenGlowStone1;
import net.minecraft.src.WorldGenGlowStone2;
import net.minecraft.src.WorldGenHellLava;
import net.minecraft.src.WorldGenMinable;

public class ChunkProviderHell
implements IChunkProvider {
    private Random hellRNG;
    private NoiseGeneratorOctaves field_4169_i;
    private NoiseGeneratorOctaves field_4168_j;
    private NoiseGeneratorOctaves field_4167_k;
    private NoiseGeneratorOctaves field_4166_l;
    private NoiseGeneratorOctaves field_4165_m;
    public NoiseGeneratorOctaves field_4177_a;
    public NoiseGeneratorOctaves field_4176_b;
    private World worldObj;
    private double[] field_4163_o;
    private double[] field_4162_p = new double[256];
    private double[] field_4161_q = new double[256];
    private double[] field_4160_r = new double[256];
    private MapGenBase field_4159_s = new MapGenCavesHell();
    double[] field_4175_c;
    double[] field_4174_d;
    double[] field_4173_e;
    double[] field_4172_f;
    double[] field_4171_g;

    public ChunkProviderHell(World world, long l) {
        this.worldObj = world;
        this.hellRNG = new Random(l);
        this.field_4169_i = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.field_4168_j = new NoiseGeneratorOctaves(this.hellRNG, 16);
        this.field_4167_k = new NoiseGeneratorOctaves(this.hellRNG, 8);
        this.field_4166_l = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.field_4165_m = new NoiseGeneratorOctaves(this.hellRNG, 4);
        this.field_4177_a = new NoiseGeneratorOctaves(this.hellRNG, 10);
        this.field_4176_b = new NoiseGeneratorOctaves(this.hellRNG, 16);
    }

    public void func_4059_a(int i, int j, short[] ashort0) {
        int byte0 = 4;
        int byte1 = 32;
        int k = byte0 + 1;
        int byte2 = 17;
        int yOffset = 128;
        int l = byte0 + 1;
        this.field_4163_o = this.func_4057_a(this.field_4163_o, i * byte0, 0, j * byte0, k, byte2, l);
        for (int i1 = 0; i1 < byte0; ++i1) {
            for (int j1 = 0; j1 < byte0; ++j1) {
                for (int k1 = 0; k1 < 16; ++k1) {
                    double d = 0.125;
                    double d1 = this.field_4163_o[((i1 + 0) * l + (j1 + 0)) * byte2 + (k1 + 0)];
                    double d2 = this.field_4163_o[((i1 + 0) * l + (j1 + 1)) * byte2 + (k1 + 0)];
                    double d3 = this.field_4163_o[((i1 + 1) * l + (j1 + 0)) * byte2 + (k1 + 0)];
                    double d4 = this.field_4163_o[((i1 + 1) * l + (j1 + 1)) * byte2 + (k1 + 0)];
                    double d5 = (this.field_4163_o[((i1 + 0) * l + (j1 + 0)) * byte2 + (k1 + 1)] - d1) * d;
                    double d6 = (this.field_4163_o[((i1 + 0) * l + (j1 + 1)) * byte2 + (k1 + 1)] - d2) * d;
                    double d7 = (this.field_4163_o[((i1 + 1) * l + (j1 + 0)) * byte2 + (k1 + 1)] - d3) * d;
                    double d8 = (this.field_4163_o[((i1 + 1) * l + (j1 + 1)) * byte2 + (k1 + 1)] - d4) * d;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            int j2 = i2 + i1 * 4 << Minecraft.WORLD_HEIGHT_BITS + 4 | 0 + j1 * 4 << Minecraft.WORLD_HEIGHT_BITS | k1 * 8 + l1 + yOffset;
                            char c = (char)Minecraft.WORLD_HEIGHT_BLOCKS;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                int l2 = 0;
                                if (k1 * 8 + l1 < byte1) {
                                    l2 = Block.fluidLavaStill.blockID;
                                }
                                if (d15 > 0.0) {
                                    l2 = Block.netherrack.blockID;
                                }
                                ashort0[j2] = (short)l2;
                                j2 += c;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void func_4058_b(int i, int j, short[] ashort0) {
        int byte0 = 64;
        double d = 0.03125;
        this.field_4162_p = this.field_4166_l.generateNoiseOctaves(this.field_4162_p, i * 16, j * 16, 0.0, 16, 16, 1, d, d, 1.0);
        this.field_4161_q = this.field_4166_l.generateNoiseOctaves(this.field_4161_q, i * 16, 109.0134, j * 16, 16, 1, 16, d, 1.0, d);
        this.field_4160_r = this.field_4165_m.generateNoiseOctaves(this.field_4160_r, i * 16, j * 16, 0.0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                boolean flag = this.field_4162_p[k + l * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.field_4161_q[k + l * 16] + this.hellRNG.nextDouble() * 0.2 > 0.0;
                int i1 = (int)(this.field_4160_r[k + l * 16] / 3.0 + 3.0 + this.hellRNG.nextDouble() * 0.25);
                int j1 = -1;
                short byte1 = (short)Block.netherrack.blockID;
                short byte2 = (short)Block.netherrack.blockID;
                for (int k1 = 127; k1 >= 0; --k1) {
                    short short3;
                    int l1 = (l * 16 + k) * Minecraft.WORLD_HEIGHT_BLOCKS + k1 + 128;
                    if (k1 >= 127 - this.hellRNG.nextInt(5)) {
                        ashort0[l1] = (short)Block.bedrock.blockID;
                        continue;
                    }
                    if (k1 <= 0 + this.hellRNG.nextInt(5)) {
                        ashort0[l1] = (short)Block.bedrock.blockID;
                        continue;
                    }
                    if (k1 == 0 || k1 == 127) {
                        ashort0[l1] = (short)Block.bedrock.blockID;
                    }
                    if ((short3 = ashort0[l1]) == 0) {
                        j1 = -1;
                        continue;
                    }
                    if (short3 != Block.netherrack.blockID) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            byte1 = 0;
                            byte2 = (short)Block.netherrack.blockID;
                        } else if (k1 >= byte0 - 4 && k1 <= byte0 + 1) {
                            byte1 = (short)Block.netherrack.blockID;
                            byte2 = (short)Block.netherrack.blockID;
                            if (flag1) {
                                byte1 = (short)Block.gravel.blockID;
                            }
                            if (flag1) {
                                byte2 = (short)Block.netherrack.blockID;
                            }
                            if (flag) {
                                byte1 = (short)Block.soulsand.blockID;
                            }
                            if (flag) {
                                byte2 = (short)Block.soulsand.blockID;
                            }
                        }
                        if (k1 < byte0 && byte1 == 0) {
                            byte1 = (short)Block.fluidLavaStill.blockID;
                        }
                        j1 = i1;
                        if (k1 >= byte0 - 1) {
                            ashort0[l1] = byte1;
                            continue;
                        }
                        ashort0[l1] = byte2;
                        continue;
                    }
                    if (j1 <= 0) continue;
                    --j1;
                    ashort0[l1] = byte2;
                }
            }
        }
    }

    @Override
    public Chunk prepareChunk(int i, int j) {
        return this.provideChunk(i, j);
    }

    @Override
    public Chunk provideChunk(int i, int j) {
        this.hellRNG.setSeed((long)i * 341873128712L + (long)j * 132897987541L);
        short[] ashort0 = new short[256 * Minecraft.WORLD_HEIGHT_BLOCKS];
        this.func_4059_a(i, j, ashort0);
        this.func_4058_b(i, j, ashort0);
        this.field_4159_s.generate(this, this.worldObj, i, j, ashort0);
        Chunk chunk = new Chunk(this.worldObj, ashort0, i, j);
        return chunk;
    }

    private double[] func_4057_a(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        if (ad == null) {
            ad = new double[l * i1 * j1];
        }
        double d = 684.412;
        double d1 = 2053.236;
        this.field_4172_f = this.field_4177_a.generateNoiseOctaves(this.field_4172_f, i, j, k, l, 1, j1, 1.0, 0.0, 1.0);
        this.field_4171_g = this.field_4176_b.generateNoiseOctaves(this.field_4171_g, i, j, k, l, 1, j1, 100.0, 0.0, 100.0);
        this.field_4175_c = this.field_4167_k.generateNoiseOctaves(this.field_4175_c, i, j, k, l, i1, j1, d / 80.0, d1 / 60.0, d / 80.0);
        this.field_4174_d = this.field_4169_i.generateNoiseOctaves(this.field_4174_d, i, j, k, l, i1, j1, d, d1, d);
        this.field_4173_e = this.field_4168_j.generateNoiseOctaves(this.field_4173_e, i, j, k, l, i1, j1, d, d1, d);
        int k1 = 0;
        int l1 = 0;
        double[] ad1 = new double[i1];
        for (int i2 = 0; i2 < i1; ++i2) {
            ad1[i2] = Math.cos((double)i2 * Math.PI * 6.0 / (double)i1) * 2.0;
            double d2 = i2;
            if (i2 > i1 / 2) {
                d2 = i1 - 1 - i2;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = i2;
            ad1[n] = ad1[n] - d2 * d2 * d2 * 10.0;
        }
        for (int j2 = 0; j2 < l; ++j2) {
            for (int k2 = 0; k2 < j1; ++k2) {
                double d3 = (this.field_4172_f[l1] + 256.0) / 512.0;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.field_4171_g[l1] / 8000.0;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 /= 2.0;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)i1 / 16.0;
                ++l1;
                for (int l2 = 0; l2 < i1; ++l2) {
                    double d6 = 0.0;
                    double d7 = ad1[l2];
                    double d8 = this.field_4174_d[k1] / 512.0;
                    double d9 = this.field_4173_e[k1] / 512.0;
                    double d10 = (this.field_4175_c[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (l2 > i1 - 4) {
                        double d11 = (float)(l2 - (i1 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)l2 < d4) {
                        double d12 = (d4 - (double)l2) / 4.0;
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 > 1.0) {
                            d12 = 1.0;
                        }
                        d6 = d6 * (1.0 - d12) + -10.0 * d12;
                    }
                    ad[k1] = d6;
                    ++k1;
                }
            }
        }
        return ad;
    }

    @Override
    public boolean chunkExists(int i, int j) {
        return true;
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i, int j) {
        BlockSand.fallInstantly = true;
        int k = i * 16;
        int l = j * 16;
        for (int i1 = 0; i1 < 8; ++i1) {
            int k1 = k + this.hellRNG.nextInt(16) + 8;
            int i3 = this.hellRNG.nextInt(120) + 4 + 128;
            int k4 = l + this.hellRNG.nextInt(16) + 8;
            new WorldGenHellLava(Block.fluidLavaFlowing.blockID).generate(this.worldObj, this.hellRNG, k1, i3, k4);
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            int k3 = k + this.hellRNG.nextInt(16);
            int i5 = this.hellRNG.nextInt(120) + 128;
            int j6 = l + this.hellRNG.nextInt(16);
            new WorldGenMinable(Block.oreNethercoalNetherrack.blockID, 16, false).generate(this.worldObj, this.hellRNG, k3, i5, j6);
        }
        int j1 = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1);
        for (int l1 = 0; l1 < j1; ++l1) {
            int j3 = k + this.hellRNG.nextInt(16) + 8;
            int l4 = this.hellRNG.nextInt(120) + 4 + 128;
            int i6 = l + this.hellRNG.nextInt(16) + 8;
            new WorldGenFire().generate(this.worldObj, this.hellRNG, j3, l4, i6);
        }
        j1 = this.hellRNG.nextInt(this.hellRNG.nextInt(10) + 1);
        for (int i2 = 0; i2 < j1; ++i2) {
            int k3 = k + this.hellRNG.nextInt(16) + 8;
            int i5 = this.hellRNG.nextInt(120) + 4 + 128;
            int j6 = l + this.hellRNG.nextInt(16) + 8;
            new WorldGenGlowStone1().generate(this.worldObj, this.hellRNG, k3, i5, j6);
        }
        for (int j2 = 0; j2 < 10; ++j2) {
            int l3 = k + this.hellRNG.nextInt(16) + 8;
            int j5 = this.hellRNG.nextInt(128) + 128;
            int k6 = l + this.hellRNG.nextInt(16) + 8;
            new WorldGenGlowStone2().generate(this.worldObj, this.hellRNG, l3, j5, k6);
        }
        if (this.hellRNG.nextInt(1) == 0) {
            int k2 = k + this.hellRNG.nextInt(16) + 8;
            int i4 = this.hellRNG.nextInt(128) + 128;
            int k5 = l + this.hellRNG.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.hellRNG, k2, i4, k5);
        }
        if (this.hellRNG.nextInt(1) == 0) {
            int l2 = k + this.hellRNG.nextInt(16) + 8;
            int j4 = this.hellRNG.nextInt(128) + 128;
            int l5 = l + this.hellRNG.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.hellRNG, l2, j4, l5);
        }
        BlockSand.fallInstantly = false;
    }

    @Override
    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "HellRandomLevelSource";
    }

    @Override
    public void checkForMissingChunks() {
    }
}

