/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.IOException;
import net.minecraft.src.Chunk;
import net.minecraft.src.EmptyChunk;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.World;

public class ChunkProviderLoadOrGenerate
implements IChunkProvider {
    private Chunk blankChunk;
    public IChunkProvider chunkProvider;
    private IChunkLoader chunkLoader;
    private Chunk[] chunks = new Chunk[1024];
    private World worldObj;
    int lastQueriedChunkXPos = -999999999;
    int lastQueriedChunkZPos = -999999999;
    private Chunk lastQueriedChunk;
    private int curChunkX;
    private int curChunkY;

    public ChunkProviderLoadOrGenerate(World world, IChunkLoader ichunkloader, IChunkProvider ichunkprovider) {
        this.blankChunk = new EmptyChunk(world, new short[32768], 0, 0);
        this.worldObj = world;
        this.chunkLoader = ichunkloader;
        this.chunkProvider = ichunkprovider;
    }

    public void setCurrentChunkOver(int i, int j) {
        this.curChunkX = i;
        this.curChunkY = j;
    }

    public boolean canChunkExist(int i, int j) {
        int byte0 = 15;
        return i >= this.curChunkX - byte0 && j >= this.curChunkY - byte0 && i <= this.curChunkX + byte0 && j <= this.curChunkY + byte0;
    }

    @Override
    public boolean chunkExists(int i, int j) {
        if (!this.canChunkExist(i, j)) {
            return false;
        }
        if (i == this.lastQueriedChunkXPos && j == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return true;
        }
        int k = i & 0x1F;
        int l = j & 0x1F;
        int i1 = k + l * 32;
        return this.chunks[i1] != null && (this.chunks[i1] == this.blankChunk || this.chunks[i1].isAtLocation(i, j));
    }

    @Override
    public Chunk prepareChunk(int i, int j) {
        return this.provideChunk(i, j);
    }

    @Override
    public Chunk provideChunk(int i, int j) {
        if (i == this.lastQueriedChunkXPos && j == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return this.lastQueriedChunk;
        }
        if (!this.worldObj.findingSpawnPoint && !this.canChunkExist(i, j)) {
            return this.blankChunk;
        }
        int k = i & 0x1F;
        int l = j & 0x1F;
        int i1 = k + l * 32;
        if (!this.chunkExists(i, j)) {
            Chunk chunk;
            if (this.chunks[i1] != null) {
                this.chunks[i1].onChunkUnload();
                this.saveChunk(this.chunks[i1]);
                this.saveExtraChunkData(this.chunks[i1]);
            }
            if ((chunk = this.func_542_c(i, j)) == null) {
                if (this.chunkProvider == null) {
                    chunk = this.blankChunk;
                } else {
                    chunk = this.chunkProvider.provideChunk(i, j);
                    chunk.func_25124_i();
                }
            }
            this.chunks[i1] = chunk;
            chunk.func_4143_d();
            if (this.chunks[i1] != null) {
                this.chunks[i1].onChunkLoad();
            }
            if (!this.chunks[i1].isTerrainPopulated && this.chunkExists(i + 1, j + 1) && this.chunkExists(i, j + 1) && this.chunkExists(i + 1, j)) {
                this.populate(this, i, j);
            }
            if (this.chunkExists(i - 1, j) && !this.provideChunk((int)(i - 1), (int)j).isTerrainPopulated && this.chunkExists(i - 1, j + 1) && this.chunkExists(i, j + 1) && this.chunkExists(i - 1, j)) {
                this.populate(this, i - 1, j);
            }
            if (this.chunkExists(i, j - 1) && !this.provideChunk((int)i, (int)(j - 1)).isTerrainPopulated && this.chunkExists(i + 1, j - 1) && this.chunkExists(i, j - 1) && this.chunkExists(i + 1, j)) {
                this.populate(this, i, j - 1);
            }
            if (this.chunkExists(i - 1, j - 1) && !this.provideChunk((int)(i - 1), (int)(j - 1)).isTerrainPopulated && this.chunkExists(i - 1, j - 1) && this.chunkExists(i, j - 1) && this.chunkExists(i - 1, j)) {
                this.populate(this, i - 1, j - 1);
            }
        }
        this.lastQueriedChunkXPos = i;
        this.lastQueriedChunkZPos = j;
        this.lastQueriedChunk = this.chunks[i1];
        return this.chunks[i1];
    }

    private Chunk func_542_c(int i, int j) {
        if (this.chunkLoader == null) {
            return this.blankChunk;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.worldObj, i, j);
            if (chunk != null) {
                chunk.lastSaveTime = this.worldObj.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.blankChunk;
        }
    }

    private void saveExtraChunkData(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            this.chunkLoader.saveExtraChunkData(this.worldObj, chunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveChunk(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.worldObj.getWorldTime();
            this.chunkLoader.saveChunk(this.worldObj, chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i, int j) {
        Chunk chunk = this.provideChunk(i, j);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkProvider != null) {
                this.chunkProvider.populate(ichunkprovider, i, j);
                chunk.setChunkModified();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        int i = 0;
        int j = 0;
        if (iprogressupdate != null) {
            for (int k = 0; k < this.chunks.length; ++k) {
                if (this.chunks[k] == null || !this.chunks[k].needsSaving(flag)) continue;
                ++j;
            }
        }
        int l = 0;
        for (int i1 = 0; i1 < this.chunks.length; ++i1) {
            if (this.chunks[i1] == null) continue;
            if (flag && !this.chunks[i1].neverSave) {
                this.saveExtraChunkData(this.chunks[i1]);
            }
            if (!this.chunks[i1].needsSaving(flag)) continue;
            this.saveChunk(this.chunks[i1]);
            this.chunks[i1].isModified = false;
            if (++i == 2 && !flag) {
                return false;
            }
            if (iprogressupdate == null || ++l % 10 != 0) continue;
            iprogressupdate.setLoadingProgress(l * 100 / j);
        }
        if (flag) {
            if (this.chunkLoader == null) {
                return true;
            }
            this.chunkLoader.saveExtraData();
        }
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        if (this.chunkLoader != null) {
            this.chunkLoader.func_814_a();
        }
        return this.chunkProvider.unload100OldestChunks();
    }

    @Override
    public void unloadAllChunks() {
        for (int i = 0; i < this.chunks.length; ++i) {
            this.chunks[i] = null;
        }
        this.chunkProvider = null;
        System.gc();
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public void checkForMissingChunks() {
    }

    @Override
    public String makeString() {
        return "ChunkCache: " + this.chunks.length;
    }
}

