/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockSand;
import net.minecraft.src.Chunk;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.MapGenBase;
import net.minecraft.src.MapGenCaves;
import net.minecraft.src.NoiseGeneratorOctaves;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenCactus;
import net.minecraft.src.WorldGenClay;
import net.minecraft.src.WorldGenDungeon;
import net.minecraft.src.WorldGenFlowers;
import net.minecraft.src.WorldGenLiquids;
import net.minecraft.src.WorldGenMinable;
import net.minecraft.src.WorldGenReed;
import net.minecraft.src.WorldGenTreeShapeDefault;
import net.minecraft.src.WorldGenTreeShapeFancy;
import net.minecraft.src.WorldGenerator;

public class ChunkProviderRetro
implements IChunkProvider {
    private Random rand;
    private NoiseGeneratorOctaves field_912_k;
    private NoiseGeneratorOctaves field_911_l;
    private NoiseGeneratorOctaves field_910_m;
    private NoiseGeneratorOctaves field_909_n;
    private NoiseGeneratorOctaves field_908_o;
    public NoiseGeneratorOctaves field_922_a;
    public NoiseGeneratorOctaves field_921_b;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private double[] field_4180_q;
    private double[] sandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] stoneNoise = new double[256];
    private MapGenBase field_902_u = new MapGenCaves(true);
    double[] field_4185_d;
    double[] field_4184_e;
    double[] field_4183_f;
    double[] field_4182_g;
    double[] field_4181_h;
    int[][] field_914_i = new int[32][32];

    public ChunkProviderRetro(World world, long l) {
        this.worldObj = world;
        this.rand = new Random(l);
        this.field_912_k = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_911_l = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_910_m = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_909_n = new NoiseGeneratorOctaves(this.rand, 4);
        this.field_908_o = new NoiseGeneratorOctaves(this.rand, 4);
        this.field_922_a = new NoiseGeneratorOctaves(this.rand, 10);
        this.field_921_b = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
    }

    public void generateTerrain(int i, int j, short[] ashort0, BiomeGenBase[] abiomegenbase, double[] ad) {
        int byte0 = 4;
        int byte1 = 64;
        int k = byte0 + 1;
        int byte2 = 17;
        int l = byte0 + 1;
        this.field_4180_q = this.func_4061_a(this.field_4180_q, i * byte0, 0, j * byte0, k, byte2, l);
        for (int i1 = 0; i1 < byte0; ++i1) {
            for (int j1 = 0; j1 < byte0; ++j1) {
                for (int k1 = 0; k1 < 16; ++k1) {
                    double d = 0.125;
                    double d1 = this.field_4180_q[((i1 + 0) * l + (j1 + 0)) * byte2 + (k1 + 0)];
                    double d2 = this.field_4180_q[((i1 + 0) * l + (j1 + 1)) * byte2 + (k1 + 0)];
                    double d3 = this.field_4180_q[((i1 + 1) * l + (j1 + 0)) * byte2 + (k1 + 0)];
                    double d4 = this.field_4180_q[((i1 + 1) * l + (j1 + 1)) * byte2 + (k1 + 0)];
                    double d5 = (this.field_4180_q[((i1 + 0) * l + (j1 + 0)) * byte2 + (k1 + 1)] - d1) * d;
                    double d6 = (this.field_4180_q[((i1 + 0) * l + (j1 + 1)) * byte2 + (k1 + 1)] - d2) * d;
                    double d7 = (this.field_4180_q[((i1 + 1) * l + (j1 + 0)) * byte2 + (k1 + 1)] - d3) * d;
                    double d8 = (this.field_4180_q[((i1 + 1) * l + (j1 + 1)) * byte2 + (k1 + 1)] - d4) * d;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            int j2 = i2 + i1 * 4 << Minecraft.WORLD_HEIGHT_BITS + 4 | 0 + j1 * 4 << Minecraft.WORLD_HEIGHT_BITS | k1 * 8 + l1;
                            char c = (char)Minecraft.WORLD_HEIGHT_BLOCKS;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                int l2 = 0;
                                if (k1 * 8 + l1 < byte1) {
                                    l2 = Block.fluidWaterStill.blockID;
                                }
                                if (d15 > 0.0) {
                                    l2 = Block.stone.blockID;
                                }
                                ashort0[j2] = (short)l2;
                                j2 += c;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int i, int j, short[] ashort0, BiomeGenBase[] abiomegenbase) {
        int byte0 = 64;
        double d = 0.03125;
        this.sandNoise = this.field_909_n.generateNoiseOctaves(this.sandNoise, i * 16, j * 16, 0.0, 16, 16, 1, d, d, 1.0);
        this.gravelNoise = this.field_909_n.generateNoiseOctaves(this.gravelNoise, j * 16, 109.0134, i * 16, 16, 1, 16, d, 1.0, d);
        this.stoneNoise = this.field_908_o.generateNoiseOctaves(this.stoneNoise, i * 16, j * 16, 0.0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                boolean flag = this.sandNoise[k + l * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[k + l * 16] + this.rand.nextDouble() * 0.2 > 3.0;
                int i1 = (int)(this.stoneNoise[k + l * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int j1 = -1;
                short short1 = (short)Block.grassRetro.blockID;
                short short2 = (short)Block.dirt.blockID;
                for (int k1 = Minecraft.WORLD_HEIGHT_BLOCKS - 1; k1 >= 0; --k1) {
                    int l1 = (k * 16 + l) * Minecraft.WORLD_HEIGHT_BLOCKS + k1;
                    if (k1 <= 0 + this.rand.nextInt(6) - 1) {
                        ashort0[l1] = (short)Block.bedrock.blockID;
                        continue;
                    }
                    short short3 = ashort0[l1];
                    if (short3 == 0) {
                        j1 = -1;
                        continue;
                    }
                    if (short3 != Block.stone.blockID) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            short1 = 0;
                            short2 = (short)Block.stone.blockID;
                        } else if (k1 >= byte0 - 4 && k1 <= byte0 + 1) {
                            short1 = (short)Block.grassRetro.blockID;
                            short2 = (short)Block.dirt.blockID;
                            if (flag1) {
                                short1 = 0;
                            }
                            if (flag1) {
                                short2 = (short)Block.gravel.blockID;
                            }
                            if (flag) {
                                short1 = (short)Block.sand.blockID;
                            }
                            if (flag) {
                                short2 = (short)Block.sand.blockID;
                            }
                        }
                        if (k1 < byte0 && short1 == 0) {
                            short1 = (short)Block.fluidWaterFlowing.blockID;
                        }
                        j1 = i1;
                        if (k1 >= byte0 - 1) {
                            ashort0[l1] = short1;
                            continue;
                        }
                        ashort0[l1] = short2;
                        continue;
                    }
                    if (j1 <= 0) continue;
                    --j1;
                    ashort0[l1] = short2;
                }
            }
        }
    }

    @Override
    public Chunk prepareChunk(int i, int j) {
        return this.provideChunk(i, j);
    }

    @Override
    public Chunk provideChunk(int i, int j) {
        this.rand.setSeed((long)i * 341873128712L + (long)j * 132897987541L);
        short[] ashort0 = new short[256 * Minecraft.WORLD_HEIGHT_BLOCKS];
        Chunk chunk = new Chunk(this.worldObj, ashort0, i, j);
        this.generateTerrain(i, j, ashort0, null, null);
        this.replaceBlocksForBiome(i, j, ashort0, null);
        this.field_902_u.generate(this, this.worldObj, i, j, ashort0);
        chunk.func_1024_c();
        return chunk;
    }

    private double[] func_4061_a(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        if (ad == null) {
            ad = new double[l * i1 * j1];
        }
        double d = 684.412;
        double d1 = 684.412;
        this.field_4182_g = this.field_922_a.generateNoiseOctaves(this.field_4182_g, i, j, k, l, 1, j1, 1.0, 0.0, 1.0);
        this.field_4181_h = this.field_921_b.generateNoiseOctaves(this.field_4181_h, i, j, k, l, 1, j1, 100.0, 0.0, 100.0);
        this.field_4185_d = this.field_910_m.generateNoiseOctaves(this.field_4185_d, i, j, k, l, i1, j1, d / 80.0, d1 / 160.0, d / 80.0);
        this.field_4184_e = this.field_912_k.generateNoiseOctaves(this.field_4184_e, i, j, k, l, i1, j1, d, d1, d);
        this.field_4183_f = this.field_911_l.generateNoiseOctaves(this.field_4183_f, i, j, k, l, i1, j1, d, d1, d);
        int k1 = 0;
        int l1 = 0;
        for (int i2 = 0; i2 < l; ++i2) {
            for (int j2 = 0; j2 < j1; ++j2) {
                double d2 = (this.field_4182_g[l1] + 256.0) / 512.0;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                double d3 = 0.0;
                double d4 = this.field_4181_h[l1] / 8000.0;
                if (d4 < 0.0) {
                    d4 = -d4;
                }
                if ((d4 = d4 * 3.0 - 3.0) < 0.0) {
                    if ((d4 /= 2.0) < -1.0) {
                        d4 = -1.0;
                    }
                    d4 /= 1.4;
                    d4 /= 2.0;
                    d2 = 0.0;
                } else {
                    if (d4 > 1.0) {
                        d4 = 1.0;
                    }
                    d4 /= 6.0;
                }
                d2 += 0.5;
                d4 = d4 * (double)i1 / 16.0;
                double d5 = (double)i1 / 2.0 + d4 * 4.0;
                ++l1;
                for (int k2 = 0; k2 < i1; ++k2) {
                    double d6 = 0.0;
                    double d7 = ((double)k2 - d5) * 12.0 / d2;
                    if (d7 < 0.0) {
                        d7 *= 4.0;
                    }
                    double d8 = this.field_4184_e[k1] / 512.0;
                    double d9 = this.field_4183_f[k1] / 512.0;
                    double d10 = (this.field_4185_d[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k2 > i1 - 4) {
                        double d11 = (float)(k2 - (i1 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)k2 < d3) {
                        double d12 = (d3 - (double)k2) / 4.0;
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 > 1.0) {
                            d12 = 1.0;
                        }
                        d6 = d6 * (1.0 - d12) + -10.0 * d12;
                    }
                    ad[k1] = d6;
                    ++k1;
                }
            }
        }
        return ad;
    }

    @Override
    public boolean chunkExists(int i, int j) {
        return true;
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i, int j) {
        BlockSand.fallInstantly = true;
        int k = i * 16;
        int l = j * 16;
        this.rand.setSeed(this.worldObj.getRandomSeed());
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)i * l1 + (long)j * l2 ^ this.worldObj.getRandomSeed());
        double d = 0.25;
        for (int i1 = 0; i1 < 8; ++i1) {
            int i4 = k + this.rand.nextInt(16) + 8;
            int j6 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int i11 = l + this.rand.nextInt(16) + 8;
            new WorldGenDungeon(Block.cobbleStone.blockID, Block.cobbleStoneMossy.blockID, null).generate(this.worldObj, this.rand, i4, j6, i11);
        }
        for (int j1 = 0; j1 < 10; ++j1) {
            int j4 = k + this.rand.nextInt(16);
            int k6 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int j11 = l + this.rand.nextInt(16);
            new WorldGenClay(32).generate(this.worldObj, this.rand, j4, k6, j11);
        }
        for (int k1 = 0; k1 < 20; ++k1) {
            int k4 = k + this.rand.nextInt(16);
            int l6 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int k11 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32, false).generate(this.worldObj, this.rand, k4, l6, k11);
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            int l4 = k + this.rand.nextInt(16);
            int i7 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int l11 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32, false).generate(this.worldObj, this.rand, l4, i7, l11);
        }
        for (int j2 = 0; j2 < 20; ++j2) {
            int i5 = k + this.rand.nextInt(16);
            int j7 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int i12 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreCoalStone.blockID, 16, true).generate(this.worldObj, this.rand, i5, j7, i12);
        }
        for (int k2 = 0; k2 < 20; ++k2) {
            int j5 = k + this.rand.nextInt(16);
            int k7 = this.rand.nextInt(64);
            int j12 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreIronStone.blockID, 8, true).generate(this.worldObj, this.rand, j5, k7, j12);
        }
        for (int i3 = 0; i3 < 2; ++i3) {
            int k5 = k + this.rand.nextInt(16);
            int l7 = this.rand.nextInt(32);
            int k12 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreGoldStone.blockID, 8, true).generate(this.worldObj, this.rand, k5, l7, k12);
        }
        for (int j3 = 0; j3 < 8; ++j3) {
            int l5 = k + this.rand.nextInt(16);
            int i8 = this.rand.nextInt(16);
            int l12 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreRedstoneStone.blockID, 7, true).generate(this.worldObj, this.rand, l5, i8, l12);
        }
        for (int k3 = 0; k3 < 1; ++k3) {
            int i6 = k + this.rand.nextInt(16);
            int j8 = this.rand.nextInt(16);
            int i13 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreDiamondStone.blockID, 7, true).generate(this.worldObj, this.rand, i6, j8, i13);
        }
        d = 0.5;
        int l3 = (int)((this.mobSpawnerNoise.func_806_a((double)k * d, (double)l * d) / 8.0 + this.rand.nextDouble() * 4.0 + 4.0) / 3.0);
        if (l3 < 0) {
            l3 = 0;
        }
        if (this.rand.nextInt(10) == 0) {
            ++l3;
        }
        WorldGenerator obj = new WorldGenTreeShapeDefault(Block.leavesOakRetro.blockID, Block.logOak.blockID, 4);
        if (this.rand.nextInt(10) == 0) {
            obj = new WorldGenTreeShapeFancy(Block.leavesOakRetro.blockID, Block.logOak.blockID);
        }
        for (int k8 = 0; k8 < l3; ++k8) {
            int j13 = k + this.rand.nextInt(16) + 8;
            int l15 = l + this.rand.nextInt(16) + 8;
            ((WorldGenerator)obj).func_517_a(1.0, 1.0, 1.0);
            ((WorldGenerator)obj).generate(this.worldObj, this.rand, j13, this.worldObj.getHeightValue(j13, l15), l15);
        }
        for (int l8 = 0; l8 < 2; ++l8) {
            int k13 = k + this.rand.nextInt(16) + 8;
            int i16 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int j18 = l + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.flowerYellow.blockID).generate(this.worldObj, this.rand, k13, i16, j18);
        }
        if (this.rand.nextInt(2) == 0) {
            int i9 = k + this.rand.nextInt(16) + 8;
            int l13 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int j16 = l + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.flowerRed.blockID).generate(this.worldObj, this.rand, i9, l13, j16);
        }
        if (this.rand.nextInt(4) == 0) {
            int j9 = k + this.rand.nextInt(16) + 8;
            int i14 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int k16 = l + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.rand, j9, i14, k16);
        }
        if (this.rand.nextInt(8) == 0) {
            int k9 = k + this.rand.nextInt(16) + 8;
            int j14 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int l16 = l + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.rand, k9, j14, l16);
        }
        for (int l9 = 0; l9 < 10; ++l9) {
            int k14 = k + this.rand.nextInt(16) + 8;
            int i17 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int k18 = l + this.rand.nextInt(16) + 8;
            new WorldGenReed().generate(this.worldObj, this.rand, k14, i17, k18);
        }
        for (int i10 = 0; i10 < 1; ++i10) {
            int l14 = k + this.rand.nextInt(16) + 8;
            int j17 = this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
            int l18 = l + this.rand.nextInt(16) + 8;
            new WorldGenCactus().generate(this.worldObj, this.rand, l14, j17, l18);
        }
        for (int j10 = 0; j10 < 50; ++j10) {
            int i15 = k + this.rand.nextInt(16) + 8;
            int k17 = this.rand.nextInt(this.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS - 8) + 8);
            int i19 = l + this.rand.nextInt(16) + 8;
            new WorldGenLiquids(Block.fluidWaterStill.blockID).generate(this.worldObj, this.rand, i15, k17, i19);
        }
        for (int k10 = 0; k10 < 20; ++k10) {
            int j15 = k + this.rand.nextInt(16) + 8;
            int l17 = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(112) + 8) + 8);
            int j19 = l + this.rand.nextInt(16) + 8;
            new WorldGenLiquids(Block.fluidLavaStill.blockID).generate(this.worldObj, this.rand, j15, l17, j19);
        }
        for (int l10 = k + 8 + 0; l10 < k + 8 + 16; ++l10) {
            for (int k15 = l + 8 + 0; k15 < l + 8 + 16; ++k15) {
                int n = this.worldObj.findTopSolidBlock(l10, k15);
            }
        }
        BlockSand.fallInstantly = false;
    }

    @Override
    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
    }

    @Override
    public void checkForMissingChunks() {
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "RandomLevelSource";
    }
}

