/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EmptyChunk;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.WorldServer;

public class ChunkProviderServer
implements IChunkProvider {
    private Set field_725_a = new HashSet();
    private Chunk dummyChunk;
    public IChunkProvider chunkProvider;
    private IChunkLoader field_729_d;
    public boolean chunkLoadOverride = false;
    private Map id2ChunkMap = new HashMap();
    private List field_727_f = new ArrayList();
    private WorldServer world;

    public ChunkProviderServer(WorldServer worldserver, IChunkLoader ichunkloader, IChunkProvider ichunkprovider) {
        this.dummyChunk = new EmptyChunk(worldserver, new short[256 * Minecraft.WORLD_HEIGHT_BLOCKS], 0, 0);
        this.world = worldserver;
        this.field_729_d = ichunkloader;
        this.chunkProvider = ichunkprovider;
    }

    @Override
    public boolean chunkExists(int i, int j) {
        return this.id2ChunkMap.containsKey(ChunkCoordIntPair.chunkXZ2Int(i, j));
    }

    public void func_35391_d(int i, int j) {
        ChunkCoordinates chunkcoordinates = this.world.getSpawnPoint();
        int k = i * 16 + 8 - chunkcoordinates.x;
        int l = j * 16 + 8 - chunkcoordinates.z;
        int c = 128;
        if (k < -c || k > c || l < -c || l > c) {
            this.field_725_a.add(ChunkCoordIntPair.chunkXZ2Int(i, j));
        }
    }

    @Override
    public Chunk prepareChunk(int i, int j) {
        int k = ChunkCoordIntPair.chunkXZ2Int(i, j);
        this.field_725_a.remove(k);
        Chunk chunk = (Chunk)this.id2ChunkMap.get(k);
        if (chunk == null) {
            chunk = this.func_4063_e(i, j);
            if (chunk == null) {
                chunk = this.chunkProvider == null ? this.dummyChunk : this.chunkProvider.provideChunk(i, j);
            }
            this.id2ChunkMap.put(k, chunk);
            this.field_727_f.add(chunk);
            if (chunk != null) {
                chunk.func_4143_d();
                chunk.onChunkLoad();
            }
            if (!chunk.isTerrainPopulated && this.chunkExists(i + 1, j + 1) && this.chunkExists(i, j + 1) && this.chunkExists(i + 1, j)) {
                this.populate(this, i, j);
            }
            if (this.chunkExists(i - 1, j) && !this.provideChunk((int)(i - 1), (int)j).isTerrainPopulated && this.chunkExists(i - 1, j + 1) && this.chunkExists(i, j + 1) && this.chunkExists(i - 1, j)) {
                this.populate(this, i - 1, j);
            }
            if (this.chunkExists(i, j - 1) && !this.provideChunk((int)i, (int)(j - 1)).isTerrainPopulated && this.chunkExists(i + 1, j - 1) && this.chunkExists(i, j - 1) && this.chunkExists(i + 1, j)) {
                this.populate(this, i, j - 1);
            }
            if (this.chunkExists(i - 1, j - 1) && !this.provideChunk((int)(i - 1), (int)(j - 1)).isTerrainPopulated && this.chunkExists(i - 1, j - 1) && this.chunkExists(i, j - 1) && this.chunkExists(i - 1, j)) {
                this.populate(this, i - 1, j - 1);
            }
        }
        return chunk;
    }

    @Override
    public Chunk provideChunk(int i, int j) {
        Chunk chunk = (Chunk)this.id2ChunkMap.get(ChunkCoordIntPair.chunkXZ2Int(i, j));
        if (chunk == null) {
            if (this.world.findingSpawnPoint || this.chunkLoadOverride) {
                return this.prepareChunk(i, j);
            }
            return this.dummyChunk;
        }
        return chunk;
    }

    private Chunk func_4063_e(int i, int j) {
        if (this.field_729_d == null) {
            return null;
        }
        try {
            Chunk chunk = this.field_729_d.loadChunk(this.world, i, j);
            if (chunk != null) {
                chunk.lastSaveTime = this.world.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void func_375_a(Chunk chunk) {
        if (this.field_729_d == null) {
            return;
        }
        try {
            this.field_729_d.saveExtraChunkData(this.world, chunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_373_b(Chunk chunk) {
        if (this.field_729_d == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.world.getWorldTime();
            this.field_729_d.saveChunk(this.world, chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i, int j) {
        Chunk chunk = this.provideChunk(i, j);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkProvider != null) {
                this.chunkProvider.populate(ichunkprovider, i, j);
                chunk.setChunkModified();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        int i = 0;
        for (int j = 0; j < this.field_727_f.size(); ++j) {
            Chunk chunk = (Chunk)this.field_727_f.get(j);
            if (flag && !chunk.neverSave) {
                this.func_375_a(chunk);
            }
            if (!chunk.needsSaving(flag)) continue;
            this.func_373_b(chunk);
            chunk.isModified = false;
            if (++i != 24 || flag) continue;
            return false;
        }
        if (flag) {
            if (this.field_729_d == null) {
                return true;
            }
            this.field_729_d.saveExtraData();
        }
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        if (!this.world.levelSaving) {
            for (int i = 0; i < 100; ++i) {
                if (this.field_725_a.isEmpty()) continue;
                Integer integer = (Integer)this.field_725_a.iterator().next();
                Chunk chunk = (Chunk)this.id2ChunkMap.get(integer);
                chunk.onChunkUnload();
                this.func_373_b(chunk);
                this.func_375_a(chunk);
                this.field_725_a.remove(integer);
                this.id2ChunkMap.remove(integer);
                this.field_727_f.remove(chunk);
            }
            if (this.field_729_d != null) {
                this.field_729_d.func_814_a();
            }
        }
        return this.chunkProvider.unload100OldestChunks();
    }

    @Override
    public void unloadAllChunks() {
        this.id2ChunkMap.clear();
        this.field_727_f.clear();
        this.field_725_a.clear();
        this.chunkProvider = null;
        System.gc();
    }

    @Override
    public void checkForMissingChunks() {
    }

    @Override
    public boolean canSave() {
        return !this.world.levelSaving;
    }

    @Override
    public String makeString() {
        return "";
    }
}

