/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.ContainerGuidebookRecipeBase;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IRecipe;
import net.minecraft.src.ItemStack;
import net.minecraft.src.RecipeShaped;
import net.minecraft.src.RecipeShapeless;
import net.minecraft.src.SlotGuidebook;

public class ContainerGuidebookRecipeCrafting
extends ContainerGuidebookRecipeBase {
    public IRecipe recipe;

    public ContainerGuidebookRecipeCrafting(IRecipe recipe) {
        this.recipe = recipe;
        if (recipe instanceof RecipeShaped) {
            RecipeShaped r = (RecipeShaped)recipe;
            int slots = 0;
            if (r.recipeHeight > 2 || r.recipeWidth > 2) {
                slots = 10;
                this.addSlot(new SlotGuidebook(slots - 1, 81, 19, r.recipeOutput, false));
                for (int i = 0; i < slots - 1; ++i) {
                    int slotX = i % 3;
                    int slotY = i / 3;
                    if (slotX >= r.recipeWidth || slotY >= r.recipeHeight) {
                        this.addSlot(new SlotGuidebook(i, 1 + 18 * (i % 3), 1 + 18 * (i / 3), null, false));
                        continue;
                    }
                    ItemStack stack = r.recipeItems[slotX + slotY * r.recipeWidth];
                    if (stack != null) {
                        stack = stack.copy();
                        stack.stackSize = 1;
                    }
                    this.addSlot(new SlotGuidebook(i, 1 + 18 * (i % 3), 1 + 18 * (i / 3), stack, false));
                }
            } else {
                slots = 5;
                this.addSlot(new SlotGuidebook(slots - 1, 69, 20, r.recipeOutput, false));
                for (int i = 0; i < slots - 1; ++i) {
                    int slotX = i % 2;
                    int slotY = i / 2;
                    if (slotX >= r.recipeWidth || slotY >= r.recipeHeight) {
                        this.addSlot(new SlotGuidebook(i, 13 + 18 * (i % 2), 10 + 18 * (i / 2), null, false));
                        continue;
                    }
                    ItemStack stack = r.recipeItems[slotX + slotY * r.recipeWidth];
                    if (stack != null) {
                        stack = stack.copy();
                        stack.stackSize = 1;
                    }
                    this.addSlot(new SlotGuidebook(i, 13 + 18 * (i % 2), 10 + 18 * (i / 2), stack, false));
                }
            }
        } else if (recipe instanceof RecipeShapeless) {
            RecipeShapeless r = (RecipeShapeless)recipe;
            int slots = 0;
            if (r.recipeItems.size() > 4) {
                slots = 10;
                this.addSlot(new SlotGuidebook(slots - 1, 81, 19, r.recipeOutput, false));
                for (int i = 0; i < r.recipeItems.size(); ++i) {
                    ItemStack stack = (ItemStack)r.recipeItems.get(i);
                    if (stack != null) {
                        stack = stack.copy();
                        stack.stackSize = 1;
                    }
                    this.addSlot(new SlotGuidebook(i, 1 + 18 * (i % 3), 1 + 18 * (i / 3), stack, false));
                }
            } else {
                slots = 5;
                this.addSlot(new SlotGuidebook(slots - 1, 69, 20, r.recipeOutput, false));
                for (int i = 0; i < r.recipeItems.size(); ++i) {
                    ItemStack stack = (ItemStack)r.recipeItems.get(i);
                    if (stack != null) {
                        stack = stack.copy();
                        stack.stackSize = 1;
                    }
                    this.addSlot(new SlotGuidebook(i, 13 + 18 * (i % 2), 10 + 18 * (i / 2), stack, false));
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported recipe type!!");
        }
    }

    @Override
    public void quickMoveItems(int i, EntityPlayer player, boolean shift, boolean control) {
    }
}

