/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.Block;
import net.minecraft.src.ContainerPlayer;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.SlotCreative;
import net.minecraft.src.StringTranslate;

public class ContainerPlayerCreative
extends ContainerPlayer {
    public int page = 0;
    public int maxPage;
    protected int creativeSlotsStart;
    protected String searchText = "";
    protected List<ItemStack> searchedItems = new ArrayList<ItemStack>();
    public static ItemStack[] creativeItems;
    public static int creativeItemsCount;

    public ContainerPlayerCreative(InventoryPlayer inventoryplayer) {
        this(inventoryplayer, true);
    }

    public ContainerPlayerCreative(InventoryPlayer inventoryplayer, boolean isSinglePlayer) {
        super(inventoryplayer, isSinglePlayer);
        this.creativeSlotsStart = this.inventorySlots.size();
        for (int i = 0; i < 36; ++i) {
            int x = i % 6;
            int y = i / 6;
            this.addSlot(new SlotCreative(this.creativeSlotsStart + i, 174 + x * 18, 30 + y * 18, creativeItems[i]));
        }
        this.searchPage("");
    }

    public void setInventoryStatus(int page, String searchText) {
        if (this.page != page) {
            this.page = page;
            this.updatePage();
        }
        if (!this.searchText.equals(searchText)) {
            this.searchText = searchText;
            this.searchPage(searchText);
        }
    }

    public void lastPage() {
        if (this.page == 0) {
            return;
        }
        --this.page;
        this.updatePage();
    }

    public void nextPage() {
        if (this.page == this.maxPage) {
            return;
        }
        ++this.page;
        this.updatePage();
    }

    public void searchPage(String search) {
        this.searchText = search;
        this.searchedItems.clear();
        this.page = 0;
        StringTranslate t = StringTranslate.getInstance();
        for (int i = 0; i < creativeItemsCount; ++i) {
            if (!t.translateNamedKey(creativeItems[i].getItemName()).toLowerCase().contains(search.toLowerCase())) continue;
            this.searchedItems.add(creativeItems[i]);
        }
        this.updatePage();
    }

    protected void updatePage() {
        this.maxPage = this.searchedItems.size() / 36;
        if (this.searchedItems.size() % 36 == 0) {
            --this.maxPage;
        }
        if (this.maxPage == -1) {
            this.maxPage = 0;
        }
        for (int i = 0; i < 36; ++i) {
            ((SlotCreative)this.inventorySlots.get((int)(this.creativeSlotsStart + i))).item = i + this.page * 36 >= this.searchedItems.size() ? null : this.searchedItems.get(i + this.page * 36);
        }
        this.playerInv.player.updateCreativeInventory(this.page, this.searchText);
    }

    static {
        int j;
        int i;
        creativeItems = new ItemStack[512];
        int count = 0;
        for (i = 0; i < 1000; ++i) {
            if (Block.blocksList[i] == null || Block.blocksList[i].notInCreativeMenu) continue;
            ContainerPlayerCreative.creativeItems[count] = new ItemStack(Block.blocksList[i]);
            ++count;
            if (i == Block.wool.blockID || i == Block.planksOakPainted.blockID || i == Block.lampIdle.blockID || i == Block.fencePlanksOakPainted.blockID) {
                for (j = 1; j < 16; ++j) {
                    ContainerPlayerCreative.creativeItems[count] = new ItemStack(Block.blocksList[i], 1, j);
                    ++count;
                }
                continue;
            }
            if (i != Block.chestPlanksOakPainted.blockID && i != Block.slabPlanksOakPainted.blockID && i != Block.fencegatePlanksOakPainted.blockID && i != Block.stairsPlanksOakPainted.blockID) continue;
            for (j = 16; j < 256; j += 16) {
                ContainerPlayerCreative.creativeItems[count] = new ItemStack(Block.blocksList[i], 1, j);
                ++count;
            }
        }
        for (i = Block.blocksList.length; i < Block.blocksList.length + 2256; ++i) {
            if (Item.itemsList[i] == null || Item.itemsList[i].notInCreativeMenu) continue;
            ContainerPlayerCreative.creativeItems[count] = new ItemStack(Item.itemsList[i]);
            ++count;
            if (i == Item.coal.itemID) {
                for (j = 1; j < 2; ++j) {
                    ContainerPlayerCreative.creativeItems[count] = new ItemStack(Item.itemsList[i], 1, j);
                    ++count;
                }
            }
            if (i != Item.dye.itemID) continue;
            for (j = 1; j < 16; ++j) {
                ContainerPlayerCreative.creativeItems[count] = new ItemStack(Item.itemsList[i], 1, j);
                ++count;
            }
        }
        creativeItemsCount = count;
    }
}

