/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Block;
import net.minecraft.src.Container;
import net.minecraft.src.CraftingManager;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryCraftResult;
import net.minecraft.src.InventoryCrafting;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import net.minecraft.src.SlotCrafting;
import net.minecraft.src.World;

public class ContainerWorkbench
extends Container {
    public InventoryCrafting craftMatrix = new InventoryCrafting(this, 3, 3);
    public IInventory craftResult = new InventoryCraftResult();
    private World field_20133_c;
    private int field_20132_h;
    private int field_20131_i;
    private int field_20130_j;

    public ContainerWorkbench(InventoryPlayer inventoryplayer, World world, int i, int j, int k) {
        this.field_20133_c = world;
        this.field_20132_h = i;
        this.field_20131_i = j;
        this.field_20130_j = k;
        this.addSlot(new SlotCrafting(inventoryplayer.player, this.craftMatrix, this.craftResult, 0, 124, 35));
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 3; ++k1) {
                this.addSlot(new Slot(this.craftMatrix, k1 + l * 3, 30 + k1 * 18, 17 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 3; ++i1) {
            for (int l1 = 0; l1 < 9; ++l1) {
                this.addSlot(new Slot(inventoryplayer, l1 + i1 * 9 + 9, 8 + l1 * 18, 84 + i1 * 18));
            }
        }
        for (int j1 = 0; j1 < 9; ++j1) {
            this.addSlot(new Slot(inventoryplayer, j1, 8 + j1 * 18, 142));
        }
        this.onCraftMatrixChanged(this.craftMatrix);
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory) {
        this.craftResult.setInventorySlotContents(0, CraftingManager.getInstance().findMatchingRecipe(this.craftMatrix));
    }

    @Override
    public void onCraftGuiClosed(EntityPlayer entityplayer) {
        super.onCraftGuiClosed(entityplayer);
        if (this.field_20133_c.isMultiplayerAndNotHost) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack itemstack = this.craftMatrix.getStackInSlot(i);
            if (itemstack == null) continue;
            entityplayer.dropPlayerItem(itemstack);
        }
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        if (this.field_20133_c.getBlockId(this.field_20132_h, this.field_20131_i, this.field_20130_j) != Block.workbench.blockID) {
            return false;
        }
        return entityplayer.getDistanceSq((double)this.field_20132_h + 0.5, (double)this.field_20131_i + 0.5, (double)this.field_20130_j + 0.5) <= 64.0;
    }

    @Override
    public void quickMoveItems(int slotID, EntityPlayer player, boolean shift, boolean control) {
        Slot slot = (Slot)this.inventorySlots.get(slotID);
        if (slot == null || !slot.hasStack()) {
            return;
        }
        ItemStack item = slot.getStack();
        ItemStack originalItem = item.copy();
        if (slotID == 0) {
            ItemStack craftItem;
            int craftCount = 65536;
            if (control && !shift) {
                craftCount = 1;
            }
            if (shift && !control) {
                craftCount = item.getMaxStackSize() / item.stackSize;
            }
            for (int j = 0; j < craftCount && (craftItem = slot.getStack()) != null && craftItem.itemID == originalItem.itemID && craftItem.getMetadata() == originalItem.getMetadata(); ++j) {
                boolean stop = false;
                boolean itemsCrafted = false;
                itemsCrafted = this.onStackMergeShiftClick(craftItem, 10, 46, true);
                if (itemsCrafted) {
                    if (craftItem.stackSize > 0) {
                        player.dropPlayerItem(craftItem.copy());
                        stop = true;
                    }
                } else {
                    stop = true;
                }
                if (craftItem.stackSize == 0) {
                    slot.putStack(null);
                } else {
                    slot.onSlotChanged();
                }
                if (itemsCrafted) {
                    slot.onPickupFromSlot(originalItem);
                }
                if (stop) break;
            }
            return;
        }
        if (slotID >= 10 && slotID < 37) {
            this.onStackMergeShiftClick(item, 1, 10, false);
        } else if (slotID >= 37 && slotID < 46) {
            this.onStackMergeShiftClick(item, 1, 10, false);
        } else {
            this.onStackMergeShiftClick(item, 10, 46, false);
        }
        if (item.stackSize == 0) {
            slot.putStack(null);
        } else {
            slot.onSlotChanged();
        }
        if (item.stackSize != originalItem.stackSize) {
            slot.onPickupFromSlot(originalItem);
        }
    }
}

