/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityWeatherEffect;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class EntityLightningBolt
extends EntityWeatherEffect {
    private int field_27028_b;
    public long field_27029_a = 0L;
    private int field_27030_c;

    public EntityLightningBolt(World world, double d, double d1, double d2) {
        super(world);
        this.setLocationAndAngles(d, d1, d2, 0.0f, 0.0f);
        this.field_27028_b = 2;
        this.field_27029_a = this.rand.nextLong();
        this.field_27030_c = this.rand.nextInt(3) + 1;
        if (world.difficultySetting >= 2 && world.doChunksNearChunkExist(MathHelper.floor_double(d), MathHelper.floor_double(d1), MathHelper.floor_double(d2), 10)) {
            int i1;
            int k;
            int i = MathHelper.floor_double(d);
            if (world.getBlockId(i, k = MathHelper.floor_double(d1), i1 = MathHelper.floor_double(d2)) == 0 && Block.fire.canPlaceBlockAt(world, i, k, i1)) {
                world.setBlockWithNotify(i, k, i1, Block.fire.blockID);
            }
            for (int j = 0; j < 4; ++j) {
                int k1;
                int j1;
                int l = MathHelper.floor_double(d) + this.rand.nextInt(3) - 1;
                if (world.getBlockId(l, j1 = MathHelper.floor_double(d1) + this.rand.nextInt(3) - 1, k1 = MathHelper.floor_double(d2) + this.rand.nextInt(3) - 1) != 0 || !Block.fire.canPlaceBlockAt(world, l, j1, k1)) continue;
                world.setBlockWithNotify(l, j1, k1, Block.fire.blockID);
            }
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_27028_b == 2) {
            this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "ambient.weather.thunder", 10000.0f, 0.8f + this.rand.nextFloat() * 0.2f);
            this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "random.explode", 2.0f, 0.5f + this.rand.nextFloat() * 0.2f);
        }
        --this.field_27028_b;
        if (this.field_27028_b < 0) {
            if (this.field_27030_c == 0) {
                this.setEntityDead();
            } else if (this.field_27028_b < -this.rand.nextInt(10)) {
                int k;
                int j;
                int i;
                --this.field_27030_c;
                this.field_27028_b = 1;
                this.field_27029_a = this.rand.nextLong();
                if (this.worldObj.doChunksNearChunkExist(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ), 10) && this.worldObj.getBlockId(i = MathHelper.floor_double(this.posX), j = MathHelper.floor_double(this.posY), k = MathHelper.floor_double(this.posZ)) == 0 && Block.fire.canPlaceBlockAt(this.worldObj, i, j, k)) {
                    this.worldObj.setBlockWithNotify(i, j, k, Block.fire.blockID);
                }
            }
        }
        if (this.field_27028_b >= 0) {
            double d = 3.0;
            List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, AxisAlignedBB.getBoundingBoxFromPool(this.posX - d, this.posY - d, this.posZ - d, this.posX + d, this.posY + 6.0 + d, this.posZ + d));
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = list.get(l);
                entity.onStruckByLightning(this);
            }
            this.worldObj.lightningFlicker = 2;
        }
    }

    @Override
    protected void entityInit() {
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public boolean isInRangeToRenderVec3D(Vec3D vec3d) {
        return this.field_27028_b >= 0;
    }
}

