/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityArmouredZombie;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityArrowGolden;
import net.minecraft.src.EntityArrowPurple;
import net.minecraft.src.EntityBoat;
import net.minecraft.src.EntityCannonball;
import net.minecraft.src.EntityChicken;
import net.minecraft.src.EntityCow;
import net.minecraft.src.EntityCreeper;
import net.minecraft.src.EntityFallingSand;
import net.minecraft.src.EntityGhast;
import net.minecraft.src.EntityGiantZombie;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityMinecart;
import net.minecraft.src.EntityMob;
import net.minecraft.src.EntityPainting;
import net.minecraft.src.EntityPebble;
import net.minecraft.src.EntityPig;
import net.minecraft.src.EntityPigZombie;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.EntitySlime;
import net.minecraft.src.EntitySnowball;
import net.minecraft.src.EntitySpider;
import net.minecraft.src.EntitySquid;
import net.minecraft.src.EntityTNTPrimed;
import net.minecraft.src.EntityWolf;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;

public class EntityList {
    public static Map<String, Class<? extends Entity>> stringToClassMapping = new HashMap<String, Class<? extends Entity>>();
    public static Map<Class<? extends Entity>, String> classToStringMapping = new HashMap<Class<? extends Entity>, String>();
    private static Map IDtoClassMapping = new HashMap();
    private static Map classToIDMapping = new HashMap();

    private static void addMapping(Class<? extends Entity> class1, String s, int i) {
        stringToClassMapping.put(s, class1);
        classToStringMapping.put(class1, s);
        IDtoClassMapping.put(i, class1);
        classToIDMapping.put(class1, i);
    }

    public static Entity createEntityInWorld(String s, World world) {
        Entity entity = null;
        try {
            Class<? extends Entity> class1 = stringToClassMapping.get(s);
            if (class1 != null) {
                entity = class1.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public static Entity createEntityFromNBT(NBTTagCompound nbttagcompound, World world) {
        Entity entity = null;
        try {
            Class<? extends Entity> class1 = stringToClassMapping.get(nbttagcompound.getString("id"));
            if (class1 != null) {
                entity = class1.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity != null) {
            entity.readFromNBT(nbttagcompound);
        } else {
            System.out.println("Skipping Entity with id " + nbttagcompound.getString("id"));
        }
        return entity;
    }

    public static Entity createEntity(int i, World world) {
        Entity entity = null;
        try {
            Class class1 = (Class)IDtoClassMapping.get(i);
            if (class1 != null) {
                entity = (Entity)class1.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            System.out.println("Skipping Entity with id " + i);
        }
        return entity;
    }

    public static int getEntityID(Entity entity) {
        return (Integer)classToIDMapping.get(entity.getClass());
    }

    public static String getEntityString(Entity entity) {
        return classToStringMapping.get(entity.getClass());
    }

    static {
        EntityList.addMapping(EntityArrow.class, "Arrow", 10);
        EntityList.addMapping(EntitySnowball.class, "Snowball", 11);
        EntityList.addMapping(EntityItem.class, "Item", 1);
        EntityList.addMapping(EntityPainting.class, "Painting", 9);
        EntityList.addMapping(EntityLiving.class, "Mob", 48);
        EntityList.addMapping(EntityMob.class, "Monster", 49);
        EntityList.addMapping(EntityCreeper.class, "Creeper", 50);
        EntityList.addMapping(EntitySkeleton.class, "Skeleton", 51);
        EntityList.addMapping(EntitySpider.class, "Spider", 52);
        EntityList.addMapping(EntityGiantZombie.class, "Giant", 53);
        EntityList.addMapping(EntityZombie.class, "Zombie", 54);
        EntityList.addMapping(EntitySlime.class, "Slime", 55);
        EntityList.addMapping(EntityGhast.class, "Ghast", 56);
        EntityList.addMapping(EntityPigZombie.class, "PigZombie", 57);
        EntityList.addMapping(EntityPig.class, "Pig", 90);
        EntityList.addMapping(EntitySheep.class, "Sheep", 91);
        EntityList.addMapping(EntityCow.class, "Cow", 92);
        EntityList.addMapping(EntityChicken.class, "Chicken", 93);
        EntityList.addMapping(EntitySquid.class, "Squid", 94);
        EntityList.addMapping(EntityWolf.class, "Wolf", 95);
        EntityList.addMapping(EntityTNTPrimed.class, "PrimedTnt", 20);
        EntityList.addMapping(EntityFallingSand.class, "FallingSand", 21);
        EntityList.addMapping(EntityMinecart.class, "Minecart", 40);
        EntityList.addMapping(EntityBoat.class, "Boat", 41);
        EntityList.addMapping(EntityArmouredZombie.class, "ArmouredZombie", 42);
        EntityList.addMapping(EntityArrowGolden.class, "ArrowGolden", 43);
        EntityList.addMapping(EntityCannonball.class, "Cannonball", 44);
        EntityList.addMapping(EntityArrowPurple.class, "ArrowPurple", 45);
        EntityList.addMapping(EntityPebble.class, "Pebble", 46);
    }
}

