/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.StepSound;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.helper.DamageType;
import net.minecraft.src.helper.Direction;
import net.minecraft.src.helper.PlacementMode;

public abstract class EntityLiving
extends Entity {
    public int heartsHalvesLife = 20;
    public float field_9365_p;
    public float field_9363_r;
    public float renderYawOffset = 0.0f;
    public float prevRenderYawOffset = 0.0f;
    protected float field_9362_u;
    protected float field_9361_v;
    protected float field_9360_w;
    protected float field_9359_x;
    protected boolean field_9358_y = true;
    protected String texture = "/mob/char.png";
    protected boolean field_9355_A = true;
    protected float field_9353_B = 0.0f;
    protected String field_9351_C = null;
    protected float field_9349_D = 1.0f;
    protected int scoreValue = 0;
    protected float field_9345_F = 0.0f;
    public boolean isMultiplayerEntity = false;
    public float prevSwingProgress;
    public float swingProgress;
    public int health = 10;
    public int prevHealth;
    private int livingSoundTime;
    public int hurtTime;
    public int maxHurtTime;
    public float attackedAtYaw = 0.0f;
    public int deathTime = 0;
    public int attackTime = 0;
    public float cameraPitch;
    public float field_9328_R;
    protected boolean unused_flag = false;
    public int field_9326_T = -1;
    public float field_9325_U;
    public float field_705_Q;
    public float field_704_R;
    public float field_703_S;
    protected int newPosRotationIncrements;
    protected double newPosX;
    protected double newPosY;
    protected double newPosZ;
    protected double newRotationYaw;
    protected double newRotationPitch;
    float field_9348_ae = 0.0f;
    protected int field_9346_af = 0;
    protected int entityAge = 0;
    protected float moveStrafing;
    protected float moveForward;
    protected float lookYaw;
    protected float lookPitch;
    protected float randomYawVelocity;
    protected boolean isJumping = false;
    protected float defaultPitch = 0.0f;
    protected float moveSpeed = 0.7f;
    protected float flySpeed;
    private Entity currentTarget;
    protected int numTicksToChaseTarget = 0;
    public String nickname = "";
    public byte chatColor = 0;
    public Direction rotationLock = null;
    public Direction rotationLockHorizontal = null;
    public Direction rotationLockVertical = null;
    public PlacementMode placementMode = PlacementMode.FACING;

    public EntityLiving(World world) {
        super(world);
        this.field_9325_U = (float)(Math.random() * (double)0.9f + (double)0.1f);
        this.preventEntitySpawning = true;
        this.field_9363_r = (float)(Math.random() + 1.0) * 0.01f;
        this.setPosition(this.posX, this.posY, this.posZ);
        this.field_9365_p = (float)Math.random() * 12398.0f;
        this.rotationYaw = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.stepHeight = 0.5f;
        this.flySpeed = 0.6f;
    }

    @Override
    protected void entityInit() {
    }

    public boolean canEntityBeSeen(Entity entity) {
        return this.worldObj.rayTraceBlocks(Vec3D.createVector(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ), Vec3D.createVector(entity.posX, entity.posY + (double)entity.getEyeHeight(), entity.posZ)) == null;
    }

    @Override
    public String getEntityTexture() {
        return this.texture;
    }

    @Override
    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    @Override
    public boolean canBePushed() {
        return !this.isDead;
    }

    @Override
    public float getEyeHeight() {
        return this.height * 0.85f;
    }

    public int getTalkInterval() {
        return 80;
    }

    public String getDisplayName() {
        return ChatColor.get(this.chatColor) + this.nickname;
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        ItemStack item = entityplayer.inventory.getCurrentItem();
        if (item != null && item.itemID == Item.label.itemID && item.tag.getBoolean("overrideName")) {
            --item.stackSize;
            if (item.stackSize <= 0) {
                entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
            }
            this.nickname = item.tag.getString("name");
            this.chatColor = item.tag.getByte("color");
            this.hadNicknameSet = true;
            return true;
        }
        return false;
    }

    public void playLivingSound() {
        String s = this.getLivingSound();
        if (s != null) {
            this.worldObj.playSoundAtEntity(this, s, this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public void onEntityUpdate() {
        this.prevSwingProgress = this.swingProgress;
        super.onEntityUpdate();
        if (this.rand.nextInt(1000) < this.livingSoundTime++) {
            this.livingSoundTime = -this.getTalkInterval();
            this.playLivingSound();
        }
        if (this.isEntityAlive() && this.isEntityInsideOpaqueBlock() && !this.noClip) {
            this.attackEntityFrom(null, 1, null);
        }
        if (this.isImmuneToFire || this.worldObj.isMultiplayerAndNotHost) {
            this.fire = 0;
        }
        if (this.isEntityAlive() && this.isInsideOfMaterial(Material.water) && !this.canBreatheUnderwater()) {
            --this.air;
            if (this.air == -20) {
                this.air = 0;
                for (int i = 0; i < 8; ++i) {
                    float f = this.rand.nextFloat() - this.rand.nextFloat();
                    float f1 = this.rand.nextFloat() - this.rand.nextFloat();
                    float f2 = this.rand.nextFloat() - this.rand.nextFloat();
                    this.worldObj.spawnParticle("bubble", this.posX + (double)f, this.posY + (double)f1, this.posZ + (double)f2, this.motionX, this.motionY, this.motionZ);
                }
                this.attackEntityFrom(null, 2, DamageType.DROWN);
            }
            this.fire = 0;
        } else {
            this.air = this.maxAir;
        }
        this.cameraPitch = this.field_9328_R;
        if (this.attackTime > 0) {
            --this.attackTime;
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.heartsFlashTime > 0) {
            --this.heartsFlashTime;
        }
        if (this.health <= 0) {
            ++this.deathTime;
            if (this.deathTime > 20) {
                this.onEntityDeath();
                this.setEntityDead();
                for (int j = 0; j < 20; ++j) {
                    double d = this.rand.nextGaussian() * 0.02;
                    double d1 = this.rand.nextGaussian() * 0.02;
                    double d2 = this.rand.nextGaussian() * 0.02;
                    this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
                }
            }
        }
        this.field_9359_x = this.field_9360_w;
        this.prevRenderYawOffset = this.renderYawOffset;
        this.prevRotationYaw = this.rotationYaw;
        this.prevRotationPitch = this.rotationPitch;
    }

    public void spawnExplosionParticle() {
        for (int i = 0; i < 20; ++i) {
            double d = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            double d3 = 10.0;
            this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - d * d3, this.posY + (double)(this.rand.nextFloat() * this.height) - d1 * d3, this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width - d2 * d3, d, d1, d2);
        }
    }

    @Override
    public void updateRidden() {
        super.updateRidden();
        this.field_9362_u = this.field_9361_v;
        this.field_9361_v = 0.0f;
    }

    @Override
    public void setPositionAndRotation2(double d, double d1, double d2, float f, float f1, int i) {
        this.yOffset = 0.0f;
        this.newPosX = d;
        this.newPosY = d1;
        this.newPosZ = d2;
        this.newRotationYaw = f;
        this.newRotationPitch = f1;
        this.newPosRotationIncrements = i;
    }

    @Override
    public void onUpdate() {
        boolean flag;
        float f5;
        float f4;
        super.onUpdate();
        this.onLivingUpdate();
        double d = this.posX - this.prevPosX;
        double d1 = this.posZ - this.prevPosZ;
        float f = MathHelper.sqrt_double(d * d + d1 * d1);
        float f1 = this.renderYawOffset;
        float f2 = 0.0f;
        this.field_9362_u = this.field_9361_v;
        float f3 = 0.0f;
        if (f > 0.05f) {
            f3 = 1.0f;
            f2 = f * 3.0f;
            f1 = (float)Math.atan2(d1, d) * 180.0f / 3.141593f - 90.0f;
        }
        if (this.swingProgress > 0.0f) {
            f1 = this.rotationYaw;
        }
        if (!this.onGround) {
            f3 = 0.0f;
        }
        this.field_9361_v += (f3 - this.field_9361_v) * 0.3f;
        for (f4 = f1 - this.renderYawOffset; f4 < -180.0f; f4 += 360.0f) {
        }
        while (f4 >= 180.0f) {
            f4 -= 360.0f;
        }
        this.renderYawOffset += f4 * 0.3f;
        for (f5 = this.rotationYaw - this.renderYawOffset; f5 < -180.0f; f5 += 360.0f) {
        }
        while (f5 >= 180.0f) {
            f5 -= 360.0f;
        }
        boolean bl = flag = f5 < -90.0f || f5 >= 90.0f;
        if (f5 < -75.0f) {
            f5 = -75.0f;
        }
        if (f5 >= 75.0f) {
            f5 = 75.0f;
        }
        this.renderYawOffset = this.rotationYaw - f5;
        if (f5 * f5 > 2500.0f) {
            this.renderYawOffset += f5 * 0.2f;
        }
        if (flag) {
            f2 *= -1.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset < -180.0f) {
            this.prevRenderYawOffset -= 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset >= 180.0f) {
            this.prevRenderYawOffset += 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        this.field_9360_w += f2;
    }

    @Override
    protected void setSize(float f, float f1) {
        super.setSize(f, f1);
    }

    public void heal(int i) {
        if (this.health <= 0) {
            return;
        }
        this.health += i;
        if (this.health > 20) {
            this.health = 20;
        }
        this.heartsFlashTime = this.heartsHalvesLife / 2;
    }

    @Override
    public boolean attackEntityFrom(Entity entity, int damage, DamageType type) {
        if (this.worldObj.isMultiplayerAndNotHost) {
            return false;
        }
        this.entityAge = 0;
        if (this.health <= 0) {
            return false;
        }
        this.field_704_R = 1.5f;
        boolean flag = true;
        if ((float)this.heartsFlashTime > (float)this.heartsHalvesLife / 2.0f) {
            if (damage <= this.field_9346_af) {
                return false;
            }
            this.damageEntity(damage - this.field_9346_af, type);
            this.field_9346_af = damage;
            flag = false;
        } else {
            this.field_9346_af = damage;
            this.prevHealth = this.health;
            this.heartsFlashTime = this.heartsHalvesLife;
            this.damageEntity(damage, type);
            this.maxHurtTime = 10;
            this.hurtTime = 10;
        }
        this.attackedAtYaw = 0.0f;
        if (flag) {
            this.setBeenAttacked();
            if (entity != null) {
                double d = entity.posX - this.posX;
                double d1 = entity.posZ - this.posZ;
                while (d * d + d1 * d1 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    d1 = (Math.random() - Math.random()) * 0.01;
                }
                this.attackedAtYaw = (float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - this.rotationYaw;
                this.knockBack(entity, damage, d, d1);
            } else {
                this.attackedAtYaw = (int)(Math.random() * 2.0) * 180;
            }
            this.worldObj.sendTrackedEntityStatusUpdatePacket(this, (byte)2, this.attackedAtYaw);
        }
        if (this.health <= 0) {
            if (flag) {
                this.worldObj.playSoundAtEntity(this, this.getDeathSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            }
            this.onDeath(entity);
        } else if (flag) {
            this.worldObj.playSoundAtEntity(this, this.getHurtSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
        return true;
    }

    @Override
    public void performHurtAnimation() {
        this.maxHurtTime = 10;
        this.hurtTime = 10;
        this.attackedAtYaw = 0.0f;
    }

    protected void damageEntity(int i, DamageType damageType) {
        this.health -= i;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "random.hurt";
    }

    protected String getDeathSound() {
        return "random.hurt";
    }

    public void knockBack(Entity entity, int i, double d, double d1) {
        float f = MathHelper.sqrt_double(d * d + d1 * d1);
        float f1 = 0.4f;
        this.motionX /= 2.0;
        this.motionY /= 2.0;
        this.motionZ /= 2.0;
        this.motionX -= d / (double)f * (double)f1;
        this.motionY += (double)0.4f;
        this.motionZ -= d1 / (double)f * (double)f1;
        if (this.motionY > (double)0.4f) {
            this.motionY = 0.4f;
        }
    }

    public void onDeath(Entity entity) {
        if (this.scoreValue >= 0 && entity != null) {
            entity.addToPlayerScore(this, this.scoreValue);
        }
        if (entity != null) {
            entity.onKillEntity(this);
        }
        this.unused_flag = true;
        if (!this.worldObj.isMultiplayerAndNotHost) {
            this.dropFewItems();
        }
        this.worldObj.sendTrackedEntityStatusUpdatePacket(this, (byte)3);
    }

    protected void dropFewItems() {
        int i = this.getDropItemId();
        if (i > 0) {
            int j = this.rand.nextInt(2) + 1;
            for (int k = 0; k < j; ++k) {
                this.dropItem(i, 1);
            }
        }
    }

    protected int getDropItemId() {
        return 0;
    }

    @Override
    protected void fall(float f) {
        super.fall(f);
        int i = (int)Math.ceil(f - 3.0f);
        if (i > 0) {
            this.attackEntityFrom(null, i, DamageType.FALL);
            int j = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset), MathHelper.floor_double(this.posZ));
            if (j > 0) {
                StepSound stepsound = Block.blocksList[j].stepSound;
                this.worldObj.playSoundAtEntity(this, stepsound.func_1145_d(), stepsound.getVolume() * 0.5f, stepsound.getPitch() * 0.75f);
            }
        }
    }

    public void changeFlySpeed(int k) {
        if (k > 0 && this.flySpeed < 0.7f) {
            this.flySpeed += 0.02f;
        }
        if (k < 0 && this.flySpeed > 0.0f) {
            this.flySpeed -= 0.02f;
        }
    }

    public void moveEntityWithHeading(float f, float f1) {
        if (this instanceof EntityPlayer && ((EntityPlayer)this).noClip) {
            if (this.isJumping) {
                this.motionY = 0.5;
            }
            if (this.isSneaking()) {
                this.motionY = -0.5;
            }
            if (this.isSneaking() && this.isJumping) {
                this.motionY = 0.0;
            }
            this.moveFlying(f * 1.25f, f1 * 1.25f, 0.2f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)this.flySpeed;
            this.motionY *= 0.4;
            this.motionZ *= (double)this.flySpeed;
            this.onGround = true;
            this.fallDistance = 0.0f;
        } else if (this.isInWater()) {
            double d = this.posY;
            this.moveFlying(f, f1, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= (double)0.8f;
            this.motionY *= (double)0.8f;
            this.motionZ *= (double)0.8f;
            this.motionY -= 0.02;
            if (this.isCollidedHorizontally && this.isOffsetPositionInLiquid(this.motionX, this.motionY + (double)0.6f - this.posY + d, this.motionZ)) {
                this.motionY = 0.3f;
            }
        } else if (this.handleLavaMovement()) {
            double d1 = this.posY;
            this.moveFlying(f, f1, 0.02f);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
            this.motionY -= 0.02;
            if (this.isCollidedHorizontally && this.isOffsetPositionInLiquid(this.motionX, this.motionY + (double)0.6f - this.posY + d1, this.motionZ)) {
                this.motionY = 0.3f;
            }
        } else {
            float f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.5460001f;
                int i = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
                if (i > 0) {
                    f2 = Block.blocksList[i].slipperiness * 0.91f;
                }
            }
            float f3 = 0.1627714f / (f2 * f2 * f2);
            this.moveFlying(f, f1, this.onGround ? 0.1f * f3 : 0.02f);
            f2 = 0.91f;
            if (this.onGround) {
                f2 = 0.5460001f;
                int j = this.worldObj.getBlockId(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.boundingBox.minY) - 1, MathHelper.floor_double(this.posZ));
                if (j > 0) {
                    f2 = Block.blocksList[j].slipperiness * 0.91f;
                }
            }
            if (this.isOnLadder()) {
                float f4 = 0.15f;
                if (this.motionX < (double)(-f4)) {
                    this.motionX = -f4;
                }
                if (this.motionX > (double)f4) {
                    this.motionX = f4;
                }
                if (this.motionZ < (double)(-f4)) {
                    this.motionZ = -f4;
                }
                if (this.motionZ > (double)f4) {
                    this.motionZ = f4;
                }
                this.fallDistance = 0.0f;
                if (this.motionY < -0.15) {
                    this.motionY = -0.15;
                }
                if (this.isSneaking() && this.motionY < 0.0) {
                    this.motionY = 0.0;
                }
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            if (this.isCollidedHorizontally && this.isOnLadder()) {
                this.motionY = 0.2;
            }
            this.motionY -= 0.08;
            this.motionY *= (double)0.98f;
            this.motionX *= (double)f2;
            this.motionZ *= (double)f2;
        }
        this.field_705_Q = this.field_704_R;
        double d2 = this.posX - this.prevPosX;
        double d3 = this.posZ - this.prevPosZ;
        float f5 = MathHelper.sqrt_double(d2 * d2 + d3 * d3) * 4.0f;
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        this.field_704_R += (f5 - this.field_704_R) * 0.4f;
        this.field_703_S += this.field_704_R;
    }

    public boolean isOnLadder() {
        int k;
        int j;
        int i = MathHelper.floor_double(this.posX);
        return this.worldObj.getBlockId(i, j = MathHelper.floor_double(this.boundingBox.minY), k = MathHelper.floor_double(this.posZ)) == Block.ladderOak.blockID;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("Health", (short)this.health);
        nbttagcompound.setShort("HurtTime", (short)this.hurtTime);
        nbttagcompound.setShort("DeathTime", (short)this.deathTime);
        nbttagcompound.setShort("AttackTime", (short)this.attackTime);
        nbttagcompound.setString("Nickname", this.nickname);
        nbttagcompound.setByte("ChatColor", this.chatColor);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.health = nbttagcompound.getShort("Health");
        if (!nbttagcompound.hasKey("Health")) {
            this.health = 10;
        }
        this.hurtTime = nbttagcompound.getShort("HurtTime");
        this.deathTime = nbttagcompound.getShort("DeathTime");
        this.attackTime = nbttagcompound.getShort("AttackTime");
        this.nickname = nbttagcompound.getString("Nickname");
        this.chatColor = nbttagcompound.getByte("ChatColor");
    }

    @Override
    public boolean isEntityAlive() {
        return !this.isDead && this.health > 0;
    }

    public boolean canBreatheUnderwater() {
        return false;
    }

    public void onLivingUpdate() {
        if (this.newPosRotationIncrements > 0) {
            double d3;
            double d = this.posX + (this.newPosX - this.posX) / (double)this.newPosRotationIncrements;
            double d1 = this.posY + (this.newPosY - this.posY) / (double)this.newPosRotationIncrements;
            double d2 = this.posZ + (this.newPosZ - this.posZ) / (double)this.newPosRotationIncrements;
            for (d3 = this.newRotationYaw - (double)this.rotationYaw; d3 < -180.0; d3 += 360.0) {
            }
            while (d3 >= 180.0) {
                d3 -= 360.0;
            }
            this.rotationYaw = (float)((double)this.rotationYaw + d3 / (double)this.newPosRotationIncrements);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.newRotationPitch - (double)this.rotationPitch) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.setPosition(d, d1, d2);
            this.setRotation(this.rotationYaw, this.rotationPitch);
            List<AxisAlignedBB> list1 = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getInsetBoundingBox(0.03125, 0.0, 0.03125));
            if (list1.size() > 0) {
                double d4 = 0.0;
                for (int j = 0; j < list1.size(); ++j) {
                    AxisAlignedBB axisalignedbb = list1.get(j);
                    if (!(axisalignedbb.maxY > d4)) continue;
                    d4 = axisalignedbb.maxY;
                }
                this.setPosition(d, d1 += d4 - this.boundingBox.minY, d2);
            }
        }
        if (this.isMovementBlocked()) {
            this.isJumping = false;
            this.moveStrafing = 0.0f;
            this.moveForward = 0.0f;
            this.randomYawVelocity = 0.0f;
        } else if (!this.isMultiplayerEntity) {
            this.updatePlayerActionState();
        }
        boolean flag = this.isInWater();
        boolean flag1 = this.handleLavaMovement();
        if (this.isJumping) {
            if (flag) {
                this.motionY += 0.04;
            } else if (flag1) {
                this.motionY += 0.04;
            } else if (this.onGround) {
                this.jump();
            }
        }
        this.moveStrafing *= 0.98f;
        this.moveForward *= 0.98f;
        this.randomYawVelocity *= 0.9f;
        this.moveEntityWithHeading(this.moveStrafing, this.moveForward);
        List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = list.get(i);
                if (!entity.canBePushed()) continue;
                entity.applyEntityCollision(this);
            }
        }
    }

    protected boolean isMovementBlocked() {
        return this.health <= 0;
    }

    protected void jump() {
        this.motionY = 0.42;
    }

    protected boolean canDespawn() {
        return this.nickname.isEmpty();
    }

    protected void tryToDespawn() {
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, -1.0);
        if (this.canDespawn() && entityplayer != null) {
            double d = entityplayer.posX - this.posX;
            double d1 = entityplayer.posY - this.posY;
            double d2 = entityplayer.posZ - this.posZ;
            double d3 = d * d + d1 * d1 + d2 * d2;
            if (d3 > 16384.0) {
                this.setEntityDead();
            }
            if (this.entityAge > 600 && this.rand.nextInt(800) == 0) {
                if (d3 < 1024.0) {
                    this.entityAge = 0;
                } else {
                    this.setEntityDead();
                }
            }
        }
    }

    protected void updatePlayerActionState() {
        ++this.entityAge;
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, -1.0);
        this.tryToDespawn();
        this.moveStrafing = 0.0f;
        this.moveForward = 0.0f;
        float f = 8.0f;
        if (this.rand.nextFloat() < 0.02f) {
            EntityPlayer entityplayer1 = this.worldObj.getClosestPlayerToEntity(this, f);
            if (entityplayer1 != null) {
                this.currentTarget = entityplayer1;
                this.numTicksToChaseTarget = 10 + this.rand.nextInt(20);
            } else {
                this.randomYawVelocity = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.currentTarget != null) {
            this.faceEntity(this.currentTarget, 10.0f, this.func_25026_x());
            if (this.numTicksToChaseTarget-- <= 0 || this.currentTarget.isDead || this.currentTarget.getDistanceSqToEntity(this) > (double)(f * f)) {
                this.currentTarget = null;
            }
        } else {
            if (this.rand.nextFloat() < 0.05f) {
                this.randomYawVelocity = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
            this.rotationYaw += this.randomYawVelocity;
            this.rotationPitch = this.defaultPitch;
        }
        boolean flag = this.isInWater();
        boolean flag1 = this.handleLavaMovement();
        if (flag || flag1) {
            this.isJumping = this.rand.nextFloat() < 0.8f;
        }
    }

    protected int func_25026_x() {
        return 40;
    }

    public void faceEntity(Entity entity, float f, float f1) {
        double d1;
        double d = entity.posX - this.posX;
        double d2 = entity.posZ - this.posZ;
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            d1 = this.posY + (double)this.getEyeHeight() - (entityliving.posY + (double)entityliving.getEyeHeight());
        } else {
            d1 = (entity.boundingBox.minY + entity.boundingBox.maxY) / 2.0 - (this.posY + (double)this.getEyeHeight());
        }
        double d3 = MathHelper.sqrt_double(d * d + d2 * d2);
        float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
        float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
        this.rotationPitch = -this.updateRotation(this.rotationPitch, f3, f1);
        this.rotationYaw = this.updateRotation(this.rotationYaw, f2, f);
    }

    public boolean hasCurrentTarget() {
        return this.currentTarget != null;
    }

    public Entity getCurrentTarget() {
        return this.currentTarget;
    }

    private float updateRotation(float f, float f1, float f2) {
        float f3;
        for (f3 = f1 - f; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < -f2) {
            f3 = -f2;
        }
        return f + f3;
    }

    public void onEntityDeath() {
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.checkIfAABBIsClear(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0 && !this.worldObj.getIsAnyLiquid(this.boundingBox);
    }

    @Override
    protected void kill() {
        this.attackEntityFrom(null, 4, null);
    }

    public float getSwingProgress(float f) {
        float f1 = this.swingProgress - this.prevSwingProgress;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.prevSwingProgress + f1 * f;
    }

    public Vec3D getPosition(float f) {
        if (f == 1.0f) {
            return Vec3D.createVector(this.posX, this.posY, this.posZ);
        }
        double d = this.prevPosX + (this.posX - this.prevPosX) * (double)f;
        double d1 = this.prevPosY + (this.posY - this.prevPosY) * (double)f;
        double d2 = this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f;
        return Vec3D.createVector(d, d1, d2);
    }

    @Override
    public Vec3D getLookVec() {
        return this.getLook(1.0f);
    }

    public Vec3D getLook(float f) {
        if (f == 1.0f) {
            float f1 = MathHelper.cos(-this.rotationYaw * 0.01745329f - 3.141593f);
            float f3 = MathHelper.sin(-this.rotationYaw * 0.01745329f - 3.141593f);
            float f5 = -MathHelper.cos(-this.rotationPitch * 0.01745329f);
            float f7 = MathHelper.sin(-this.rotationPitch * 0.01745329f);
            return Vec3D.createVector(f3 * f5, f7, f1 * f5);
        }
        float f2 = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * f;
        float f4 = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * f;
        float f6 = MathHelper.cos(-f4 * 0.01745329f - 3.141593f);
        float f8 = MathHelper.sin(-f4 * 0.01745329f - 3.141593f);
        float f9 = -MathHelper.cos(-f2 * 0.01745329f);
        float f10 = MathHelper.sin(-f2 * 0.01745329f);
        return Vec3D.createVector(f8 * f9, f10, f6 * f9);
    }

    public MovingObjectPosition rayTrace(double d, float f) {
        Vec3D vec3d = this.getPosition(f);
        Vec3D vec3d1 = this.getLook(f);
        Vec3D vec3d2 = vec3d.addVector(vec3d1.xCoord * d, vec3d1.yCoord * d, vec3d1.zCoord * d);
        return this.worldObj.rayTraceBlocks(vec3d, vec3d2);
    }

    public int getMaxSpawnedInChunk() {
        return 4;
    }

    public ItemStack getHeldItem() {
        return null;
    }

    @Override
    public void handleEntityStatus(byte byte0, float attackedAtYaw) {
        if (byte0 == 2) {
            this.field_704_R = 1.5f;
            this.heartsFlashTime = this.heartsHalvesLife;
            this.maxHurtTime = 10;
            this.hurtTime = 10;
            this.attackedAtYaw = attackedAtYaw;
            this.worldObj.playSoundAtEntity(this, this.getHurtSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.attackEntityFrom(null, 0, null);
        } else if (byte0 == 3) {
            this.worldObj.playSoundAtEntity(this, this.getDeathSound(), this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.health = 0;
            this.onDeath(null);
        } else {
            super.handleEntityStatus(byte0, attackedAtYaw);
        }
    }

    public boolean isPlayerSleeping() {
        return false;
    }

    public int getItemIcon(ItemStack itemstack) {
        return itemstack.getIconIndex();
    }

    public Direction getPlacementDirection(Direction side, PlacementMode placementMode) {
        if (this.rotationLock != null) {
            return this.rotationLock;
        }
        if (placementMode == PlacementMode.SIDE) {
            return side;
        }
        return Direction.getDirection(this);
    }

    public Direction getPlacementDirection(Direction side) {
        return this.getPlacementDirection(side, this.placementMode);
    }

    public Direction getHorizontalPlacementDirection(Direction side, PlacementMode placementMode) {
        if (this.rotationLockHorizontal != null) {
            return this.rotationLockHorizontal;
        }
        if (placementMode == PlacementMode.SIDE && side != null && side.isHorizontal()) {
            return side;
        }
        return Direction.getHorizontalDirection(this);
    }

    public Direction getHorizontalPlacementDirection(Direction side) {
        return this.getHorizontalPlacementDirection(side, this.placementMode);
    }

    public Direction getVerticalPlacementDirection(Direction side, double sideHeight) {
        Direction dir = Direction.DOWN;
        if (side.isHorizontal()) {
            if (sideHeight > 0.5) {
                dir = Direction.UP;
            }
        } else {
            dir = side;
        }
        if (this.rotationLockVertical != null) {
            dir = this.rotationLockVertical;
        }
        return dir;
    }
}

