/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Chunk;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IMob;
import net.minecraft.src.Item;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class EntitySlime
extends EntityLiving
implements IMob {
    public float field_768_a;
    public float field_767_b;
    private int slimeJumpDelay = 0;
    private boolean hasSlimeSplit;
    private boolean sizeSet = false;

    public EntitySlime(World world) {
        super(world);
        this.texture = "/mob/slime.png";
        this.yOffset = 0.0f;
        this.slimeJumpDelay = 20;
        this.scoreValue = 100;
        this.hasSlimeSplit = false;
    }

    public EntitySlime(World world, boolean isSplit) {
        super(world);
        this.texture = "/mob/slime.png";
        this.yOffset = 0.0f;
        this.slimeJumpDelay = 20;
        this.scoreValue = 100;
        this.hasSlimeSplit = isSplit;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (byte)1);
    }

    @Override
    public void entityInitOnSpawn() {
        super.entityInit();
        if (!this.hasSlimeSplit) {
            int size = this.rand.nextInt(3) + 1;
            if (size == 3) {
                size = 4;
            }
            this.setSlimeSize(size);
        }
    }

    public void setSlimeSize(int i) {
        this.dataWatcher.updateObject(16, (byte)i);
        this.setSize(0.5f * (float)i, 0.5f * (float)i);
        this.health = i * i;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public int getSlimeSize() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setInteger("Size", this.getSlimeSize() - 1);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSlimeSize(nbttagcompound.getInteger("Size") + 1);
    }

    @Override
    public void onUpdate() {
        if (!this.sizeSet) {
            this.setSlimeSize(this.getSlimeSize());
            this.sizeSet = true;
        }
        this.field_767_b = this.field_768_a;
        boolean flag = this.onGround;
        super.onUpdate();
        if (this.onGround && !flag) {
            int i = this.getSlimeSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.rand.nextFloat() * 3.141593f * 2.0f;
                float f1 = this.rand.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.sin(f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.cos(f) * (float)i * 0.5f * f1;
                this.worldObj.spawnParticle("slime", this.posX + (double)f2, this.boundingBox.minY, this.posZ + (double)f3, 0.0, 0.0, 0.0);
            }
            if (i > 2) {
                this.worldObj.playSoundAtEntity(this, "mob.slime", this.getSoundVolume(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.field_768_a = -0.5f;
        }
        if (!this.worldObj.isMultiplayerAndNotHost && this.worldObj.difficultySetting == 0) {
            this.setEntityDead();
        }
        this.field_768_a *= 0.6f;
    }

    @Override
    protected void updatePlayerActionState() {
        boolean targetPlayer;
        this.tryToDespawn();
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, 16.0);
        boolean bl = targetPlayer = entityplayer != null && entityplayer.getGamemode().areMobsHostile;
        if (entityplayer != null && targetPlayer) {
            this.faceEntity(entityplayer, 10.0f, 20.0f);
        }
        if (this.onGround && this.slimeJumpDelay-- <= 0) {
            if (!targetPlayer) {
                float rotation = (this.worldObj.rand.nextFloat() - 0.5f) * 90.0f;
                this.rotationYaw += rotation;
            }
            this.slimeJumpDelay = this.rand.nextInt(20) + 10;
            if (entityplayer != null) {
                this.slimeJumpDelay /= 3;
            }
            this.isJumping = true;
            if (this.getSlimeSize() > 1) {
                this.worldObj.playSoundAtEntity(this, "mob.slime", this.getSoundVolume(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_768_a = 1.0f;
            this.moveStrafing = 1.0f - this.rand.nextFloat() * 2.0f;
            this.moveForward = this.getSlimeSize();
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.moveForward = 0.0f;
                this.moveStrafing = 0.0f;
            }
        }
    }

    @Override
    public void setEntityDead() {
        int size = this.getSlimeSize();
        if (!this.worldObj.isMultiplayerAndNotHost && size > 1 && this.health <= 0) {
            int splitCount = this.worldObj.rand.nextInt(4) + 1;
            for (int j = 0; j < splitCount; ++j) {
                float f = ((float)(j % 2) - 0.5f) * (float)size / 4.0f;
                float f1 = ((float)(j / 2) - 0.5f) * (float)size / 4.0f;
                EntitySlime entityslime = new EntitySlime(this.worldObj, true);
                entityslime.setSlimeSize(size / 2);
                entityslime.setLocationAndAngles(this.posX + (double)f, this.posY + 0.5, this.posZ + (double)f1, this.rand.nextFloat() * 360.0f, 0.0f);
                this.worldObj.entityJoinedWorld(entityslime);
            }
        }
        super.setEntityDead();
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer entityplayer) {
        int i = this.getSlimeSize();
        if (i > 1 && this.canEntityBeSeen(entityplayer) && (double)this.getDistanceToEntity(entityplayer) < 0.6 * (double)i && entityplayer.attackEntityFrom(this, i, DamageType.COMBAT)) {
            this.worldObj.playSoundAtEntity(this, "mob.slimeattack", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    protected String getHurtSound() {
        return "mob.slime";
    }

    @Override
    protected String getDeathSound() {
        return "mob.slime";
    }

    @Override
    protected int getDropItemId() {
        if (this.getSlimeSize() == 1) {
            return Item.slimeball.itemID;
        }
        return 0;
    }

    @Override
    public boolean getCanSpawnHere() {
        Chunk chunk = this.worldObj.getChunkFromBlockCoords(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posZ));
        if (this.posY > 32.0) {
            return false;
        }
        if (chunk.func_997_a(987234911L).nextInt(10) != 0) {
            return false;
        }
        if (this.worldObj.difficultySetting == 0) {
            return false;
        }
        return super.getCanSpawnHere();
    }

    @Override
    protected float getSoundVolume() {
        return 0.6f;
    }
}

