/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.Item;
import net.minecraft.src.ItemFood;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MathHelper;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PathEntity;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class EntityWolf
extends EntityAnimal {
    private boolean looksWithInterest = false;
    private float field_25048_b;
    private float field_25054_c;
    private boolean isWolfShaking;
    private boolean field_25052_g;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;

    public EntityWolf(World world) {
        super(world);
        this.texture = "/mob/wolf.png";
        this.setSize(0.8f, 0.8f);
        this.moveSpeed = 1.1f;
        this.health = 8;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (byte)0);
        this.dataWatcher.addObject(17, "");
        this.dataWatcher.addObject(18, new Integer(this.health));
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    @Override
    public String getEntityTexture() {
        if (this.isWolfTamed()) {
            return "/mob/wolf_tame.png";
        }
        if (this.isWolfAngry()) {
            return "/mob/wolf_angry.png";
        }
        return super.getEntityTexture();
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBoolean("Angry", this.isWolfAngry());
        nbttagcompound.setBoolean("Sitting", this.isWolfSitting());
        if (this.getWolfOwner() == null) {
            nbttagcompound.setString("Owner", "");
        } else {
            nbttagcompound.setString("Owner", this.getWolfOwner());
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setWolfAngry(nbttagcompound.getBoolean("Angry"));
        this.setWolfSitting(nbttagcompound.getBoolean("Sitting"));
        String s = nbttagcompound.getString("Owner");
        if (s.length() > 0) {
            this.setWolfOwner(s);
            this.setWolfTamed(true);
        }
    }

    @Override
    protected boolean canDespawn() {
        return !this.isWolfTamed();
    }

    @Override
    protected String getLivingSound() {
        if (this.isWolfAngry()) {
            return "mob.wolf.growl";
        }
        if (this.rand.nextInt(3) == 0) {
            if (this.isWolfTamed() && this.dataWatcher.getWatchableObjectInt(18) < 10) {
                return "mob.wolf.whine";
            }
            return "mob.wolf.panting";
        }
        return "mob.wolf.bark";
    }

    @Override
    protected String getHurtSound() {
        return "mob.wolf.hurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.wolf.death";
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected int getDropItemId() {
        return -1;
    }

    @Override
    protected void updatePlayerActionState() {
        List<Entity> list;
        super.updatePlayerActionState();
        if (!this.hasAttacked && !this.hasPath() && this.isWolfTamed() && this.ridingEntity == null) {
            EntityPlayer entityplayer = this.worldObj.getPlayerEntityByName(this.getWolfOwner());
            if (entityplayer != null) {
                float f = entityplayer.getDistanceToEntity(this);
                if (f > 5.0f) {
                    this.getPathOrWalkableBlock(entityplayer, f);
                }
            } else if (!this.isInWater()) {
                this.setWolfSitting(true);
            }
        } else if (!(this.entityToAttack != null || this.hasPath() || this.isWolfTamed() || this.worldObj.rand.nextInt(100) != 0 || (list = this.worldObj.getEntitiesWithinAABB(EntitySheep.class, AxisAlignedBB.getBoundingBoxFromPool(this.posX, this.posY, this.posZ, this.posX + 1.0, this.posY + 1.0, this.posZ + 1.0).expand(16.0, 4.0, 16.0))).isEmpty())) {
            this.setTarget(list.get(this.worldObj.rand.nextInt(list.size())));
        }
        if (this.isInWater()) {
            this.setWolfSitting(false);
        }
        if (!this.worldObj.isMultiplayerAndNotHost) {
            this.dataWatcher.updateObject(18, this.health);
        }
    }

    @Override
    public void onLivingUpdate() {
        Entity entity;
        super.onLivingUpdate();
        this.looksWithInterest = false;
        if (this.hasCurrentTarget() && !this.hasPath() && !this.isWolfAngry() && (entity = this.getCurrentTarget()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            ItemStack itemstack = entityplayer.inventory.getCurrentItem();
            if (itemstack != null) {
                if (!this.isWolfTamed() && itemstack.itemID == Item.bone.itemID) {
                    this.looksWithInterest = true;
                } else if (this.isWolfTamed() && Item.itemsList[itemstack.itemID] instanceof ItemFood) {
                    this.looksWithInterest = ((ItemFood)Item.itemsList[itemstack.itemID]).getIsWolfsFavoriteMeat();
                }
            }
        }
        if (!this.isMultiplayerEntity && this.isWolfShaking && !this.field_25052_g && !this.hasPath() && this.onGround) {
            this.field_25052_g = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.worldObj.sendTrackedEntityStatusUpdatePacket(this, (byte)8);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.field_25054_c = this.field_25048_b;
        this.field_25048_b = this.looksWithInterest ? (this.field_25048_b += (1.0f - this.field_25048_b) * 0.4f) : (this.field_25048_b += (0.0f - this.field_25048_b) * 0.4f);
        if (this.looksWithInterest) {
            this.numTicksToChaseTarget = 10;
        }
        if (this.isWet()) {
            this.isWolfShaking = true;
            this.field_25052_g = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWolfShaking || this.field_25052_g) && this.field_25052_g) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.worldObj.playSoundAtEntity(this, "mob.wolf.shake", this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWolfShaking = false;
                this.field_25052_g = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f = (float)this.boundingBox.minY;
                int i = (int)(MathHelper.sin((this.timeWolfIsShaking - 0.4f) * 3.141593f) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                    float f2 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width * 0.5f;
                    this.worldObj.spawnParticle("splash", this.posX + (double)f1, f + 0.8f, this.posZ + (double)f2, this.motionX, this.motionY, this.motionZ);
                }
            }
        }
    }

    public boolean getWolfShaking() {
        return this.isWolfShaking;
    }

    public float getShadingWhileShaking(float f) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * f) / 2.0f * 0.25f;
    }

    public float getShakeAngle(float f, float f1) {
        float f2 = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * f + f1) / 1.8f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return MathHelper.sin(f2 * 3.141593f) * MathHelper.sin(f2 * 3.141593f * 11.0f) * 0.15f * 3.141593f;
    }

    public float getInterestedAngle(float f) {
        return (this.field_25054_c + (this.field_25048_b - this.field_25054_c) * f) * 0.15f * 3.141593f;
    }

    @Override
    public float getEyeHeight() {
        return this.height * 0.8f;
    }

    @Override
    protected int func_25026_x() {
        if (this.isWolfSitting()) {
            return 20;
        }
        return super.func_25026_x();
    }

    private void getPathOrWalkableBlock(Entity entity, float f) {
        PathEntity pathentity = this.worldObj.getPathToEntity(this, entity, 16.0f);
        if (pathentity == null && f > 12.0f) {
            int i = MathHelper.floor_double(entity.posX) - 2;
            int j = MathHelper.floor_double(entity.posZ) - 2;
            int k = MathHelper.floor_double(entity.boundingBox.minY);
            for (int l = 0; l <= 4; ++l) {
                for (int i1 = 0; i1 <= 4; ++i1) {
                    if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.worldObj.isBlockNormalCube(i + l, k - 1, j + i1) || this.worldObj.isBlockNormalCube(i + l, k, j + i1) || this.worldObj.isBlockNormalCube(i + l, k + 1, j + i1)) continue;
                    this.setLocationAndAngles((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.rotationYaw, this.rotationPitch);
                    return;
                }
            }
        } else {
            this.setPathToEntity(pathentity);
        }
    }

    @Override
    protected boolean isMovementCeased() {
        return this.isWolfSitting() || this.field_25052_g;
    }

    @Override
    public boolean attackEntityFrom(Entity entity, int i, DamageType type) {
        this.setWolfSitting(false);
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            i = (i + 1) / 2;
        }
        if (super.attackEntityFrom(entity, i, type)) {
            if (!this.isWolfTamed() && !this.isWolfAngry()) {
                if (entity instanceof EntityPlayer) {
                    this.setWolfAngry(true);
                    this.entityToAttack = entity;
                }
                if (entity instanceof EntityArrow && ((EntityArrow)entity).owner != null) {
                    entity = ((EntityArrow)entity).owner;
                }
                if (entity instanceof EntityLiving) {
                    List<Entity> list = this.worldObj.getEntitiesWithinAABB(EntityWolf.class, AxisAlignedBB.getBoundingBoxFromPool(this.posX, this.posY, this.posZ, this.posX + 1.0, this.posY + 1.0, this.posZ + 1.0).expand(16.0, 4.0, 16.0));
                    for (Entity entity1 : list) {
                        EntityWolf entitywolf = (EntityWolf)entity1;
                        if (entitywolf.isWolfTamed() || entitywolf.entityToAttack != null) continue;
                        entitywolf.entityToAttack = entity;
                        if (!(entity instanceof EntityPlayer)) continue;
                        entitywolf.setWolfAngry(true);
                    }
                }
            } else if (entity != this && entity != null) {
                if (this.isWolfTamed() && entity instanceof EntityPlayer && ((EntityPlayer)entity).username.equalsIgnoreCase(this.getWolfOwner())) {
                    return true;
                }
                this.entityToAttack = entity;
            }
            return true;
        }
        return false;
    }

    @Override
    protected Entity findPlayerToAttack() {
        if (this.isWolfAngry()) {
            return this.worldObj.getClosestPlayerToEntity(this, 16.0);
        }
        return null;
    }

    @Override
    protected void attackEntity(Entity entity, float f) {
        if (f > 2.0f && f < 6.0f && this.rand.nextInt(10) == 0) {
            if (this.onGround) {
                double d = entity.posX - this.posX;
                double d1 = entity.posZ - this.posZ;
                float f1 = MathHelper.sqrt_double(d * d + d1 * d1);
                this.motionX = d / (double)f1 * 0.5 * (double)0.8f + this.motionX * (double)0.2f;
                this.motionZ = d1 / (double)f1 * 0.5 * (double)0.8f + this.motionZ * (double)0.2f;
                this.motionY = 0.4f;
            }
        } else if ((double)f < 1.5 && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            int byte0 = 2;
            if (this.isWolfTamed()) {
                byte0 = 4;
            }
            entity.attackEntityFrom(this, byte0, DamageType.COMBAT);
        }
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        if (super.interact(entityplayer)) {
            return true;
        }
        ItemStack itemstack = entityplayer.inventory.getCurrentItem();
        if (!this.isWolfTamed()) {
            if (itemstack != null && itemstack.itemID == Item.bone.itemID && !this.isWolfAngry()) {
                itemstack.consumeItem(entityplayer);
                if (itemstack.stackSize <= 0) {
                    entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                }
                if (!this.worldObj.isMultiplayerAndNotHost) {
                    if (this.rand.nextInt(3) == 0) {
                        this.setWolfTamed(true);
                        this.setPathToEntity(null);
                        this.setWolfSitting(true);
                        this.health = 20;
                        this.setWolfOwner(entityplayer.username);
                        this.showHeartsOrSmokeFX(true);
                        this.worldObj.sendTrackedEntityStatusUpdatePacket(this, (byte)7);
                    } else {
                        this.showHeartsOrSmokeFX(false);
                        this.worldObj.sendTrackedEntityStatusUpdatePacket(this, (byte)6);
                    }
                }
                return true;
            }
        } else {
            ItemFood itemfood;
            if (itemstack != null && Item.itemsList[itemstack.itemID] instanceof ItemFood && (itemfood = (ItemFood)Item.itemsList[itemstack.itemID]).getIsWolfsFavoriteMeat() && this.dataWatcher.getWatchableObjectInt(18) < 20) {
                if (entityplayer.getGamemode().consumeBlocks) {
                    --itemstack.stackSize;
                    if (itemstack.stackSize <= 0) {
                        entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                    }
                }
                this.heal(((ItemFood)Item.foodPorkchopRaw).getHealAmount());
                return true;
            }
            if (entityplayer.username.equalsIgnoreCase(this.getWolfOwner())) {
                if (!this.worldObj.isMultiplayerAndNotHost) {
                    this.setWolfSitting(!this.isWolfSitting());
                    this.isJumping = false;
                    this.setPathToEntity(null);
                }
                return true;
            }
        }
        return false;
    }

    void showHeartsOrSmokeFX(boolean flag) {
        String s = "heart";
        if (!flag) {
            s = "smoke";
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            this.worldObj.spawnParticle(s, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
        }
    }

    @Override
    public void handleEntityStatus(byte byte0, float attackedAtYaw) {
        if (byte0 == 7) {
            this.showHeartsOrSmokeFX(true);
        } else if (byte0 == 6) {
            this.showHeartsOrSmokeFX(false);
        } else if (byte0 == 8) {
            this.field_25052_g = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.handleEntityStatus(byte0, attackedAtYaw);
        }
    }

    public float setTailRotation() {
        if (this.isWolfAngry()) {
            return 1.53938f;
        }
        if (this.isWolfTamed()) {
            return (0.55f - (float)(20 - this.dataWatcher.getWatchableObjectInt(18)) * 0.02f) * 3.141593f;
        }
        return 0.6283185f;
    }

    @Override
    public int getMaxSpawnedInChunk() {
        return 8;
    }

    public String getWolfOwner() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public void setWolfOwner(String s) {
        this.dataWatcher.updateObject(17, s);
    }

    public boolean isWolfSitting() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void setWolfSitting(boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        if (flag) {
            this.dataWatcher.updateObject(16, (byte)(byte0 | 1));
        } else {
            this.dataWatcher.updateObject(16, (byte)(byte0 & 0xFFFFFFFE));
        }
    }

    public boolean isWolfAngry() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 2) != 0;
    }

    public void setWolfAngry(boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        if (flag) {
            this.dataWatcher.updateObject(16, (byte)(byte0 | 2));
        } else {
            this.dataWatcher.updateObject(16, (byte)(byte0 & 0xFFFFFFFD));
        }
    }

    public boolean isWolfTamed() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 4) != 0;
    }

    public void setWolfTamed(boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        if (flag) {
            this.dataWatcher.updateObject(16, (byte)(byte0 | 4));
        } else {
            this.dataWatcher.updateObject(16, (byte)(byte0 & 0xFFFFFFFB));
        }
    }
}

