/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityMob;
import net.minecraft.src.Item;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Weather;
import net.minecraft.src.World;

public class EntityZombie
extends EntityMob {
    public EntityZombie(World world) {
        super(world);
        this.texture = "/mob/zombie.png";
        this.moveSpeed = 0.5f;
        this.attackStrength = 5;
        this.scoreValue = 300;
    }

    @Override
    public void onLivingUpdate() {
        float f;
        if (this.worldObj.isDaytime() && (f = this.getEntityBrightness(1.0f)) > 0.5f && this.worldObj.canBlockSeeTheSky(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) && this.rand.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.worldObj.getCurrentWeather() != Weather.weatherFog) {
            this.fire = 300;
        }
        super.onLivingUpdate();
    }

    @Override
    protected String getLivingSound() {
        return "mob.zombie";
    }

    @Override
    protected String getHurtSound() {
        return "mob.zombiehurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.zombiedeath";
    }

    @Override
    protected int getDropItemId() {
        return Item.cloth.itemID;
    }
}

