/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.helper.DamageType;

public class Explosion {
    public boolean isFlaming = false;
    protected Random ExplosionRNG = new Random();
    protected World worldObj;
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public Entity exploder;
    public float explosionSize;
    public Set<ChunkPosition> destroyedBlockPositions = new HashSet<ChunkPosition>();
    public boolean destroyBlocks;

    public Explosion(World world, Entity entity, double d, double d1, double d2, float f) {
        this.worldObj = world;
        this.exploder = entity;
        this.explosionSize = f;
        this.explosionX = d;
        this.explosionY = d1;
        this.explosionZ = d2;
        this.destroyBlocks = true;
        if (!world.mobGriefing) {
            this.destroyBlocks = entity == null || entity instanceof EntityPlayer;
        }
    }

    public void doExplosionA() {
        if (this.destroyBlocks) {
            this.calculateBlocksToDestroy();
        }
        this.damageEntities();
        if (this.destroyBlocks && this.isFlaming) {
            this.createFire();
        }
    }

    public void doExplosionB(boolean particles) {
        this.worldObj.playSoundEffect(this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.2f) * 0.7f);
        ArrayList<ChunkPosition> arraylist = new ArrayList<ChunkPosition>();
        arraylist.addAll(this.destroyedBlockPositions);
        for (int i = arraylist.size() - 1; i >= 0; --i) {
            ChunkPosition chunkposition = (ChunkPosition)arraylist.get(i);
            int j = chunkposition.x;
            int k = chunkposition.y;
            int l = chunkposition.z;
            int id = this.worldObj.getBlockId(j, k, l);
            if (particles) {
                double d = (float)j + this.worldObj.rand.nextFloat();
                double d1 = (float)k + this.worldObj.rand.nextFloat();
                double d2 = (float)l + this.worldObj.rand.nextFloat();
                double d3 = d - this.explosionX;
                double d4 = d1 - this.explosionY;
                double d5 = d2 - this.explosionZ;
                double d6 = MathHelper.sqrt_double(d3 * d3 + d4 * d4 + d5 * d5);
                d3 /= d6;
                d4 /= d6;
                d5 /= d6;
                double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                this.worldObj.spawnParticle("explode", (d + this.explosionX * 1.0) / 2.0, (d1 + this.explosionY * 1.0) / 2.0, (d2 + this.explosionZ * 1.0) / 2.0, d3 *= (d7 *= (double)(this.worldObj.rand.nextFloat() * this.worldObj.rand.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                this.worldObj.spawnParticle("smoke", d, d1, d2, d3, d4, d5);
            }
            if (id <= 0) continue;
            Block.blocksList[id].dropBlockAsItemWithChance(this.worldObj, j, k, l, this.worldObj.getBlockMetadata(j, k, l), 1.0f);
            this.worldObj.setBlockWithNotify(j, k, l, 0);
            Block.blocksList[id].onBlockDestroyedByExplosion(this.worldObj, j, k, l);
        }
    }

    protected void calculateBlocksToDestroy() {
        int i = 16;
        for (int j = 0; j < i; ++j) {
            for (int l = 0; l < i; ++l) {
                for (int j1 = 0; j1 < i; ++j1) {
                    if (j != 0 && j != i - 1 && l != 0 && l != i - 1 && j1 != 0 && j1 != i - 1) continue;
                    double d = (float)j / ((float)i - 1.0f) * 2.0f - 1.0f;
                    double d1 = (float)l / ((float)i - 1.0f) * 2.0f - 1.0f;
                    double d2 = (float)j1 / ((float)i - 1.0f) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d * d + d1 * d1 + d2 * d2);
                    d /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d5 = this.explosionX;
                    double d7 = this.explosionY;
                    double d9 = this.explosionZ;
                    float f2 = 0.3f;
                    for (float f1 = this.explosionSize * (0.7f + this.worldObj.rand.nextFloat() * 0.6f); !(f1 <= 0.0f); f1 -= f2 * 0.75f) {
                        int l4;
                        int k4;
                        int j4 = MathHelper.floor_double(d5);
                        int i5 = this.worldObj.getBlockId(j4, k4 = MathHelper.floor_double(d7), l4 = MathHelper.floor_double(d9));
                        if (i5 > 0) {
                            f1 -= (Block.blocksList[i5].getExplosionResistance(this.exploder) + 0.3f) * f2;
                        }
                        if (f1 > 0.0f) {
                            this.destroyedBlockPositions.add(new ChunkPosition(j4, k4, l4));
                        }
                        d5 += d * (double)f2;
                        d7 += d1 * (double)f2;
                        d9 += d2 * (double)f2;
                    }
                }
            }
        }
    }

    protected void damageEntities() {
        float explosionSize2 = this.explosionSize * 2.0f;
        int x1 = MathHelper.floor_double(this.explosionX - (double)explosionSize2 - 1.0);
        int x2 = MathHelper.floor_double(this.explosionX + (double)explosionSize2 + 1.0);
        int y1 = MathHelper.floor_double(this.explosionY - (double)explosionSize2 - 1.0);
        int y2 = MathHelper.floor_double(this.explosionY + (double)explosionSize2 + 1.0);
        int z1 = MathHelper.floor_double(this.explosionZ - (double)explosionSize2 - 1.0);
        int z2 = MathHelper.floor_double(this.explosionZ + (double)explosionSize2 + 1.0);
        List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this.exploder, AxisAlignedBB.getBoundingBoxFromPool(x1, y1, z1, x2, y2, z2));
        Vec3D vec3d = Vec3D.createVector(this.explosionX, this.explosionY, this.explosionZ);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Entity entity = list.get(k2);
            double d4 = entity.getDistance(this.explosionX, this.explosionY, this.explosionZ) / (double)explosionSize2;
            if (!(d4 <= 1.0)) continue;
            double d6 = entity.posX - this.explosionX;
            double d8 = entity.posY - this.explosionY;
            double d10 = entity.posZ - this.explosionZ;
            double d11 = MathHelper.sqrt_double(d6 * d6 + d8 * d8 + d10 * d10);
            d6 /= d11;
            d8 /= d11;
            d10 /= d11;
            double d12 = this.worldObj.func_675_a(vec3d, entity.boundingBox);
            double d13 = (1.0 - d4) * d12;
            entity.attackEntityFrom(this.exploder, (int)((d13 * d13 + d13) / 2.0 * 8.0 * (double)explosionSize2 + 1.0), DamageType.BLAST);
            double d14 = d13;
            entity.motionX += d6 * d14;
            entity.motionY += d8 * d14;
            entity.motionZ += d10 * d14;
        }
    }

    protected void createFire() {
        ArrayList<ChunkPosition> arraylist = new ArrayList<ChunkPosition>();
        arraylist.addAll(this.destroyedBlockPositions);
        for (int l2 = arraylist.size() - 1; l2 >= 0; --l2) {
            ChunkPosition chunkposition = (ChunkPosition)arraylist.get(l2);
            int x1 = chunkposition.x;
            int y1 = chunkposition.y;
            int z1 = chunkposition.z;
            if (this.worldObj.getBlockId(x1, y1, z1) != 0 || !Block.opaqueCubeLookup[this.worldObj.getBlockId(x1, y1 - 1, z1)] || this.ExplosionRNG.nextInt(3) != 0) continue;
            this.worldObj.setBlockWithNotify(x1, y1, z1, Block.fire.blockID);
        }
    }
}

