/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.GameSettings;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiOptionsButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.StringTranslate;

public class GuiKeybinds
extends GuiScreen {
    protected String screenTitle;
    private final GameSettings options;
    private int buttonId;
    private GuiButton nextPageButton;
    private GuiButton lastPageButton;
    private int page = 0;
    private final int settingsPerPage = 12;
    private int pages;
    private int settingsInPage = 12;
    private String info;

    public GuiKeybinds(GuiScreen guiscreen, GameSettings gamesettings) {
        super(guiscreen);
        StringTranslate stringtranslate = StringTranslate.getInstance();
        this.screenTitle = "Controls";
        this.buttonId = -1;
        this.options = gamesettings;
        int l = this.options.keys.length;
        this.pages = l / 12;
        if (l % 12 > 0) {
            ++this.pages;
        }
        this.screenTitle = stringtranslate.translateKey("keybinds.title");
        this.info = stringtranslate.translateKey("keybinds.info");
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        boolean pageUpdated = false;
        if (guibutton.id == 200) {
            this.mc.displayGuiScreen(this.parentScreen);
        } else if (guibutton == this.nextPageButton) {
            if (this.page + 1 < this.pages) {
                ++this.page;
            }
            if (this.page + 1 == this.pages) {
                this.nextPageButton.enabled = false;
            }
            if (this.page > 0) {
                this.lastPageButton.enabled = true;
            }
            pageUpdated = true;
        } else if (guibutton == this.lastPageButton) {
            if (this.page > 0) {
                --this.page;
            }
            if (this.page == 0) {
                this.lastPageButton.enabled = false;
            }
            if (this.page + 1 < this.pages) {
                this.nextPageButton.enabled = true;
            }
            pageUpdated = true;
        } else {
            this.buttonId = guibutton.id;
            guibutton.displayString = "> " + this.options.getKeyName(this.buttonId) + " <";
        }
        if (this.page == this.pages - 1) {
            this.settingsInPage = this.options.keys.length % 12;
            if (this.settingsInPage == 0) {
                this.settingsInPage = 12;
            }
        } else {
            this.settingsInPage = 12;
        }
        if (pageUpdated) {
            GuiButton button;
            int i;
            for (i = 0; i < this.settingsInPage; ++i) {
                button = (GuiButton)this.controlList.get(i);
                button.enabled = true;
                button.id = this.page * 12 + i;
                button.displayString = this.options.getKeyName(button.id);
            }
            for (i = this.settingsInPage; i < 12; ++i) {
                button = (GuiButton)this.controlList.get(i);
                button.enabled = false;
                button.id = this.page * 12 + i;
                button.displayString = "";
            }
        }
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        this.drawCenteredString(this.fontRenderer, this.info, this.width / 2, 30, 0x808080);
        int k = this.func_20080_j();
        for (int l = 0; l < this.settingsInPage; ++l) {
            this.drawString(this.fontRenderer, this.options.getKeyBindName(12 * this.page + l), k + l % 2 * 160 + 70 + 6, this.height / 6 + 24 * (l >> 1) + 7, -1);
        }
        super.drawScreen(x, y, renderPartialTicks);
    }

    private int func_20080_j() {
        return this.width / 2 - 155;
    }

    @Override
    public void initGui() {
        StringTranslate stringtranslate = StringTranslate.getInstance();
        int i = this.func_20080_j();
        for (int j = 0; j < this.settingsInPage; ++j) {
            this.controlList.add(new GuiOptionsButton(12 * this.page + j, i + j % 2 * 160, this.height / 6 + 24 * (j >> 1), 70, 20, this.options.getKeyName(12 * this.page + j)));
        }
        this.controlList.add(new GuiButton(200, this.width / 2 - 68, this.height / 6 + 168, 136, 20, stringtranslate.translateKey("gui.done")));
        this.nextPageButton = new GuiButton(201, this.width / 2 - 68 + 136 + 2, this.height / 6 + 168, 30, 20, ">");
        this.lastPageButton = new GuiButton(202, this.width / 2 - 68 - 30 - 2, this.height / 6 + 168, 30, 20, "<");
        this.controlList.add(this.nextPageButton);
        this.controlList.add(this.lastPageButton);
        this.screenTitle = stringtranslate.translateKey("controls.title");
        if (this.page == 0) {
            this.lastPageButton.enabled = false;
        }
        if (this.page + 1 == this.pages) {
            this.nextPageButton.enabled = false;
        }
    }

    @Override
    public void keyTyped(char c, int i) {
        if (this.buttonId >= 0) {
            if (i == 1) {
                i = -1;
            }
            this.options.getKey(this.buttonId).setKeyCode(i);
            GuiButton button = null;
            for (int q = 0; q < this.controlList.size(); ++q) {
                if (((GuiButton)this.controlList.get((int)q)).id != this.buttonId) continue;
                button = (GuiButton)this.controlList.get(q);
            }
            button.displayString = this.options.getKeyName(this.buttonId);
            this.buttonId = -1;
        } else {
            super.keyTyped(c, i);
        }
    }
}

