/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.Gui;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiParticle;
import net.minecraft.src.Tessellator;
import net.minecraft.src.helper.Color;
import net.minecraft.src.input.InputType;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreen
extends Gui {
    final GuiScreen parentScreen;
    protected Minecraft mc;
    public int width;
    public int height;
    protected List<GuiButton> controlList = new ArrayList<GuiButton>();
    public boolean field_948_f = false;
    protected FontRenderer fontRenderer;
    public GuiParticle field_25091_h;
    private GuiButton selectedButton = null;

    public GuiScreen(GuiScreen parent) {
        this.parentScreen = parent;
    }

    public GuiScreen() {
        this(null);
    }

    public void drawScreen(int x, int y, float renderPartialTicks) {
        for (int i = 0; i < this.controlList.size(); ++i) {
            GuiButton guibutton = this.controlList.get(i);
            guibutton.drawButton(this.mc, x, y);
        }
    }

    public void keyTyped(char c, int i) {
        if (i == 14) {
            this.mc.displayGuiScreen(this.parentScreen);
        }
        if (i == 1) {
            this.mc.displayGuiScreen(null);
        }
    }

    public void mouseClicked(int x, int y, int button) {
        if (button == 0) {
            for (int l = 0; l < this.controlList.size(); ++l) {
                GuiButton guibutton = this.controlList.get(l);
                if (!guibutton.mousePressed(this.mc, x, y)) continue;
                this.selectedButton = guibutton;
                this.mc.sndManager.playSoundFX("random.click", 1.0f, 1.0f);
                if (guibutton.listener != null) {
                    guibutton.listener.listen(guibutton);
                    continue;
                }
                this.actionPerformed(guibutton);
            }
        }
    }

    public void mouseMovedOrUp(int i, int j, int k) {
        if (this.selectedButton != null && k == 0) {
            this.selectedButton.mouseReleased(i, j);
            this.selectedButton = null;
        }
    }

    protected void actionPerformed(GuiButton guibutton) {
    }

    public void setWorldAndResolution(Minecraft minecraft, int i, int j) {
        this.field_25091_h = new GuiParticle(minecraft);
        this.mc = minecraft;
        this.fontRenderer = minecraft.fontRenderer;
        this.width = i;
        this.height = j;
        this.controlList.clear();
        this.initGui();
    }

    public void initGui() {
    }

    public void handleInput() {
        while (Mouse.next()) {
            this.handleMouseInput();
        }
        while (Keyboard.next()) {
            this.handleKeyboardInput();
        }
    }

    public void handleMouseInput() {
        if (this.mc.inputType == InputType.CONTROLLER) {
            return;
        }
        if (Mouse.getEventButtonState()) {
            int i = Mouse.getEventX() * this.width / this.mc.resolution.width;
            int k = this.height - Mouse.getEventY() * this.height / this.mc.resolution.height - 1;
            this.mouseClicked(i, k, Mouse.getEventButton());
        } else {
            int j = Mouse.getEventX() * this.width / this.mc.resolution.width;
            int l = this.height - Mouse.getEventY() * this.height / this.mc.resolution.height - 1;
            this.mouseMovedOrUp(j, l, Mouse.getEventButton());
        }
    }

    public void handleKeyboardInput() {
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == 87) {
                this.mc.toggleFullscreen();
                return;
            }
            this.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
    }

    public void updateScreen() {
    }

    public void onGuiClosed() {
    }

    public void drawDefaultBackground() {
        this.drawWorldBackground(0);
    }

    public void drawWorldBackground(int i) {
        if (this.mc.theWorld != null) {
            int color = ((Color)this.mc.gameSettings.guiBackgroundColor.value).getARGB();
            this.drawGradientRect(0, 0, this.width, this.height, color, color);
        } else {
            this.drawBackground(i);
        }
    }

    public void drawBackground(int i) {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / f + (float)i);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / f, (float)this.height / f + (float)i);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / f, 0 + i);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0 + i);
        tessellator.draw();
    }

    public void drawCursor() {
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/gui.png"));
        this.drawTexturedModalRect(this.mc.controllerInput.cursorX - 8.0, this.mc.controllerInput.cursorY - 8.0, 224, 0, 16, 16, 32, 32);
        GL11.glDisable((int)3042);
    }

    public boolean doesGuiPauseGame() {
        return true;
    }

    public void deleteWorld(boolean flag, int i) {
    }

    public void selectNextField() {
    }

    public void selectButtonUp() {
        double cursorX = this.mc.controllerInput.cursorX;
        double cursorY = this.mc.controllerInput.cursorY;
        GuiButton hoveredButton = null;
        GuiButton closestButton = null;
        float closestButtonDistance = Float.POSITIVE_INFINITY;
        for (GuiButton button : this.controlList) {
            if (!button.isHovered((int)cursorX, (int)cursorY)) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null) {
            for (GuiButton button : this.controlList) {
                if (button == hoveredButton || hoveredButton.yPosition <= button.yPosition || hoveredButton.xPosition != button.xPosition || !((float)(hoveredButton.yPosition - button.yPosition) < closestButtonDistance)) continue;
                closestButtonDistance = hoveredButton.yPosition - button.yPosition;
                closestButton = button;
            }
        }
        if (closestButton == null) {
            for (GuiButton button : this.controlList) {
                float buttonDistance;
                if (!((double)button.yPosition + (double)button.height / 2.0 < cursorY) || !((buttonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY)) < closestButtonDistance)) continue;
                closestButton = button;
                closestButtonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY);
            }
        }
        if (closestButton == null) {
            return;
        }
        this.mc.controllerInput.cursorX = (double)closestButton.xPosition + (double)closestButton.width / 2.0;
        this.mc.controllerInput.cursorY = (double)closestButton.yPosition + (double)closestButton.height / 2.0;
    }

    public void selectButtonDown() {
        double cursorX = this.mc.controllerInput.cursorX;
        double cursorY = this.mc.controllerInput.cursorY;
        GuiButton hoveredButton = null;
        GuiButton closestButton = null;
        float closestButtonDistance = Float.POSITIVE_INFINITY;
        for (GuiButton button : this.controlList) {
            if (!button.isHovered((int)cursorX, (int)cursorY)) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null) {
            for (GuiButton button : this.controlList) {
                if (button == hoveredButton || hoveredButton.yPosition >= button.yPosition || hoveredButton.xPosition != button.xPosition || !((float)(button.yPosition - hoveredButton.yPosition) < closestButtonDistance)) continue;
                closestButtonDistance = button.yPosition - hoveredButton.yPosition;
                closestButton = button;
            }
        }
        if (closestButton == null) {
            for (GuiButton button : this.controlList) {
                float buttonDistance;
                if (!((double)button.yPosition + (double)button.height / 2.0 > cursorY) || !((buttonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY)) < closestButtonDistance)) continue;
                closestButton = button;
                closestButtonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY);
            }
        }
        if (closestButton == null) {
            return;
        }
        this.mc.controllerInput.cursorX = (double)closestButton.xPosition + (double)closestButton.width / 2.0;
        this.mc.controllerInput.cursorY = (double)closestButton.yPosition + (double)closestButton.height / 2.0;
    }

    public void selectButtonLeft() {
        double cursorX = this.mc.controllerInput.cursorX;
        double cursorY = this.mc.controllerInput.cursorY;
        GuiButton hoveredButton = null;
        GuiButton closestButton = null;
        float closestButtonDistance = Float.POSITIVE_INFINITY;
        for (GuiButton button : this.controlList) {
            if (!button.isHovered((int)cursorX, (int)cursorY)) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null) {
            for (GuiButton button : this.controlList) {
                if (button == hoveredButton || hoveredButton.xPosition <= button.xPosition || hoveredButton.yPosition != button.yPosition || !((float)(hoveredButton.xPosition - button.xPosition) < closestButtonDistance)) continue;
                closestButtonDistance = hoveredButton.xPosition - button.xPosition;
                closestButton = button;
            }
        }
        if (closestButton == null) {
            for (GuiButton button : this.controlList) {
                float buttonDistance;
                if (!((double)button.xPosition + (double)button.width / 2.0 < cursorX) || !((buttonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY)) < closestButtonDistance)) continue;
                closestButton = button;
                closestButtonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY);
            }
        }
        if (closestButton == null) {
            return;
        }
        this.mc.controllerInput.cursorX = (double)closestButton.xPosition + (double)closestButton.width / 2.0;
        this.mc.controllerInput.cursorY = (double)closestButton.yPosition + (double)closestButton.height / 2.0;
    }

    public void selectButtonRight() {
        double cursorX = this.mc.controllerInput.cursorX;
        double cursorY = this.mc.controllerInput.cursorY;
        GuiButton hoveredButton = null;
        GuiButton closestButton = null;
        float closestButtonDistance = Float.POSITIVE_INFINITY;
        for (GuiButton button : this.controlList) {
            if (!button.isHovered((int)cursorX, (int)cursorY)) continue;
            hoveredButton = button;
            break;
        }
        if (hoveredButton != null) {
            for (GuiButton button : this.controlList) {
                if (button == hoveredButton || hoveredButton.xPosition >= button.xPosition || hoveredButton.yPosition != button.yPosition || !((float)(button.xPosition - hoveredButton.xPosition) < closestButtonDistance)) continue;
                closestButtonDistance = button.xPosition - hoveredButton.xPosition;
                closestButton = button;
            }
        }
        if (closestButton == null) {
            for (GuiButton button : this.controlList) {
                float buttonDistance;
                if (!((double)button.xPosition + (double)button.width / 2.0 > cursorX) || !((buttonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY)) < closestButtonDistance)) continue;
                closestButton = button;
                closestButtonDistance = this.getButtonDistance(button, (int)cursorX, (int)cursorY);
            }
        }
        if (closestButton == null) {
            return;
        }
        this.mc.controllerInput.cursorX = (double)closestButton.xPosition + (double)closestButton.width / 2.0;
        this.mc.controllerInput.cursorY = (double)closestButton.yPosition + (double)closestButton.height / 2.0;
    }

    public float getButtonDistance(GuiButton button1, int cursorX, int cursorY) {
        return (float)Math.sqrt(Math.pow(button1.xPosition - cursorX, 2.0) + Math.pow(button1.yPosition - cursorY, 2.0));
    }

    public float getButtonDistanceBiasX(GuiButton button1, int cursorX, int cursorY) {
        return (float)Math.sqrt(Math.pow((double)(button1.xPosition - cursorX) / 16.0, 2.0) + Math.pow(button1.yPosition - cursorY, 2.0));
    }

    public float getButtonDistanceBiasY(GuiButton button1, int cursorX, int cursorY) {
        return (float)Math.sqrt(Math.pow(button1.xPosition - cursorX, 2.0) + Math.pow((double)(button1.yPosition - cursorY) / 16.0, 2.0));
    }
}

