/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiScreen;
import net.minecraft.src.GuiTextField;
import net.minecraft.src.dynamictexture.DynamicTexture;
import org.lwjgl.input.Keyboard;

public class GuiShaderSelect
extends GuiScreen {
    public final Minecraft minecraft;
    private File shaderpacksFolder;
    private GuiTextField textField;
    private int tabPos = -1;
    private int tabI = 0;

    public GuiShaderSelect(Minecraft minecraft) {
        this.minecraft = minecraft;
        this.shaderpacksFolder = new File(Minecraft.getMinecraftDir(), "shaderpacks");
        if (!this.shaderpacksFolder.exists()) {
            System.out.println("Creating Shaderpacks Folder");
            this.shaderpacksFolder.mkdirs();
        }
    }

    @Override
    public void initGui() {
        super.initGui();
        Keyboard.enableRepeatEvents((boolean)true);
        this.textField = new GuiTextField(this, this.mc.fontRenderer, this.width / 2 - 100, this.height / 2 - 10, 200, 20, "");
        this.textField.setFocused(true);
        this.controlList.add(new GuiButton(101, 16, this.height - 36, 160, 20, "Open Shaderpacks Folder"));
    }

    @Override
    public void drawScreen(int x, int y, float renderPartialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(x, y, renderPartialTicks);
        this.textField.drawTextBox();
        int cdark = 0x707070;
        this.minecraft.fontRenderer.drawStringWithShadow("Press CTRL+F7 to disable shaders", 16, 16, cdark);
        this.minecraft.fontRenderer.drawStringWithShadow("Selected Shaderpack: " + (String)this.minecraft.gameSettings.shaderpack.value, 16, 26, cdark);
        this.minecraft.fontRenderer.drawStringWithShadow("Enter Shaderpack: ", this.width / 2 - 100, this.height / 2 - 20, 0xFFFFFF);
        this.minecraft.fontRenderer.drawStringWithShadow("Press TAB for autocomplete", this.width / 2 - 100, this.height / 2 + 14, cdark);
        this.minecraft.fontRenderer.drawStringWithShadow("Leave empty for default", this.width / 2 - 100, this.height / 2 + 24, cdark);
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        super.actionPerformed(guibutton);
        if (guibutton.id == 101) {
            try {
                Desktop.getDesktop().open(this.shaderpacksFolder.getAbsoluteFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void keyTyped(char c, int i) {
        if (i != 14) {
            super.keyTyped(c, i);
        }
        String text = this.textField.getText();
        if (i == 28) {
            File[] files;
            System.out.println(text);
            File file = null;
            for (File f : files = this.shaderpacksFolder.listFiles()) {
                if (!f.getName().equalsIgnoreCase(text)) continue;
                file = f;
            }
            if (file == null && text.length() > 0) {
                return;
            }
            try {
                this.minecraft.gameSettings.shaderpack.set(file != null ? file.getName() : text);
                this.minecraft.gameSettings.shaders.value = true;
                this.minecraft.gameSettings.saveOptions();
                this.minecraft.render.reload();
                this.minecraft.displayGuiScreen(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (i == 15) {
            File[] files;
            boolean shift;
            if (this.tabPos == -1) {
                this.tabPos = text.length();
            }
            boolean bl = shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (shift) {
                this.tabI -= 2;
            }
            if ((files = this.shaderpacksFolder.listFiles()).length == 0) {
                return;
            }
            ArrayList<File> filterFiles = new ArrayList<File>();
            String t = text.substring(0, this.tabPos);
            for (File file : files) {
                if (!GuiShaderSelect.startsWidthIgnoreCase(file.getName(), t)) continue;
                filterFiles.add(file);
            }
            this.tabI = DynamicTexture.pmod(this.tabI, filterFiles.size());
            int j = 0;
            for (File file : filterFiles) {
                if (j >= this.tabI) {
                    ++this.tabI;
                    this.textField.setText(file.getName());
                    break;
                }
                ++j;
            }
        } else if (i != 42 && i != 54) {
            this.tabPos = -1;
            this.tabI = 0;
            this.textField.textboxKeyTyped(c, i);
        }
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public static boolean startsWidthIgnoreCase(String str, String start) {
        return str.toLowerCase().startsWith(start.toLowerCase());
    }
}

