/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;
import net.minecraft.src.helper.Direction;

public class ItemBlockSlab
extends ItemBlock {
    public ItemBlockSlab(int i) {
        super(i);
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, double heightPlaced) {
        int id = world.getBlockId(i, j, k);
        int meta = world.getBlockMetadata(i, j, k) & 3;
        int otherMeta = world.getBlockMetadata(i, j, k) & 0xFFFFFFFC;
        if (Block.blocksList[world.getBlockId(i, j, k)] != null && Block.blocksList[world.getBlockId((int)i, (int)j, (int)k)].placeOverwrites) {
            id = 0;
            meta = 0;
        }
        if (itemstack.stackSize == 0) {
            return false;
        }
        if (j == Minecraft.WORLD_HEIGHT_BLOCKS - 1 && Block.blocksList[this.blockID].blockMaterial.isSolid()) {
            return false;
        }
        if (id == this.blockID && otherMeta == itemstack.getMetadata() && (l == 1 || l == 0) && (l == 1 && meta == 0 || l == 0 && meta == 2)) {
            AxisAlignedBB bbBox = AxisAlignedBB.getBoundingBoxFromPool(i, j, k, (float)i + 1.0f, (float)j + 1.0f, (float)k + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            Block blockSlab = Block.blocksList[this.blockID];
            world.setBlockMetadataWithNotify(i, j, k, 1 | itemstack.getMetadata());
            world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, blockSlab.stepSound.func_1145_d(), (blockSlab.stepSound.getVolume() + 1.0f) / 2.0f, blockSlab.stepSound.getPitch() * 0.8f);
            itemstack.consumeItem(entityplayer);
            return true;
        }
        if (id != 0) {
            if (l == 0) {
                --j;
            }
            if (l == 1) {
                ++j;
            }
            if (l == 2) {
                --k;
            }
            if (l == 3) {
                ++k;
            }
            if (l == 4) {
                --i;
            }
            if (l == 5) {
                ++i;
            }
            id = world.getBlockId(i, j, k);
            meta = world.getBlockMetadata(i, j, k) & 3;
            otherMeta = world.getBlockMetadata(i, j, k) & 0xFFFFFFFC;
        }
        if (id == this.blockID && otherMeta == itemstack.getMetadata() && (heightPlaced > 0.5 && meta == 0 || heightPlaced <= 0.5 && meta == 2 || l == 0 && meta == 0 || l == 1 && meta == 2)) {
            AxisAlignedBB bbBox = AxisAlignedBB.getBoundingBoxFromPool(i, j, k, (float)i + 1.0f, (float)j + 1.0f, (float)k + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            Block blockSlab = Block.blocksList[this.blockID];
            world.setBlockMetadataWithNotify(i, j, k, 1 | itemstack.getMetadata());
            world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, blockSlab.stepSound.func_1145_d(), (blockSlab.stepSound.getVolume() + 1.0f) / 2.0f, blockSlab.stepSound.getPitch() * 0.8f);
            itemstack.consumeItem(entityplayer);
            return true;
        }
        if (world.canBlockBePlacedAt(this.blockID, i, j, k, false, l)) {
            Block block = Block.blocksList[this.blockID];
            if (world.setBlockAndMetadataWithNotify(i, j, k, this.blockID, this.getPlacedBlockMetadata(itemstack.getMetadata()))) {
                Block.blocksList[this.blockID].onBlockPlaced(world, i, j, k, Direction.getDirectionForLegacySide(l), entityplayer, heightPlaced);
                world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                itemstack.consumeItem(entityplayer);
            }
            return true;
        }
        return false;
    }
}

