/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityArrow;
import net.minecraft.src.EntityArrowGolden;
import net.minecraft.src.EntityArrowPurple;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public class ItemBow
extends Item {
    public ItemBow(int i) {
        super(i);
        this.maxStackSize = 1;
        this.setMaxDamage(384);
    }

    @Override
    public boolean shouldPointInFrontOfPlayer() {
        return true;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        ItemStack quiverSlot = entityplayer.inventory.armorItemInSlot(2);
        if (quiverSlot != null && quiverSlot.itemID == Item.armorQuiver.itemID && quiverSlot.getMetadata() < quiverSlot.getMaxDamage()) {
            entityplayer.inventory.armorItemInSlot(2).damageItem(1, entityplayer);
            itemstack.damageItem(1, entityplayer);
            world.playSoundAtEntity(entityplayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isMultiplayerAndNotHost) {
                world.entityJoinedWorld(new EntityArrow(world, entityplayer, true, 0));
            }
        } else if (quiverSlot != null && quiverSlot.itemID == Item.armorQuiverGold.itemID) {
            itemstack.damageItem(1, entityplayer);
            world.playSoundAtEntity(entityplayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isMultiplayerAndNotHost) {
                world.entityJoinedWorld(new EntityArrowPurple(world, entityplayer, false));
            }
        } else if (entityplayer.inventory.consumeInventoryItem(Item.ammoArrowGold.itemID)) {
            itemstack.damageItem(1, entityplayer);
            world.playSoundAtEntity(entityplayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isMultiplayerAndNotHost) {
                world.entityJoinedWorld(new EntityArrowGolden(world, entityplayer, true));
            }
        } else if (entityplayer.inventory.consumeInventoryItem(Item.ammoArrow.itemID)) {
            itemstack.damageItem(1, entityplayer);
            world.playSoundAtEntity(entityplayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isMultiplayerAndNotHost) {
                world.entityJoinedWorld(new EntityArrow(world, entityplayer, true, 0));
            }
        }
        return itemstack;
    }

    @Override
    public boolean isFull3D() {
        return true;
    }
}

