/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.EntityCow;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumMovingObjectType;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public class ItemBucketEmpty
extends Item {
    public ItemBucketEmpty(int id, int idToPlace) {
        super(id);
        this.maxStackSize = 64;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        float f9;
        float f6;
        float f8;
        double d3;
        float f5;
        float f = 1.0f;
        float f1 = entityplayer.prevRotationPitch + (entityplayer.rotationPitch - entityplayer.prevRotationPitch) * f;
        float f2 = entityplayer.prevRotationYaw + (entityplayer.rotationYaw - entityplayer.prevRotationYaw) * f;
        double d = entityplayer.prevPosX + (entityplayer.posX - entityplayer.prevPosX) * (double)f;
        double d1 = entityplayer.prevPosY + (entityplayer.posY - entityplayer.prevPosY) * (double)f + 1.62 - (double)entityplayer.yOffset;
        double d2 = entityplayer.prevPosZ + (entityplayer.posZ - entityplayer.prevPosZ) * (double)f;
        Vec3D vec3d = Vec3D.createVector(d, d1, d2);
        float f3 = MathHelper.cos(-f2 * 0.01745329f - 3.141593f);
        float f4 = MathHelper.sin(-f2 * 0.01745329f - 3.141593f);
        float f7 = f4 * (f5 = -MathHelper.cos(-f1 * 0.01745329f));
        Vec3D vec3d1 = vec3d.addVector((double)f7 * (d3 = 5.0), (double)(f8 = (f6 = MathHelper.sin(-f1 * 0.01745329f))) * d3, (double)(f9 = f3 * f5) * d3);
        MovingObjectPosition movingobjectposition = world.rayTraceBlocks_do(vec3d, vec3d1, true);
        if (movingobjectposition == null) {
            return itemstack;
        }
        if (movingobjectposition.typeOfHit == EnumMovingObjectType.TILE) {
            int i = movingobjectposition.blockX;
            int j = movingobjectposition.blockY;
            int k = movingobjectposition.blockZ;
            if (!world.canMineBlock(entityplayer, i, j, k)) {
                return itemstack;
            }
            if (world.getBlockMaterial(i, j, k) == Material.water && world.getBlockMetadata(i, j, k) == 0) {
                if (ItemBucketEmpty.UseBucket(entityplayer, new ItemStack(Item.bucketWater))) {
                    world.setBlockWithNotify(i, j, k, 0);
                    entityplayer.swingItem();
                }
            } else if (world.getBlockMaterial(i, j, k) == Material.lava && world.getBlockMetadata(i, j, k) == 0 && ItemBucketEmpty.UseBucket(entityplayer, new ItemStack(Item.bucketLava))) {
                world.setBlockWithNotify(i, j, k, 0);
                entityplayer.swingItem();
            }
        } else if (movingobjectposition.entityHit instanceof EntityCow) {
            ItemBucketEmpty.UseBucket(entityplayer, new ItemStack(Item.bucketMilk));
        }
        return itemstack;
    }

    public static boolean UseBucket(EntityPlayer entityPlayer, ItemStack ItemToGive) {
        if (entityPlayer.inventory.getCurrentItem().stackSize <= 1) {
            entityPlayer.inventory.setInventorySlotContents(entityPlayer.inventory.currentItem, ItemToGive);
            return true;
        }
        if (entityPlayer.inventory.addItemStackToInventory(ItemToGive)) {
            entityPlayer.inventory.getCurrentItem().consumeItem(entityPlayer);
            return true;
        }
        return false;
    }
}

