/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkLoader;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.RegionFileCache;
import net.minecraft.src.World;
import net.minecraft.src.WorldInfo;

public class McRegionChunkLoader
implements IChunkLoader {
    private final File worldDir;

    public McRegionChunkLoader(File file) {
        this.worldDir = file;
    }

    @Override
    public Chunk loadChunk(World world, int i, int j) throws IOException {
        DataInputStream datainputstream = RegionFileCache.getChunkInputStream(this.worldDir, i, j);
        if (datainputstream == null) {
            return null;
        }
        NBTTagCompound nbttagcompound = CompressedStreamTools.func_1141_a(datainputstream);
        if (!nbttagcompound.hasKey("Level")) {
            System.out.println("Chunk file at " + i + "," + j + " is missing level data, skipping");
            return null;
        }
        if (!nbttagcompound.getCompoundTag("Level").hasKey("Blocks")) {
            System.out.println("Chunk file at " + i + "," + j + " is missing block data, skipping");
            return null;
        }
        Chunk chunk = ChunkLoader.loadChunkIntoWorldFromCompound(world, nbttagcompound.getCompoundTag("Level"));
        if (!chunk.isAtLocation(i, j)) {
            System.out.println("Chunk file at " + i + "," + j + " is in the wrong location; relocating. (Expected " + i + ", " + j + ", got " + chunk.xPosition + ", " + chunk.zPosition + ")");
            nbttagcompound.setInteger("xPos", i);
            nbttagcompound.setInteger("zPos", j);
            chunk = ChunkLoader.loadChunkIntoWorldFromCompound(world, nbttagcompound.getCompoundTag("Level"));
        }
        chunk.func_25124_i();
        return chunk;
    }

    @Override
    public void saveChunk(World world, Chunk chunk) throws IOException {
        world.checkSessionLock();
        try {
            DataOutputStream dataoutputstream = RegionFileCache.getChunkOutputStream(this.worldDir, chunk.xPosition, chunk.zPosition);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound.setTag("Level", nbttagcompound1);
            ChunkLoader.storeChunkInCompound(chunk, world, nbttagcompound1);
            CompressedStreamTools.func_1139_a(nbttagcompound, dataoutputstream);
            dataoutputstream.close();
            WorldInfo worldinfo = world.getWorldInfo();
            worldinfo.setSizeOnDisk(worldinfo.getSizeOnDisk() + (long)RegionFileCache.getSizeDelta(this.worldDir, chunk.xPosition, chunk.zPosition));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void saveExtraChunkData(World world, Chunk chunk) throws IOException {
    }

    @Override
    public void func_814_a() {
    }

    @Override
    public void saveExtraData() {
    }
}

