/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.GLAllocation;
import net.minecraft.src.PositionTextureVertex;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TexturedQuad;
import org.lwjgl.opengl.GL11;

public class ModelRenderer {
    private PositionTextureVertex[] corners;
    private TexturedQuad[] faces;
    private int textureOffsetX;
    private int textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    private boolean compiled = false;
    private int displayList = 0;
    public boolean mirror = false;
    public boolean showModel = true;
    public boolean field_1402_i = false;

    public ModelRenderer(int i, int j) {
        this.textureOffsetX = i;
        this.textureOffsetY = j;
    }

    public void addBox(float f, float f1, float f2, int i, int j, int k) {
        this.addBox(f, f1, f2, i, j, k, 0.0f);
    }

    public void addBox(float f, float f1, float f2, int i, int j, int k, float f3) {
        this.corners = new PositionTextureVertex[8];
        this.faces = new TexturedQuad[6];
        float f4 = f + (float)i;
        float f5 = f1 + (float)j;
        float f6 = f2 + (float)k;
        f -= f3;
        f1 -= f3;
        f2 -= f3;
        f4 += f3;
        f5 += f3;
        f6 += f3;
        if (this.mirror) {
            float f7 = f4;
            f4 = f;
            f = f7;
        }
        PositionTextureVertex positiontexturevertex = new PositionTextureVertex(f, f1, f2, 0.0f, 0.0f);
        PositionTextureVertex positiontexturevertex1 = new PositionTextureVertex(f4, f1, f2, 0.0f, 8.0f);
        PositionTextureVertex positiontexturevertex2 = new PositionTextureVertex(f4, f5, f2, 8.0f, 8.0f);
        PositionTextureVertex positiontexturevertex3 = new PositionTextureVertex(f, f5, f2, 8.0f, 0.0f);
        PositionTextureVertex positiontexturevertex4 = new PositionTextureVertex(f, f1, f6, 0.0f, 0.0f);
        PositionTextureVertex positiontexturevertex5 = new PositionTextureVertex(f4, f1, f6, 0.0f, 8.0f);
        PositionTextureVertex positiontexturevertex6 = new PositionTextureVertex(f4, f5, f6, 8.0f, 8.0f);
        PositionTextureVertex positiontexturevertex7 = new PositionTextureVertex(f, f5, f6, 8.0f, 0.0f);
        this.corners[0] = positiontexturevertex;
        this.corners[1] = positiontexturevertex1;
        this.corners[2] = positiontexturevertex2;
        this.corners[3] = positiontexturevertex3;
        this.corners[4] = positiontexturevertex4;
        this.corners[5] = positiontexturevertex5;
        this.corners[6] = positiontexturevertex6;
        this.corners[7] = positiontexturevertex7;
        this.faces[0] = new TexturedQuad(new PositionTextureVertex[]{positiontexturevertex5, positiontexturevertex1, positiontexturevertex2, positiontexturevertex6}, this.textureOffsetX + k + i, this.textureOffsetY + k, this.textureOffsetX + k + i + k, this.textureOffsetY + k + j);
        this.faces[1] = new TexturedQuad(new PositionTextureVertex[]{positiontexturevertex, positiontexturevertex4, positiontexturevertex7, positiontexturevertex3}, this.textureOffsetX + 0, this.textureOffsetY + k, this.textureOffsetX + k, this.textureOffsetY + k + j);
        this.faces[2] = new TexturedQuad(new PositionTextureVertex[]{positiontexturevertex5, positiontexturevertex4, positiontexturevertex, positiontexturevertex1}, this.textureOffsetX + k, this.textureOffsetY + 0, this.textureOffsetX + k + i, this.textureOffsetY + k);
        this.faces[3] = new TexturedQuad(new PositionTextureVertex[]{positiontexturevertex2, positiontexturevertex3, positiontexturevertex7, positiontexturevertex6}, this.textureOffsetX + k + i, this.textureOffsetY + 0, this.textureOffsetX + k + i + i, this.textureOffsetY + k);
        this.faces[4] = new TexturedQuad(new PositionTextureVertex[]{positiontexturevertex1, positiontexturevertex, positiontexturevertex3, positiontexturevertex2}, this.textureOffsetX + k, this.textureOffsetY + k, this.textureOffsetX + k + i, this.textureOffsetY + k + j);
        this.faces[5] = new TexturedQuad(new PositionTextureVertex[]{positiontexturevertex4, positiontexturevertex5, positiontexturevertex6, positiontexturevertex7}, this.textureOffsetX + k + i + k, this.textureOffsetY + k, this.textureOffsetX + k + i + k + i, this.textureOffsetY + k + j);
        if (this.mirror) {
            for (int l = 0; l < this.faces.length; ++l) {
                this.faces[l].flipFace();
            }
        }
    }

    public void setRotationPoint(float f, float f1, float f2) {
        this.rotationPointX = f;
        this.rotationPointY = f1;
        this.rotationPointZ = f2;
    }

    public void render(float f) {
        if (this.field_1402_i) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glCallList((int)this.displayList);
            GL11.glPopMatrix();
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            GL11.glCallList((int)this.displayList);
            GL11.glTranslatef((float)(-this.rotationPointX * f), (float)(-this.rotationPointY * f), (float)(-this.rotationPointZ * f));
        } else {
            GL11.glCallList((int)this.displayList);
        }
    }

    public void renderWithRotation(float f) {
        if (this.field_1402_i) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
        if (this.rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (this.rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glCallList((int)this.displayList);
        GL11.glPopMatrix();
    }

    public void postRender(float f) {
        if (this.field_1402_i) {
            return;
        }
        if (!this.showModel) {
            return;
        }
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (this.rotationPointX != 0.0f || this.rotationPointY != 0.0f || this.rotationPointZ != 0.0f) {
            GL11.glTranslatef((float)(this.rotationPointX * f), (float)(this.rotationPointY * f), (float)(this.rotationPointZ * f));
        }
    }

    private void compileDisplayList(float f) {
        this.displayList = GLAllocation.generateDisplayLists(1);
        GL11.glNewList((int)this.displayList, (int)4864);
        Tessellator tessellator = Tessellator.instance;
        for (int i = 0; i < this.faces.length; ++i) {
            this.faces[i].draw(tessellator, f);
        }
        GL11.glEndList();
        this.compiled = true;
    }
}

