/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.src.NBTBase;

public class NBTTagShortArray
extends NBTBase {
    public short[] shortArray;

    public NBTTagShortArray() {
    }

    public NBTTagShortArray(short[] ashort0) {
        this.shortArray = ashort0;
    }

    @Override
    void writeTagContents(DataOutput dataoutput) throws IOException {
        dataoutput.writeInt(this.shortArray.length);
        byte[] bytes = new byte[this.shortArray.length * 2];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().put(this.shortArray);
        dataoutput.write(bytes);
    }

    @Override
    void readTagContents(DataInput datainput) throws IOException {
        int i = datainput.readInt();
        this.shortArray = new short[i];
        byte[] bytes = new byte[i * 2];
        datainput.readFully(bytes);
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(this.shortArray);
    }

    @Override
    public byte getType() {
        return 11;
    }

    public String toString() {
        return "[" + this.shortArray.length + " shorts]";
    }
}

