/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.IOException;
import java.net.Socket;
import java.util.Random;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.NetHandler;
import net.minecraft.src.NetServerHandler;
import net.minecraft.src.NetworkManager;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet1Login;
import net.minecraft.src.Packet255KickDisconnect;
import net.minecraft.src.Packet2Handshake;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.Packet41EntityPlayerGamemode;
import net.minecraft.src.Packet4UpdateTime;
import net.minecraft.src.Packet55WorldTypes;
import net.minecraft.src.Packet6SpawnPosition;
import net.minecraft.src.Packet72UpdatePlayerProfile;
import net.minecraft.src.ThreadLoginVerifier;
import net.minecraft.src.WorldServer;
import net.minecraft.src.command.ChatColor;

public class NetLoginHandler
extends NetHandler {
    public static Logger logger = Logger.getLogger("Minecraft");
    private static Random rand = new Random();
    public NetworkManager netManager;
    public boolean finishedProcessing = false;
    private MinecraftServer mcServer;
    private int loginTimer = 0;
    private String username = null;
    private Packet1Login packet1login = null;
    private String serverId = "";

    public NetLoginHandler(MinecraftServer minecraftserver, Socket socket, String s) throws IOException {
        this.mcServer = minecraftserver;
        this.netManager = new NetworkManager(socket, s, this);
        this.netManager.chunkDataSendCounter = 0;
    }

    public void tryLogin() {
        if (this.packet1login != null) {
            this.doLogin(this.packet1login);
            this.packet1login = null;
        }
        if (this.loginTimer++ == 600) {
            this.kickUser("Took too long to log in");
        } else {
            this.netManager.processReadPackets();
        }
    }

    public void kickUser(String s) {
        try {
            logger.info("Disconnecting " + this.getUserAndIPString() + ": " + s);
            this.netManager.addToSendQueue(new Packet255KickDisconnect(s));
            this.netManager.serverShutdown();
            this.finishedProcessing = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void handleHandshake(Packet2Handshake packet2handshake) {
        if (this.mcServer.onlineMode) {
            this.serverId = Long.toHexString(rand.nextLong());
            this.netManager.addToSendQueue(new Packet2Handshake(this.serverId));
        } else {
            this.netManager.addToSendQueue(new Packet2Handshake("-"));
        }
    }

    @Override
    public void handleLogin(Packet1Login packet1login) {
        this.username = packet1login.username;
        if (packet1login.protocolVersion != Minecraft.MP_PROTOCOL_VERSION) {
            if (packet1login.protocolVersion > Minecraft.MP_PROTOCOL_VERSION) {
                this.kickUser("Outdated server!");
            } else {
                this.kickUser("Outdated client!");
            }
            return;
        }
        if (!this.mcServer.onlineMode) {
            this.doLogin(packet1login);
        } else {
            new ThreadLoginVerifier(this, packet1login).start();
        }
    }

    public void doLogin(Packet1Login packet1login) {
        EntityPlayerMP entityplayermp = this.mcServer.configManager.login(this, packet1login.username);
        if (entityplayermp != null) {
            this.mcServer.configManager.readPlayerDataFromFile(entityplayermp);
            entityplayermp.setWorld(this.mcServer.getWorldManager(entityplayermp.dimension));
            logger.info(this.getUserAndIPString() + " logged in with entity id " + entityplayermp.entityId + " at (" + entityplayermp.posX + ", " + entityplayermp.posY + ", " + entityplayermp.posZ + ")");
            WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.dimension);
            ChunkCoordinates chunkcoordinates = worldserver.getSpawnPoint();
            NetServerHandler netserverhandler = new NetServerHandler(this.mcServer, this.netManager, entityplayermp);
            netserverhandler.sendPacket(new Packet55WorldTypes(worldserver.getWorldInfo().getWorldTypes()));
            netserverhandler.sendPacket(new Packet1Login("", entityplayermp.entityId, worldserver.getRandomSeed(), (byte)worldserver.dimension.dimId, NetworkManager.PACKET_DELAY));
            netserverhandler.sendPacket(new Packet6SpawnPosition(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z));
            this.mcServer.configManager.func_28170_a(entityplayermp, worldserver);
            this.mcServer.configManager.sendPacketToAllPlayers(new Packet3Chat(ChatColor.yellow + entityplayermp.getDisplayName() + ChatColor.yellow + " joined the game."));
            this.mcServer.configManager.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(entityplayermp.username, entityplayermp.nickname, entityplayermp.score, entityplayermp.chatColor, true, entityplayermp.isOperator()));
            if (this.mcServer.joinMessage != null && this.mcServer.joinMessage.length() > 0) {
                entityplayermp.playerNetServerHandler.sendPacket(new Packet3Chat(this.mcServer.joinMessage));
            }
            this.mcServer.configManager.playerLoggedIn(entityplayermp);
            netserverhandler.teleportTo(entityplayermp.posX, entityplayermp.posY, entityplayermp.posZ, entityplayermp.rotationYaw, entityplayermp.rotationPitch);
            this.mcServer.networkServer.addPlayer(netserverhandler);
            this.mcServer.configManager.sendPacketToPlayer(entityplayermp.username, new Packet41EntityPlayerGamemode(entityplayermp.gamemode.id));
            netserverhandler.sendPacket(new Packet4UpdateTime(worldserver.getWorldTime()));
            entityplayermp.func_20057_k();
        }
        this.finishedProcessing = true;
    }

    @Override
    public void handleErrorMessage(String s, Object[] aobj) {
        logger.info(this.getUserAndIPString() + " lost connection");
        this.finishedProcessing = true;
    }

    @Override
    public void handleInvalidPacket(Packet packet) {
        this.kickUser("Protocol error");
    }

    public String getUserAndIPString() {
        if (this.username != null) {
            return this.username + " [" + this.netManager.getRemoteAddress().toString() + "]";
        }
        return this.netManager.getRemoteAddress().toString();
    }

    @Override
    public boolean isServerHandler() {
        return true;
    }

    static String getServerId(NetLoginHandler netloginhandler) {
        return netloginhandler.serverId;
    }

    static Packet1Login setLoginPacket(NetLoginHandler netloginhandler, Packet1Login packet1login) {
        netloginhandler.packet1login = packet1login;
        return netloginhandler.packet1login;
    }
}

