/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NetHandler;
import net.minecraft.src.Packet;

public class Packet15Place
extends Packet {
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public int direction;
    public double heightPlaced;
    public ItemStack itemStack;

    public Packet15Place() {
    }

    public Packet15Place(int i, int j, int k, int l, ItemStack itemstack, double heightPlaced) {
        this.xPosition = i;
        this.yPosition = j;
        this.zPosition = k;
        this.direction = l;
        this.itemStack = itemstack;
        this.heightPlaced = heightPlaced;
    }

    @Override
    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.xPosition = datainputstream.readInt();
        this.yPosition = datainputstream.read();
        this.zPosition = datainputstream.readInt();
        this.direction = datainputstream.read();
        this.heightPlaced = datainputstream.readDouble();
        short word0 = datainputstream.readShort();
        if (word0 >= 0) {
            byte byte0 = datainputstream.readByte();
            short word1 = datainputstream.readShort();
            this.itemStack = new ItemStack(word0, (int)byte0, (int)word1);
        } else {
            this.itemStack = null;
        }
    }

    @Override
    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeInt(this.xPosition);
        dataoutputstream.write(this.yPosition);
        dataoutputstream.writeInt(this.zPosition);
        dataoutputstream.write(this.direction);
        dataoutputstream.writeDouble(this.heightPlaced);
        if (this.itemStack == null) {
            dataoutputstream.writeShort(-1);
        } else {
            dataoutputstream.writeShort(this.itemStack.itemID);
            dataoutputstream.writeByte(this.itemStack.stackSize);
            dataoutputstream.writeShort(this.itemStack.getMetadata());
        }
    }

    @Override
    public void processPacket(NetHandler nethandler) {
        nethandler.handlePlace(this);
    }

    @Override
    public int getPacketSize() {
        return 15;
    }
}

