/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.ItemStack;
import net.minecraft.src.World;

public abstract class PlayerController {
    public static boolean clickMining = true;
    protected float currentDamage;
    protected float previousDamage;
    protected int soundDelay;
    protected int blockHitDelay;
    protected int swingCooldown = 0;
    protected Integer miningX;
    protected Integer miningY;
    protected Integer miningZ;
    protected final Minecraft mc;
    public boolean field_1064_b = false;

    public PlayerController(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void clickBlock(int x, int y, int z, int side, boolean repeat) {
        float mineStrength;
        if (!this.mc.thePlayer.getGamemode().doBlockBreakingAnim) {
            this.mc.thePlayer.swingItem();
            this.destroyBlock(x, y, z, side);
            this.sendStartDigPacket(x, y, z, side);
            return;
        }
        Block mineBlock = Block.getBlock(this.mc.theWorld.getBlockId(x, y, z));
        if (mineBlock != null && (mineStrength = mineBlock.blockStrength(this.mc.thePlayer)) < 1.0f && !repeat) {
            this.sendStartDigPacket(x, y, z, side);
            this.hitBlock(x, y, z, side);
        }
    }

    public void mine(int x, int y, int z, int side) {
        if (!this.mc.thePlayer.getGamemode().doBlockBreakingAnim) {
            return;
        }
        this.swingItem();
        if (this.blockHitDelay > 0) {
            --this.blockHitDelay;
            return;
        }
        Block mineBlock = Block.getBlock(this.mc.theWorld.getBlockId(x, y, z));
        if (mineBlock != null) {
            this.syncCurrentPlayItem();
            float mineStrength = mineBlock.blockStrength(this.mc.thePlayer);
            if (mineStrength >= 1.0f) {
                this.setMineBlock(x, y, z);
                this.destroyBlock(x, y, z, side);
                this.sendStartDigPacket(x, y, z, side);
                this.currentDamage = 0.0f;
                this.previousDamage = 0.0f;
                this.soundDelay = 0;
                this.blockHitDelay = 1;
            } else {
                if (!this.isMiningBlock(x, y, z)) {
                    this.sendStartDigPacket(x, y, z, side);
                    this.currentDamage = 0.0f;
                    this.previousDamage = 0.0f;
                    this.setMineBlock(x, y, z);
                }
                this.mc.effectRenderer.addBlockHitEffects(x, y, z, side);
                this.playDigSound(mineBlock, x, y, z);
                this.currentDamage += mineStrength;
                if (this.currentDamage > 1.0f) {
                    ItemStack stack = this.mc.thePlayer.inventory.getCurrentItem();
                    this.blockHitDelay = stack != null && stack.getItem() != null ? stack.getItem().getBlockHitDelay() : 5;
                    this.destroyBlock(x, y, z, side);
                    this.sendDestroyBlockPacket(x, y, z, side);
                    this.currentDamage = 0.0f;
                    this.previousDamage = 0.0f;
                    this.soundDelay = 0;
                }
            }
        } else {
            this.currentDamage = 0.0f;
            this.previousDamage = 0.0f;
            this.soundDelay = 0;
        }
    }

    public void swingItem() {
        if (this.swingCooldown == 0) {
            this.mc.thePlayer.swingItem();
            this.swingCooldown = 4;
        }
    }

    public boolean destroyBlock(int x, int y, int z, int side) {
        this.setMineBlock(null, null, null);
        World world = this.mc.theWorld;
        Block block = Block.getBlock(world.getBlockId(x, y, z));
        if (block == null) {
            return false;
        }
        world.playSoundEffect(2001, x, y, z, block.blockID);
        int meta = world.getBlockMetadata(x, y, z);
        boolean removed = world.setBlockWithNotify(x, y, z, 0);
        if (block != null && removed) {
            block.onBlockDestroyedByPlayer(world, x, y, z, meta);
        }
        return removed;
    }

    public void dontMine(boolean leftClickDown) {
        this.currentDamage = 0.0f;
        this.previousDamage = 0.0f;
        this.soundDelay = 0;
        if (this.blockHitDelay > 0) {
            --this.blockHitDelay;
        }
        if (!leftClickDown && clickMining) {
            this.blockHitDelay = 0;
        }
    }

    protected void hitBlock(int x, int y, int z, int side) {
        if (!this.mc.theWorld.isMultiplayerAndNotHost) {
            this.mc.theWorld.onBlockHit(this.mc.thePlayer, x, y, z, side);
            Block block = Block.getBlock(this.mc.theWorld.getBlockId(x, y, z));
            if (block != null) {
                block.onBlockClicked(this.mc.theWorld, x, y, z, this.mc.thePlayer);
            }
        }
    }

    private boolean isMiningBlock(int x, int y, int z) {
        return this.miningX != null && this.miningX == x && this.miningY != null && this.miningY == y && this.miningZ != null && this.miningZ == z;
    }

    private void setMineBlock(Integer x, Integer y, Integer z) {
        this.miningX = x;
        this.miningY = y;
        this.miningZ = z;
    }

    public void setPartialTime(float f) {
        if (this.currentDamage <= 0.0f) {
            this.mc.ingameGUI.damageGuiPartialTime = 0.0f;
            this.mc.renderGlobal.damagePartialTime = 0.0f;
        } else {
            float f1;
            this.mc.ingameGUI.damageGuiPartialTime = f1 = this.previousDamage + (this.currentDamage - this.previousDamage) * f;
            this.mc.renderGlobal.damagePartialTime = f1;
        }
    }

    public float getBlockReachDistance() {
        return 4.0f;
    }

    public boolean sendUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        int i = itemstack.stackSize;
        ItemStack itemstack1 = itemstack.useItemRightClick(world, entityplayer);
        if (itemstack1 != itemstack || itemstack1.stackSize != i) {
            entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = itemstack1;
            if (itemstack1 == null || itemstack1.stackSize == 0) {
                entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = null;
            }
            return true;
        }
        return false;
    }

    public void flipPlayer(EntityPlayer entityplayer) {
        entityplayer.rotationYaw = -180.0f;
    }

    public void updateController() {
        if (this.swingCooldown > 0) {
            --this.swingCooldown;
        }
        this.syncCurrentPlayItem();
        this.previousDamage = this.currentDamage;
        this.mc.sndManager.playRandomMusicIfReady();
    }

    public boolean shouldDrawHUD() {
        return true;
    }

    public void func_6473_b(EntityPlayer entityplayer) {
    }

    public boolean activeBlockOrUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack, int i, int j, int k, int l, double heightPlaced) {
        int i1 = world.getBlockId(i, j, k);
        if ((!entityplayer.isSneaking() || entityplayer.inventory.getCurrentItem() == null) && i1 > 0 && Block.blocksList[i1].blockActivated(world, i, j, k, entityplayer)) {
            return true;
        }
        if (itemstack == null) {
            return false;
        }
        return itemstack.useItem(entityplayer, world, i, j, k, l, heightPlaced);
    }

    public EntityPlayer createPlayer(World world) {
        return new EntityPlayerSP(this.mc, world, this.mc.session, world.dimension.dimId);
    }

    public void interactWithEntity(EntityPlayer entityplayer, Entity entity) {
        entityplayer.useCurrentItemOnEntity(entity);
    }

    public void attackEntity(EntityPlayer entityplayer, Entity entity) {
        entityplayer.attackTargetEntityWithCurrentItem(entity);
    }

    public ItemStack itemPickUpFromInventory(int i, int j, int k, boolean flag, boolean control, EntityPlayer entityplayer) {
        return entityplayer.craftingInventory.clickInventorySlot(j, k, flag, control, entityplayer);
    }

    public void func_20086_a(int i, EntityPlayer entityplayer) {
        entityplayer.craftingInventory.onCraftGuiClosed(entityplayer);
        entityplayer.craftingInventory = entityplayer.inventorySlots;
    }

    public void playDigSound(Block block, int x, int y, int z) {
        if (this.soundDelay <= 0) {
            this.mc.sndManager.playSound(block.stepSound.func_1145_d(), (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, (block.stepSound.getVolume() + 1.0f) / 8.0f, block.stepSound.getPitch() * 0.5f);
            this.soundDelay = 3;
        } else {
            --this.soundDelay;
        }
    }

    public boolean isBlockFullyMined() {
        return this.currentDamage >= 1.0f;
    }

    protected void syncCurrentPlayItem() {
    }

    public void sendStartDigPacket(int x, int y, int z, int side) {
    }

    public void sendDestroyBlockPacket(int x, int y, int z, int side) {
    }

    public void changeWorld(World world) {
    }
}

