/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.PlayerHash;
import net.minecraft.src.PlayerInstance;
import net.minecraft.src.WorldServer;

public class PlayerManager {
    public List players;
    private PlayerHash playerInstances;
    private List playerInstancesToUpdate;
    private MinecraftServer mcServer;
    private int field_28110_e;
    private int playerViewRadius;
    private final int[][] field_22089_e = new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}};

    public PlayerManager(MinecraftServer minecraftserver, int i, int j) {
        this.players = new ArrayList();
        this.playerInstances = new PlayerHash();
        this.playerInstancesToUpdate = new ArrayList();
        if (j > 15) {
            throw new IllegalArgumentException("Too big view radius!");
        }
        if (j < 3) {
            throw new IllegalArgumentException("Too small view radius!");
        }
        this.playerViewRadius = j;
        this.mcServer = minecraftserver;
        this.field_28110_e = i;
    }

    public WorldServer getMinecraftServer() {
        return this.mcServer.getWorldManager(this.field_28110_e);
    }

    public void updatePlayerInstances() {
        for (int i = 0; i < this.playerInstancesToUpdate.size(); ++i) {
            ((PlayerInstance)this.playerInstancesToUpdate.get(i)).onUpdate();
        }
        this.playerInstancesToUpdate.clear();
    }

    private PlayerInstance getPlayerInstance(int i, int j, boolean flag) {
        long l = (long)i + Integer.MAX_VALUE | (long)j + Integer.MAX_VALUE << 32;
        PlayerInstance playerinstance = (PlayerInstance)this.playerInstances.getValueByKey(l);
        if (playerinstance == null && flag) {
            playerinstance = new PlayerInstance(this, i, j);
            this.playerInstances.add(l, playerinstance);
        }
        return playerinstance;
    }

    public void markBlockNeedsUpdate(int i, int j, int k) {
        int l = i >> 4;
        int i1 = k >> 4;
        PlayerInstance playerinstance = this.getPlayerInstance(l, i1, false);
        if (playerinstance != null) {
            playerinstance.markBlockNeedsUpdate(i & 0xF, j, k & 0xF);
        }
    }

    public void addPlayer(EntityPlayerMP entityplayermp) {
        int i = (int)entityplayermp.posX >> 4;
        int j = (int)entityplayermp.posZ >> 4;
        entityplayermp.field_9155_d = entityplayermp.posX;
        entityplayermp.field_9154_e = entityplayermp.posZ;
        int k = 0;
        int l = this.playerViewRadius;
        int i1 = 0;
        int j1 = 0;
        this.getPlayerInstance(i, j, true).addPlayer(entityplayermp);
        for (int k1 = 1; k1 <= l * 2; ++k1) {
            for (int i2 = 0; i2 < 2; ++i2) {
                int[] ai = this.field_22089_e[k++ % 4];
                for (int j2 = 0; j2 < k1; ++j2) {
                    this.getPlayerInstance(i + (i1 += ai[0]), j + (j1 += ai[1]), true).addPlayer(entityplayermp);
                }
            }
        }
        k %= 4;
        for (int l1 = 0; l1 < l * 2; ++l1) {
            this.getPlayerInstance(i + (i1 += this.field_22089_e[k][0]), j + (j1 += this.field_22089_e[k][1]), true).addPlayer(entityplayermp);
        }
        this.players.add(entityplayermp);
    }

    public void removePlayer(EntityPlayerMP entityplayermp) {
        int i = (int)entityplayermp.field_9155_d >> 4;
        int j = (int)entityplayermp.field_9154_e >> 4;
        for (int k = i - this.playerViewRadius; k <= i + this.playerViewRadius; ++k) {
            for (int l = j - this.playerViewRadius; l <= j + this.playerViewRadius; ++l) {
                PlayerInstance playerinstance = this.getPlayerInstance(k, l, false);
                if (playerinstance == null) continue;
                playerinstance.removePlayer(entityplayermp);
            }
        }
        this.players.remove(entityplayermp);
    }

    private boolean func_544_a(int i, int j, int k, int l) {
        int i1 = i - k;
        int j1 = j - l;
        if (i1 < -this.playerViewRadius || i1 > this.playerViewRadius) {
            return false;
        }
        return j1 >= -this.playerViewRadius && j1 <= this.playerViewRadius;
    }

    public void func_543_c(EntityPlayerMP entityplayermp) {
        int i = (int)entityplayermp.posX >> 4;
        int j = (int)entityplayermp.posZ >> 4;
        double d = entityplayermp.field_9155_d - entityplayermp.posX;
        double d1 = entityplayermp.field_9154_e - entityplayermp.posZ;
        double d2 = d * d + d1 * d1;
        if (d2 < 64.0) {
            return;
        }
        int k = (int)entityplayermp.field_9155_d >> 4;
        int l = (int)entityplayermp.field_9154_e >> 4;
        int i1 = i - k;
        int j1 = j - l;
        if (i1 == 0 && j1 == 0) {
            return;
        }
        for (int k1 = i - this.playerViewRadius; k1 <= i + this.playerViewRadius; ++k1) {
            for (int l1 = j - this.playerViewRadius; l1 <= j + this.playerViewRadius; ++l1) {
                PlayerInstance playerinstance;
                if (!this.func_544_a(k1, l1, k, l)) {
                    this.getPlayerInstance(k1, l1, true).addPlayer(entityplayermp);
                }
                if (this.func_544_a(k1 - i1, l1 - j1, i, j) || (playerinstance = this.getPlayerInstance(k1 - i1, l1 - j1, false)) == null) continue;
                playerinstance.removePlayer(entityplayermp);
            }
        }
        entityplayermp.field_9155_d = entityplayermp.posX;
        entityplayermp.field_9154_e = entityplayermp.posZ;
    }

    public int getMaxTrackingDistance() {
        return this.playerViewRadius * 16 - 16;
    }

    static PlayerHash getPlayerInstances(PlayerManager playermanager) {
        return playermanager.playerInstances;
    }

    static List getPlayerInstancesToUpdate(PlayerManager playermanager) {
        return playermanager.playerInstancesToUpdate;
    }
}

