/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import net.minecraft.src.ImageParser;

public class PlayerSkinParser
implements ImageParser {
    public static final PlayerSkinParser instance = new PlayerSkinParser();
    private int[] imageData;
    private int width = 64;
    private int height = 32;

    @Override
    public BufferedImage parseImage(BufferedImage image) {
        if (image == null) {
            return null;
        }
        BufferedImage newImage = new BufferedImage(this.width, this.height, 2);
        Graphics g = newImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        this.imageData = ((DataBufferInt)newImage.getRaster().getDataBuffer()).getData();
        this.removeTransparency(0, 0, 32, 16);
        this.removeTransparency(0, 16, 64, 32);
        return newImage;
    }

    private void removeTransparency(int x1, int y1, int w2, int h2) {
        for (int x = x1; x < w2; ++x) {
            for (int y = y1; y < h2; ++y) {
                int n = x + y * this.width;
                this.imageData[n] = this.imageData[n] | 0xFF000000;
            }
        }
    }
}

