/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.src.RegionFileChunkBuffer;

public class RegionFile {
    private static final byte[] emptySector = new byte[4096];
    private final File fileName;
    private RandomAccessFile dataFile;
    private final int[] offsets = new int[1024];
    private final int[] field_22217_e = new int[1024];
    private ArrayList sectorFree;
    private int sizeDelta;
    private long field_22214_h = 0L;

    public RegionFile(File file) {
        this.fileName = file;
        this.debugln("REGION LOAD " + this.fileName);
        this.sizeDelta = 0;
        try {
            if (file.exists()) {
                this.field_22214_h = file.lastModified();
            }
            this.dataFile = new RandomAccessFile(file, "rw");
            if (this.dataFile.length() < 4096L) {
                for (int i = 0; i < 1024; ++i) {
                    this.dataFile.writeInt(0);
                }
                for (int j = 0; j < 1024; ++j) {
                    this.dataFile.writeInt(0);
                }
                this.sizeDelta += 8192;
            }
            if ((this.dataFile.length() & 0xFFFL) != 0L) {
                int k = 0;
                while ((long)k < (this.dataFile.length() & 0xFFFL)) {
                    this.dataFile.write(0);
                    ++k;
                }
            }
            int l = (int)this.dataFile.length() / 4096;
            this.sectorFree = new ArrayList(l);
            for (int i1 = 0; i1 < l; ++i1) {
                this.sectorFree.add(true);
            }
            this.sectorFree.set(0, false);
            this.sectorFree.set(1, false);
            this.dataFile.seek(0L);
            for (int j1 = 0; j1 < 1024; ++j1) {
                int l1;
                this.offsets[j1] = l1 = this.dataFile.readInt();
                if (l1 == 0 || (l1 >> 8) + (l1 & 0xFF) > this.sectorFree.size()) continue;
                for (int j2 = 0; j2 < (l1 & 0xFF); ++j2) {
                    this.sectorFree.set((l1 >> 8) + j2, false);
                }
            }
            for (int k1 = 0; k1 < 1024; ++k1) {
                int i2;
                this.field_22217_e[k1] = i2 = this.dataFile.readInt();
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public synchronized int func_22209_a() {
        int i = this.sizeDelta;
        this.sizeDelta = 0;
        return i;
    }

    private void func_22211_a(String s) {
    }

    private void debugln(String s) {
        this.func_22211_a(s + "\n");
    }

    private void func_22199_a(String s, int i, int j, String s1) {
        this.func_22211_a("REGION " + s + " " + this.fileName.getName() + "[" + i + "," + j + "] = " + s1);
    }

    private void func_22197_a(String s, int i, int j, int k, String s1) {
        this.func_22211_a("REGION " + s + " " + this.fileName.getName() + "[" + i + "," + j + "] " + k + "B = " + s1);
    }

    private void debugln(String s, int i, int j, String s1) {
        this.func_22199_a(s, i, j, s1 + "\n");
    }

    public synchronized DataInputStream getChunkDataInputStream(int i, int j) {
        if (this.outOfBounds(i, j)) {
            this.debugln("READ", i, j, "out of bounds");
            return null;
        }
        try {
            int k = this.getOffset(i, j);
            if (k == 0) {
                return null;
            }
            int l = k >> 8;
            int i1 = k & 0xFF;
            if (l + i1 > this.sectorFree.size()) {
                this.debugln("READ", i, j, "invalid sector");
                return null;
            }
            this.dataFile.seek(l * 4096);
            int j1 = this.dataFile.readInt();
            if (j1 > 4096 * i1) {
                this.debugln("READ", i, j, "invalid length: " + j1 + " > 4096 * " + i1);
                return null;
            }
            byte byte0 = this.dataFile.readByte();
            if (byte0 == 1) {
                byte[] abyte0 = new byte[j1 - 1];
                this.dataFile.read(abyte0);
                DataInputStream datainputstream = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(abyte0)));
                return datainputstream;
            }
            if (byte0 == 2) {
                byte[] abyte1 = new byte[j1 - 1];
                this.dataFile.read(abyte1);
                DataInputStream datainputstream1 = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(abyte1)));
                return datainputstream1;
            }
            this.debugln("READ", i, j, "unknown version " + byte0);
            return null;
        }
        catch (IOException ioexception) {
            this.debugln("READ", i, j, "exception");
            return null;
        }
    }

    public DataOutputStream getChunkDataOutputStream(int i, int j) {
        if (this.outOfBounds(i, j)) {
            return null;
        }
        return new DataOutputStream(new DeflaterOutputStream(new RegionFileChunkBuffer(this, i, j)));
    }

    protected synchronized void write(int i, int j, byte[] abyte0, int k) {
        try {
            int l = this.getOffset(i, j);
            int i1 = l >> 8;
            int l1 = l & 0xFF;
            int i2 = (k + 5) / 4096 + 1;
            if (i2 >= 256) {
                return;
            }
            if (i1 != 0 && l1 == i2) {
                this.func_22197_a("SAVE", i, j, k, "rewrite");
                this.write(i1, abyte0, k);
            } else {
                for (int j2 = 0; j2 < l1; ++j2) {
                    this.sectorFree.set(i1 + j2, true);
                }
                int k2 = this.sectorFree.indexOf(true);
                int l2 = 0;
                if (k2 != -1) {
                    for (int i3 = k2; i3 < this.sectorFree.size(); ++i3) {
                        if (l2 != 0) {
                            l2 = ((Boolean)this.sectorFree.get(i3)).booleanValue() ? ++l2 : 0;
                        } else if (((Boolean)this.sectorFree.get(i3)).booleanValue()) {
                            k2 = i3;
                            l2 = 1;
                        }
                        if (l2 >= i2) break;
                    }
                }
                if (l2 >= i2) {
                    this.func_22197_a("SAVE", i, j, k, "reuse");
                    int j1 = k2;
                    this.setOffset(i, j, j1 << 8 | i2);
                    for (int j3 = 0; j3 < i2; ++j3) {
                        this.sectorFree.set(j1 + j3, false);
                    }
                    this.write(j1, abyte0, k);
                } else {
                    this.func_22197_a("SAVE", i, j, k, "grow");
                    this.dataFile.seek(this.dataFile.length());
                    int k1 = this.sectorFree.size();
                    for (int k3 = 0; k3 < i2; ++k3) {
                        this.dataFile.write(emptySector);
                        this.sectorFree.add(false);
                    }
                    this.sizeDelta += 4096 * i2;
                    this.write(k1, abyte0, k);
                    this.setOffset(i, j, k1 << 8 | i2);
                }
            }
            this.func_22208_b(i, j, (int)(System.currentTimeMillis() / 1000L));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private void write(int i, byte[] abyte0, int j) throws IOException {
        this.debugln(" " + i);
        this.dataFile.seek(i * 4096);
        this.dataFile.writeInt(j + 1);
        this.dataFile.writeByte(2);
        this.dataFile.write(abyte0, 0, j);
    }

    private boolean outOfBounds(int i, int j) {
        return i < 0 || i >= 32 || j < 0 || j >= 32;
    }

    private int getOffset(int i, int j) {
        return this.offsets[i + j * 32];
    }

    public boolean func_22202_c(int i, int j) {
        return this.getOffset(i, j) != 0;
    }

    private void setOffset(int i, int j, int k) throws IOException {
        this.offsets[i + j * 32] = k;
        this.dataFile.seek((i + j * 32) * 4);
        this.dataFile.writeInt(k);
    }

    private void func_22208_b(int i, int j, int k) throws IOException {
        this.field_22217_e[i + j * 32] = k;
        this.dataFile.seek(4096 + (i + j * 32) * 4);
        this.dataFile.writeInt(k);
    }

    public void func_22196_b() throws IOException {
        this.dataFile.close();
    }
}

