/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Entity;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.ImageParser;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBase;
import net.minecraft.src.ModelBiped;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderManager;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TextureFX;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public abstract class Render {
    protected RenderManager renderManager;
    private ModelBase modelBase = new ModelBiped();
    private RenderBlocks renderBlocks = new RenderBlocks();
    protected float shadowSize = 0.0f;
    protected float field_194_c = 1.0f;

    public abstract void doRender(Entity var1, double var2, double var4, double var6, float var8, float var9);

    protected void loadTexture(String s) {
        RenderEngine renderEngine = this.renderManager.renderEngine;
        if (renderEngine != null) {
            renderEngine.bindTexture(renderEngine.getTexture(s));
        }
    }

    private void renderEntityOnFire(Entity entity, double d, double d1, double d2, float f) {
        GL11.glDisable((int)2896);
        int i = Block.texCoordToIndex(15, 1);
        int j = i % net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k = i / net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        float f1 = (float)j / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f3 = ((float)j + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f5 = (float)k / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        float f7 = ((float)k + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        float f9 = entity.width * 1.4f;
        GL11.glScalef((float)f9, (float)f9, (float)f9);
        this.loadTexture("/terrain.png");
        Tessellator tessellator = Tessellator.instance;
        float f10 = 0.5f;
        float f11 = 0.0f;
        float f12 = entity.height;
        float f13 = (float)(entity.posY - entity.boundingBox.minY);
        GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-0.3f + (float)((int)f12) * 0.02f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f14 = 0.0f;
        int l = 0;
        tessellator.startDrawingQuads();
        while (f12 > 0.0f) {
            float f8;
            float f6;
            float f4;
            float f2;
            if (l % 2 == 0) {
                f2 = (float)j / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f4 = ((float)j + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f6 = (float)k / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f8 = ((float)k + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            } else {
                f2 = (float)j / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f4 = ((float)j + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f6 = (float)(k + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
                f8 = ((float)(k + TextureFX.tileWidthTerrain) + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * net.minecraft.shared.Minecraft.TEXTURE_ATLAS_WIDTH_TILES);
            }
            if (l / 2 % 2 == 0) {
                float f15 = f4;
                f4 = f2;
                f2 = f15;
            }
            tessellator.addVertexWithUV(f10 - f11, 0.0f - f13, f14, f4, f8);
            tessellator.addVertexWithUV(-f10 - f11, 0.0f - f13, f14, f2, f8);
            tessellator.addVertexWithUV(-f10 - f11, 1.4f - f13, f14, f2, f6);
            tessellator.addVertexWithUV(f10 - f11, 1.4f - f13, f14, f4, f6);
            f12 -= 0.45f;
            f13 -= 0.45f;
            f10 *= 0.9f;
            f14 += 0.03f;
            ++l;
        }
        tessellator.draw();
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
    }

    private void renderShadow(Entity entity, double d, double d1, double d2, float f, float f1) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderEngine renderengine = this.renderManager.renderEngine;
        renderengine.bindTexture(renderengine.getTexture("%clamp%/misc/shadow.png"));
        World world = this.getWorldFromRenderManager();
        GL11.glDepthMask((boolean)false);
        float f2 = this.shadowSize;
        double d3 = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)f1;
        double d4 = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)f1 + (double)entity.getShadowSize();
        double d5 = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)f1;
        int i = MathHelper.floor_double(d3 - (double)f2);
        int j = MathHelper.floor_double(d3 + (double)f2);
        int k = MathHelper.floor_double(d4 - (double)f2);
        int l = MathHelper.floor_double(d4);
        int i1 = MathHelper.floor_double(d5 - (double)f2);
        int j1 = MathHelper.floor_double(d5 + (double)f2);
        double d6 = d - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        for (int k1 = i; k1 <= j; ++k1) {
            for (int l1 = k; l1 <= l; ++l1) {
                for (int i2 = i1; i2 <= j1; ++i2) {
                    int j2 = world.getBlockId(k1, l1 - 1, i2);
                    if (j2 <= 0 || world.getBlockLightValue(k1, l1, i2) <= 3) continue;
                    this.renderShadowOnBlock(Block.blocksList[j2], d, d1 + (double)entity.getShadowSize(), d2, k1, l1, i2, f, f2, d6, d7 + (double)entity.getShadowSize(), d8);
                }
            }
        }
        tessellator.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    private World getWorldFromRenderManager() {
        return this.renderManager.worldObj;
    }

    private void renderShadowOnBlock(Block block, double d, double d1, double d2, int i, int j, int k, float f, float f1, double d3, double d4, double d5) {
        double d6;
        Tessellator tessellator = Tessellator.instance;
        if (!block.renderAsNormalBlock()) {
            return;
        }
        double brightness = this.getWorldFromRenderManager().getLightBrightness(i, j, k);
        if (Minecraft.getMinecraft().fullbright) {
            brightness = 1.0;
        }
        if ((d6 = ((double)f - (d1 - ((double)j + d4)) / 2.0) * 0.5 * brightness) < 0.0) {
            return;
        }
        if (d6 > 1.0) {
            d6 = 1.0;
        }
        tessellator.setColorRGBA_F(1.0f, 1.0f, 1.0f, (float)d6);
        double d7 = (double)i + block.minX + d3;
        double d8 = (double)i + block.maxX + d3;
        double d9 = (double)j + block.minY + d4 + 0.015625;
        double d10 = (double)k + block.minZ + d5;
        double d11 = (double)k + block.maxZ + d5;
        float f2 = (float)((d - d7) / 2.0 / (double)f1 + 0.5);
        float f3 = (float)((d - d8) / 2.0 / (double)f1 + 0.5);
        float f4 = (float)((d2 - d10) / 2.0 / (double)f1 + 0.5);
        float f5 = (float)((d2 - d11) / 2.0 / (double)f1 + 0.5);
        tessellator.addVertexWithUV(d7, d9, d10, f2, f4);
        tessellator.addVertexWithUV(d7, d9, d11, f2, f5);
        tessellator.addVertexWithUV(d8, d9, d11, f3, f5);
        tessellator.addVertexWithUV(d8, d9, d10, f3, f4);
    }

    public static void renderOffsetAABB(AxisAlignedBB axisalignedbb, double d, double d1, double d2) {
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.setTranslationD(d, d1, d2);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.setTranslationD(0.0, 0.0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    public static void renderAABB(AxisAlignedBB axisalignedbb) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.draw();
    }

    public void setRenderManager(RenderManager rendermanager) {
        this.renderManager = rendermanager;
    }

    public void doRenderShadowAndFire(Entity entity, double d, double d1, double d2, float f, float f1) {
        double d3;
        float f2;
        if (this.renderManager.options != null && ((Boolean)this.renderManager.options.fancyGraphics.value).booleanValue() && this.shadowSize > 0.0f && (f2 = (float)((1.0 - (d3 = this.renderManager.func_851_a(entity.posX, entity.posY, entity.posZ)) / 256.0) * (double)this.field_194_c)) > 0.0f) {
            this.renderShadow(entity, d, d1, d2, f2, f1);
        }
        if (entity.isBurning()) {
            this.renderEntityOnFire(entity, d, d1, d2, f1);
        }
    }

    public FontRenderer getFontRendererFromRenderManager() {
        return this.renderManager.getFontRenderer();
    }

    public boolean loadDownloadableTexture(String url, String localTexture, ImageParser imageParser) {
        return this.renderManager.renderEngine.loadDownloadableTexture(url, localTexture, imageParser);
    }
}

