/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.Minecraft;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.MathHelper;
import net.minecraft.src.ModelBase;
import net.minecraft.src.Render;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

public class RenderLiving
extends Render {
    protected ModelBase mainModel;
    protected ModelBase renderPassModel;
    protected ModelBase overlayModel;
    protected String overlayTexture;

    public RenderLiving(ModelBase modelbase, float f) {
        this.mainModel = modelbase;
        this.shadowSize = f;
    }

    public void setRenderPassModel(ModelBase modelbase) {
        this.renderPassModel = modelbase;
    }

    public void setOverlayModel(ModelBase modelbase, String texture) {
        this.overlayModel = modelbase;
        this.overlayTexture = texture;
    }

    public void doRenderLiving(EntityLiving entityliving, double d, double d1, double d2, float f, float f1) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        this.mainModel.onGround = this.func_167_c(entityliving, f1);
        if (this.renderPassModel != null) {
            this.renderPassModel.onGround = this.mainModel.onGround;
        }
        if (this.overlayModel != null) {
            this.overlayModel.onGround = this.mainModel.onGround;
        }
        this.mainModel.isRiding = entityliving.isRiding();
        if (this.renderPassModel != null) {
            this.renderPassModel.isRiding = this.mainModel.isRiding;
        }
        if (this.overlayModel != null) {
            this.overlayModel.isRiding = this.mainModel.isRiding;
        }
        try {
            int j;
            float f2 = entityliving.prevRenderYawOffset + (entityliving.renderYawOffset - entityliving.prevRenderYawOffset) * f1;
            float f3 = entityliving.prevRotationYaw + (entityliving.rotationYaw - entityliving.prevRotationYaw) * f1;
            float f4 = entityliving.prevRotationPitch + (entityliving.rotationPitch - entityliving.prevRotationPitch) * f1;
            this.func_22012_b(entityliving, d, d1, d2);
            float f5 = this.func_170_d(entityliving, f1);
            this.rotateCorpse(entityliving, f5, f2, f1);
            float f6 = 0.0625f;
            GL11.glEnable((int)32826);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.preRenderCallback(entityliving, f1);
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * f6 - 0.0078125f), (float)0.0f);
            float f7 = entityliving.field_705_Q + (entityliving.field_704_R - entityliving.field_705_Q) * f1;
            float f8 = entityliving.field_703_S - entityliving.field_704_R * (1.0f - f1);
            if (f7 > 1.0f) {
                f7 = 1.0f;
            }
            this.loadEntityTexture(entityliving);
            GL11.glEnable((int)3008);
            this.mainModel.setLivingAnimations(entityliving, f8, f7, f1);
            this.mainModel.render(f8, f7, f5, f3 - f2, f4, f6);
            if (this.overlayModel != null) {
                this.overlayModel.setLivingAnimations(entityliving, f8, f7, f1);
                this.loadTexture(this.overlayTexture);
                this.overlayModel.render(f8, f7, f5, f3 - f2, f4, f6);
            }
            if (this.renderPassModel != null) {
                this.renderPassModel.setLivingAnimations(entityliving, f8, f7, f1);
            }
            for (int i = 0; i < 4; ++i) {
                if (!this.shouldRenderPass(entityliving, i, f1)) continue;
                this.renderPassModel.render(f8, f7, f5, f3 - f2, f4, f6);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
            }
            this.renderEquippedItems(entityliving, f1);
            float f9 = entityliving.getEntityBrightness(f1);
            if (Minecraft.getMinecraft().fullbright) {
                f9 = 1.0f;
            }
            if (((j = this.getColorMultiplier(entityliving, f9, f1)) >> 24 & 0xFF) > 0 || entityliving.hurtTime > 0 || entityliving.deathTime > 0) {
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (entityliving.hurtTime > 0 || entityliving.deathTime > 0) {
                    GL11.glColor4f((float)f9, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.mainModel.render(f8, f7, f5, f3 - f2, f4, f6);
                    if (this.overlayModel != null) {
                        this.overlayModel.render(f8, f7, f5, f3 - f2, f4, f6);
                    }
                    for (int k = 0; k < 4; ++k) {
                        if (!this.func_27005_b(entityliving, k, f1)) continue;
                        GL11.glColor4f((float)f9, (float)0.0f, (float)0.0f, (float)0.4f);
                        this.renderPassModel.render(f8, f7, f5, f3 - f2, f4, f6);
                    }
                }
                if ((j >> 24 & 0xFF) > 0) {
                    float f10 = (float)(j >> 16 & 0xFF) / 255.0f;
                    float f11 = (float)(j >> 8 & 0xFF) / 255.0f;
                    float f12 = (float)(j & 0xFF) / 255.0f;
                    float f13 = (float)(j >> 24 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f10, (float)f11, (float)f12, (float)f13);
                    this.mainModel.render(f8, f7, f5, f3 - f2, f4, f6);
                    if (this.overlayModel != null) {
                        this.overlayModel.render(f8, f7, f5, f3 - f2, f4, f6);
                    }
                    for (int l = 0; l < 4; ++l) {
                        if (!this.func_27005_b(entityliving, l, f1)) continue;
                        GL11.glColor4f((float)f10, (float)f11, (float)f12, (float)f13);
                        this.renderPassModel.render(f8, f7, f5, f3 - f2, f4, f6);
                    }
                }
                GL11.glDepthFunc((int)515);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)32826);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        this.passSpecialRender(entityliving, d, d1, d2);
    }

    protected void func_22012_b(EntityLiving entityliving, double d, double d1, double d2) {
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
    }

    protected void rotateCorpse(EntityLiving entityliving, float f, float f1, float f2) {
        GL11.glRotatef((float)(180.0f - f1), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entityliving.deathTime > 0) {
            float f3 = ((float)entityliving.deathTime + f2 - 1.0f) / 20.0f * 1.6f;
            if ((f3 = MathHelper.sqrt_float(f3)) > 1.0f) {
                f3 = 1.0f;
            }
            GL11.glRotatef((float)(f3 * this.getDeathMaxRotation(entityliving)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected float func_167_c(EntityLiving entityliving, float f) {
        return entityliving.getSwingProgress(f);
    }

    protected float func_170_d(EntityLiving entityliving, float f) {
        return (float)entityliving.ticksExisted + f;
    }

    protected void renderEquippedItems(EntityLiving entityliving, float f) {
    }

    protected boolean func_27005_b(EntityLiving entityliving, int i, float f) {
        return this.shouldRenderPass(entityliving, i, f);
    }

    protected boolean shouldRenderPass(EntityLiving entityliving, int i, float f) {
        return false;
    }

    protected float getDeathMaxRotation(EntityLiving entityliving) {
        return 90.0f;
    }

    protected int getColorMultiplier(EntityLiving entityliving, float f, float f1) {
        return 0;
    }

    protected void preRenderCallback(EntityLiving entityliving, float f) {
    }

    protected void passSpecialRender(EntityLiving entityliving, double d, double d1, double d2) {
        if (Minecraft.canRenderEntityLabel()) {
            this.renderLivingLabel(entityliving, Integer.toString(entityliving.entityId), d, d1, d2, 64);
        } else if (!entityliving.nickname.isEmpty()) {
            this.renderLivingLabel(entityliving, entityliving.getDisplayName(), d, d1, d2, 64);
        }
    }

    protected void renderLivingLabel(EntityLiving entityliving, String s, double d, double d1, double d2, int i) {
        float f = entityliving.getDistanceToEntity(this.renderManager.livingPlayer);
        if (f > (float)i) {
            return;
        }
        FontRenderer fontrenderer = this.getFontRendererFromRenderManager();
        float f1 = 1.6f;
        float f2 = 0.026666671f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d + 0.0f), (float)((float)d1 + 2.3f), (float)((float)d2));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.026666671f, (float)-0.026666671f, (float)0.026666671f);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.instance;
        int byte0 = 0;
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        int j = fontrenderer.getStringWidth(s) / 2;
        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.addVertex(-j - 1, -1 + byte0, 0.0);
        tessellator.addVertex(-j - 1, 8 + byte0, 0.0);
        tessellator.addVertex(j + 1, 8 + byte0, 0.0);
        tessellator.addVertex(j + 1, -1 + byte0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, byte0, 0x20FFFFFF);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, byte0, 0xFFFFFF);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    @Override
    public void doRender(Entity entity, double d, double d1, double d2, float f, float f1) {
        this.doRenderLiving((EntityLiving)entity, d, d1, d2, f, f1);
    }

    public void loadEntityTexture(EntityLiving entityLiving) {
        this.loadTexture(entityLiving.getEntityTexture());
    }
}

