/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.CompressedStreamTools;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.ISaveFormat;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.SaveFormatComparator;
import net.minecraft.src.SaveHandler;
import net.minecraft.src.WorldInfo;

public class SaveFormatOld
implements ISaveFormat {
    protected final File saveDir;

    public SaveFormatOld(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        this.saveDir = file;
    }

    @Override
    public String getFormatName() {
        return "Old Format";
    }

    @Override
    public List getSaveList() {
        ArrayList<SaveFormatComparator> arraylist = new ArrayList<SaveFormatComparator>();
        for (int i = 0; i < 5; ++i) {
            String s = "World" + (i + 1);
            WorldInfo worldinfo = this.getWorldInfo(s);
            if (worldinfo == null) continue;
            arraylist.add(new SaveFormatComparator(s, "", worldinfo, worldinfo.getLastTimePlayed(), worldinfo.getSizeOnDisk(), false));
        }
        return arraylist;
    }

    @Override
    public void flushCache() {
    }

    @Override
    public WorldInfo getWorldInfo(String s) {
        File file = new File(this.saveDir, s);
        if (!file.exists()) {
            return null;
        }
        File file1 = new File(file, "level.dat");
        if (file1.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(new FileInputStream(file1));
                NBTTagCompound nbttagcompound2 = nbttagcompound.getCompoundTag("Data");
                return new WorldInfo(nbttagcompound2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((file1 = new File(file, "level.dat_old")).exists()) {
            try {
                NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_1138_a(new FileInputStream(file1));
                NBTTagCompound nbttagcompound3 = nbttagcompound1.getCompoundTag("Data");
                return new WorldInfo(nbttagcompound3);
            }
            catch (Exception exception1) {
                exception1.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void renameWorld(String s, String s1) {
        File file = new File(this.saveDir, s);
        if (!file.exists()) {
            return;
        }
        File file1 = new File(file, "level.dat");
        if (file1.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(new FileInputStream(file1));
                NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("Data");
                nbttagcompound1.setString("LevelName", s1);
                CompressedStreamTools.writeGzippedCompoundToOutputStream(nbttagcompound, new FileOutputStream(file1));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void deleteSave(String s) {
        File file = new File(this.saveDir, s);
        if (!file.exists()) {
            return;
        }
        SaveFormatOld.deleteFiles(file.listFiles());
        file.delete();
    }

    protected static void deleteFiles(File[] afile) {
        for (int i = 0; i < afile.length; ++i) {
            if (afile[i].isDirectory()) {
                SaveFormatOld.deleteFiles(afile[i].listFiles());
            }
            afile[i].delete();
        }
    }

    @Override
    public ISaveHandler getSaveLoader(String s, boolean flag) {
        return new SaveHandler(this.saveDir, s, flag);
    }

    @Override
    public boolean isOldMapFormat(String s) {
        return false;
    }

    @Override
    public boolean convertMapFormat(String s, IProgressUpdate iprogressupdate) {
        return false;
    }
}

