/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.BlockBed;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.EntityArmouredZombie;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.EntitySpider;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PathEntity;
import net.minecraft.src.PathPoint;
import net.minecraft.src.Pathfinder;
import net.minecraft.src.SpawnListEntry;
import net.minecraft.src.World;

public final class SpawnerMobs {
    private static Set eligibleChunksForSpawning = new HashSet();
    protected static final Class[] nightSpawnEntities = new Class[]{EntitySpider.class, EntityZombie.class, EntitySkeleton.class, EntityArmouredZombie.class};

    protected static ChunkPosition getRandomSpawningPointInChunk(World world, int i, int j) {
        int k = i + world.rand.nextInt(16);
        int l = world.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
        int i1 = j + world.rand.nextInt(16);
        return new ChunkPosition(k, l, i1);
    }

    public static int performSpawning(World world, boolean var1, boolean var2) {
        int var3;
        if (!var1 && !var2) {
            return 0;
        }
        eligibleChunksForSpawning.clear();
        for (var3 = 0; var3 < world.players.size(); ++var3) {
            EntityPlayer var4 = world.players.get(var3);
            int var5 = MathHelper.floor_double(var4.posX / 16.0);
            int var6 = MathHelper.floor_double(var4.posZ / 16.0);
            int var7 = 8;
            for (int var8 = -var7; var8 <= var7; ++var8) {
                for (int var9 = -var7; var9 <= var7; ++var9) {
                    eligibleChunksForSpawning.add(new ChunkCoordIntPair(var8 + var5, var9 + var6));
                }
            }
        }
        var3 = 0;
        ChunkCoordinates var35 = world.getSpawnPoint();
        for (EnumCreatureType creatureType : EnumCreatureType.values()) {
            if (creatureType.getPeacefulCreature() && !var2 || !creatureType.getPeacefulCreature() && !var1 || world.countEntities(creatureType.getCreatureClass()) > creatureType.getMaxNumberOfCreature() * eligibleChunksForSpawning.size() / 256) continue;
            block6: for (ChunkCoordIntPair var10 : eligibleChunksForSpawning) {
                SpawnListEntry spawnListEntry2;
                BiomeGenBase var11 = world.getWorldChunkManager().getBiomeGenAtChunkCoord(var10);
                List<SpawnListEntry> creatureSpawnableList = var11.getSpawnableList(creatureType);
                if (creatureSpawnableList == null || creatureSpawnableList.isEmpty()) continue;
                int var13 = 0;
                for (SpawnListEntry spawnListEntry2 : creatureSpawnableList) {
                    var13 += spawnListEntry2.spawnRarityRate;
                }
                int calculatedSpawnChance = world.rand.nextInt(var13);
                spawnListEntry2 = creatureSpawnableList.get(0);
                for (SpawnListEntry var17 : creatureSpawnableList) {
                    if ((calculatedSpawnChance -= var17.spawnRarityRate) >= 0) continue;
                    spawnListEntry2 = var17;
                    break;
                }
                ChunkPosition var41 = SpawnerMobs.getRandomSpawningPointInChunk(world, var10.chunkXPos * 16, var10.chunkZPos * 16);
                int x = var41.x;
                int y = var41.y;
                int z = var41.z;
                if (world.isBlockNormalCube(x, y, z) || world.getBlockMaterial(x, y, z) != creatureType.getCreatureMaterial()) continue;
                int countSpawned = 0;
                for (int tryToSpawnX = 0; tryToSpawnX < 3; ++tryToSpawnX) {
                    int xi = x;
                    int yi = y;
                    int zi = z;
                    int range = 6;
                    for (int tryToSpawnZ = 0; tryToSpawnZ < 4; ++tryToSpawnZ) {
                        EntityLiving mobToSpawn;
                        float var32;
                        float var31;
                        float var30;
                        float var33;
                        float zd;
                        float yd;
                        float xd;
                        if (!SpawnerMobs.canCreatureTypeSpawnAtLocation(creatureType, world, xi += world.rand.nextInt(range) - world.rand.nextInt(range), yi += world.rand.nextInt(2) - world.rand.nextInt(2), zi += world.rand.nextInt(range) - world.rand.nextInt(range)) || world.getClosestPlayer(xd = (float)xi + 0.5f, yd = (float)yi, zd = (float)zi + 0.5f, 24.0) != null || !((var33 = (var30 = xd - (float)var35.x) * var30 + (var31 = yd - (float)var35.y) * var31 + (var32 = zd - (float)var35.z) * var32) >= 576.0f)) continue;
                        try {
                            mobToSpawn = (EntityLiving)spawnListEntry2.entityClass.getConstructor(World.class).newInstance(world);
                        }
                        catch (Exception var34) {
                            var34.printStackTrace();
                            return var3;
                        }
                        mobToSpawn.setLocationAndAngles(xd, yd, zd, world.rand.nextFloat() * 360.0f, 0.0f);
                        if (mobToSpawn.getCanSpawnHere()) {
                            mobToSpawn.entityInitOnSpawn();
                            world.entityJoinedWorld(mobToSpawn);
                            if (++countSpawned >= mobToSpawn.getMaxSpawnedInChunk()) continue block6;
                        }
                        var3 += countSpawned;
                    }
                }
            }
        }
        return var3;
    }

    private static boolean canCreatureTypeSpawnAtLocation(EnumCreatureType enumcreaturetype, World world, int i, int j, int k) {
        if (enumcreaturetype.getCreatureMaterial() == Material.water) {
            return world.getBlockMaterial(i, j, k).getIsLiquid() && !world.isBlockNormalCube(i, j + 1, k);
        }
        return world.isBlockNormalCube(i, j - 1, k) && !world.isBlockNormalCube(i, j, k) && !world.getBlockMaterial(i, j, k).getIsLiquid();
    }

    public static boolean performSleepSpawning(World world, List list) {
        boolean flag = false;
        Pathfinder pathfinder = new Pathfinder(world);
        for (EntityPlayer entityplayer : list) {
            Class[] aclass;
            if (!entityplayer.sleeping || (aclass = nightSpawnEntities) == null || aclass.length == 0) continue;
            boolean flag1 = false;
            for (int i = 0; i < 20 && !flag1; ++i) {
                PathEntity pathentity;
                EntityLiving entityliving;
                int j1;
                int j = MathHelper.floor_double(entityplayer.posX) + world.rand.nextInt(32) - world.rand.nextInt(32);
                int k = MathHelper.floor_double(entityplayer.posZ) + world.rand.nextInt(32) - world.rand.nextInt(32);
                int l = MathHelper.floor_double(entityplayer.posY) + world.rand.nextInt(16) - world.rand.nextInt(16);
                if (l < 1) {
                    l = 1;
                } else if (l > Minecraft.WORLD_HEIGHT_BLOCKS) {
                    l = Minecraft.WORLD_HEIGHT_BLOCKS;
                }
                int i1 = world.rand.nextInt(aclass.length);
                for (j1 = l; j1 > 2 && !world.isBlockNormalCube(j, j1 - 1, k); --j1) {
                }
                while (!SpawnerMobs.canCreatureTypeSpawnAtLocation(EnumCreatureType.monster, world, j, j1, k) && j1 < l + 16 && j1 < 128) {
                    ++j1;
                }
                if (j1 >= l + 16 || j1 >= Minecraft.WORLD_HEIGHT_BLOCKS) {
                    j1 = l;
                    continue;
                }
                float f = (float)j + 0.5f;
                float f1 = j1;
                float f2 = (float)k + 0.5f;
                try {
                    entityliving = (EntityLiving)aclass[i1].getConstructor(World.class).newInstance(world);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return flag;
                }
                entityliving.setLocationAndAngles(f, f1, f2, world.rand.nextFloat() * 360.0f, 0.0f);
                if (!entityliving.getCanSpawnHere() || (pathentity = pathfinder.createEntityPathTo(entityliving, entityplayer, 32.0f)) == null || pathentity.pathLength <= 1) continue;
                PathPoint pathpoint = pathentity.func_22328_c();
                if (!(Math.abs((double)pathpoint.xCoord - entityplayer.posX) < 1.5) || !(Math.abs((double)pathpoint.zCoord - entityplayer.posZ) < 1.5) || !(Math.abs((double)pathpoint.yCoord - entityplayer.posY) < 1.5)) continue;
                ChunkCoordinates chunkcoordinates = BlockBed.getNearestEmptyChunkCoordinates(world, MathHelper.floor_double(entityplayer.posX), MathHelper.floor_double(entityplayer.posY), MathHelper.floor_double(entityplayer.posZ), 1);
                if (chunkcoordinates == null) {
                    chunkcoordinates = new ChunkCoordinates(j, j1 + 1, k);
                }
                entityliving.setLocationAndAngles((float)chunkcoordinates.x + 0.5f, chunkcoordinates.y, (float)chunkcoordinates.z + 0.5f, 0.0f, 0.0f);
                entityliving.entityInitOnSpawn();
                world.entityJoinedWorld(entityliving);
                entityplayer.wakeUpPlayer(true, false);
                world.playSoundEffectForPlayer(null, 2001, (int)entityplayer.posX, (int)entityplayer.posY - 1, (int)entityplayer.posZ, world.getBlockId((int)entityplayer.posX, (int)entityplayer.posY - 1, (int)entityplayer.posZ));
                entityliving.playLivingSound();
                flag = true;
                flag1 = true;
            }
        }
        return flag;
    }
}

