/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.src.AchievementMap;
import net.minecraft.src.IStatType;
import net.minecraft.src.StatList;
import net.minecraft.src.StatTypeDistance;
import net.minecraft.src.StatTypeSimple;
import net.minecraft.src.StatTypeTime;

public class StatBase {
    public final int statId;
    public final String statName;
    public boolean clientside = false;
    public String statGuid;
    private final IStatType statType;
    private static NumberFormat numberFormat = NumberFormat.getIntegerInstance(Locale.US);
    public static IStatType statTypeSimple = new StatTypeSimple();
    private static DecimalFormat decimalFormat = new DecimalFormat("########0.00");
    public static IStatType statTypeTime = new StatTypeTime();
    public static IStatType statTypeDistance = new StatTypeDistance();

    public StatBase(int i, String s, IStatType istattype) {
        this.statId = i;
        this.statName = s;
        this.statType = istattype;
    }

    public StatBase(int i, String s) {
        this(i, s, statTypeSimple);
    }

    public StatBase setClientside() {
        this.clientside = true;
        return this;
    }

    public StatBase registerStat() {
        if (StatList.statMap.containsKey(this.statId)) {
            throw new RuntimeException("Duplicate stat id: \"" + StatList.statMap.get((Object)Integer.valueOf((int)this.statId)).statName + "\" and \"" + this.statName + "\" at id " + this.statId);
        }
        StatList.statList1.add(this);
        StatList.statMap.put(this.statId, this);
        this.statGuid = AchievementMap.getGuid(this.statId);
        return this;
    }

    public boolean isAchievement() {
        return false;
    }

    public String makeString(int i) {
        return this.statType.makeString(i);
    }

    public String toString() {
        return this.statName;
    }

    static NumberFormat func_27083_i() {
        return numberFormat;
    }

    static DecimalFormat func_27081_j() {
        return decimalFormat;
    }
}

