/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.EntityList;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet132SetMobSpawner;
import net.minecraft.src.SpawnListEntry;
import net.minecraft.src.TileEntity;

public class TileEntityMobSpawner
extends TileEntity {
    public int delay = 20;
    private String mobID = "Pig";
    public double yaw;
    public double yaw2 = 0.0;
    private int nearby;

    public String getMobID() {
        return this.mobID;
    }

    public void setMobID(String s) {
        this.mobID = s != null && s.equalsIgnoreCase("none") ? null : s;
    }

    public boolean anyPlayerInRange() {
        return this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 16.0) != null;
    }

    @Override
    public void updateEntity() {
        this.yaw2 = this.yaw;
        if (!this.anyPlayerInRange()) {
            return;
        }
        double d = (float)this.xCoord + this.worldObj.rand.nextFloat();
        double d2 = (float)this.yCoord + this.worldObj.rand.nextFloat();
        double d4 = (float)this.zCoord + this.worldObj.rand.nextFloat();
        this.worldObj.spawnParticle("smoke", d, d2, d4, 0.0, 0.0, 0.0);
        this.worldObj.spawnParticle("flame", d, d2, d4, 0.0, 0.0, 0.0);
        this.yaw += (double)(1000.0f / ((float)this.delay + 200.0f));
        while (this.yaw > 360.0) {
            this.yaw -= 360.0;
            this.yaw2 -= 360.0;
        }
        if (!this.worldObj.isMultiplayerAndNotHost) {
            if (this.worldObj.difficultySetting == 0) {
                return;
            }
            if (this.mobID == null || this.mobID.equalsIgnoreCase("none")) {
                return;
            }
            if (this.delay == -1) {
                this.updateDelay();
            }
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            if (this.mobID == null) {
                this.nearby = this.countNearbySpawners();
            }
            int byte0 = 4;
            for (int i = 0; i < byte0; ++i) {
                EntityLiving entityliving = null;
                if (this.mobID.equalsIgnoreCase("random")) {
                    List<SpawnListEntry> list = this.worldObj.getBlockBiome(this.xCoord, this.zCoord).getSpawnableList(EnumCreatureType.monster);
                    SpawnListEntry entry = list.get(this.worldObj.rand.nextInt(list.size()));
                    entityliving = (EntityLiving)EntityList.createEntityInWorld(EntityList.classToStringMapping.get(entry.entityClass), this.worldObj);
                } else {
                    entityliving = (EntityLiving)EntityList.createEntityInWorld(this.mobID, this.worldObj);
                }
                if (entityliving == null) {
                    return;
                }
                int j = this.worldObj.getEntitiesWithinAABB(entityliving.getClass(), AxisAlignedBB.getBoundingBoxFromPool(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 1, this.yCoord + 1, this.zCoord + 1).expand(8.0, 4.0, 8.0)).size();
                if (j >= 6) {
                    this.updateDelay();
                    return;
                }
                double d6 = (double)this.xCoord + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * 4.0;
                double d7 = this.yCoord + this.worldObj.rand.nextInt(3) - 1;
                double d8 = (double)this.zCoord + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * 4.0;
                entityliving.setLocationAndAngles(d6, d7, d8, this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
                if (!entityliving.getCanSpawnHere()) {
                    this.updateDelay();
                    continue;
                }
                this.worldObj.entityJoinedWorld(entityliving);
                for (int k = 0; k < 20; ++k) {
                    double d1 = (double)this.xCoord + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                    double d3 = (double)this.yCoord + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                    double d5 = (double)this.zCoord + 0.5 + ((double)this.worldObj.rand.nextFloat() - 0.5) * 2.0;
                    this.worldObj.spawnParticle("smoke", d1, d3, d5, 0.0, 0.0, 0.0);
                    this.worldObj.spawnParticle("flame", d1, d3, d5, 0.0, 0.0, 0.0);
                    this.worldObj.playSoundAtEntity(entityliving, "mob.ghast.fireball", 0.025f, 0.75f);
                }
                entityliving.spawnExplosionParticle();
                this.updateDelay();
            }
        }
        super.updateEntity();
    }

    @Override
    public Packet getDescriptionPacket() {
        return new Packet132SetMobSpawner(this.xCoord, this.yCoord, this.zCoord, this.mobID);
    }

    public int countNearbySpawners() {
        int r = 4;
        int count = 0;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int id = this.worldObj.getBlockId(this.xCoord + i, this.yCoord + j, this.zCoord + k);
                    if (id != Block.mobspawner.blockID) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private void updateDelay() {
        this.delay = 200 + this.worldObj.rand.nextInt(600);
        if (this.mobID == null) {
            this.delay *= 2;
            System.out.println("x2");
            if (this.nearby > 1) {
                System.out.println("x4");
                this.delay *= 4;
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.setMobID(nbttagcompound.getString("EntityId"));
        this.delay = nbttagcompound.getShort("Delay");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setString("EntityId", this.mobID != null ? this.mobID : "none");
        nbttagcompound.setShort("Delay", (short)this.delay);
    }
}

