/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ChunkProviderClient;
import net.minecraft.src.Dimension;
import net.minecraft.src.Entity;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.IWorldAccess;
import net.minecraft.src.MCHash;
import net.minecraft.src.NetClientHandler;
import net.minecraft.src.Packet255KickDisconnect;
import net.minecraft.src.SaveHandlerMP;
import net.minecraft.src.World;
import net.minecraft.src.WorldBlockPositionType;

public class WorldClient
extends World {
    private Minecraft mc;
    private LinkedList field_1057_z;
    private NetClientHandler sendQueue;
    private ChunkProviderClient field_20915_C;
    private MCHash field_1055_D;
    private Set field_20914_E;
    private Set field_1053_F;

    public WorldClient(Minecraft minecraft, NetClientHandler netclienthandler, long l, int i) {
        super((ISaveHandler)new SaveHandlerMP(), "MpServer", Dimension.dimensionList[i], l);
        this.mc = minecraft;
        this.field_1057_z = new LinkedList();
        this.field_1055_D = new MCHash();
        this.field_20914_E = new HashSet();
        this.field_1053_F = new HashSet();
        this.sendQueue = netclienthandler;
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
        this.mapStorage = netclienthandler.field_28118_b;
    }

    @Override
    public void tick() {
        this.setWorldTime(this.getWorldTime() + 1L);
        int i = this.calculateSkylightSubtracted(1.0f);
        if (i != this.skylightSubtracted) {
            this.skylightSubtracted = i;
            for (int j = 0; j < this.worldAccesses.size(); ++j) {
                ((IWorldAccess)this.worldAccesses.get(j)).updateAllRenderers();
            }
        }
        for (int k = 0; k < 10 && !this.field_1053_F.isEmpty(); ++k) {
            Entity entity = (Entity)this.field_1053_F.iterator().next();
            if (this.loadedEntityList.contains(entity)) continue;
            this.entityJoinedWorld(entity);
        }
        this.sendQueue.processReadPackets();
        for (int l = 0; l < this.field_1057_z.size(); ++l) {
            WorldBlockPositionType worldblockpositiontype = (WorldBlockPositionType)this.field_1057_z.get(l);
            if (--worldblockpositiontype.field_1206_d != 0) continue;
            super.setBlockAndMetadata(worldblockpositiontype.field_1202_a, worldblockpositiontype.field_1201_b, worldblockpositiontype.field_1207_c, worldblockpositiontype.field_1205_e, worldblockpositiontype.field_1204_f);
            super.markBlockNeedsUpdate(worldblockpositiontype.field_1202_a, worldblockpositiontype.field_1201_b, worldblockpositiontype.field_1207_c);
            this.field_1057_z.remove(l--);
        }
        int oldDayInSeason = this.dayInSeason;
        this.updateCurrentSeason();
        if (oldDayInSeason != this.dayInSeason) {
            for (int j = 0; j < this.worldAccesses.size(); ++j) {
                ((IWorldAccess)this.worldAccesses.get(j)).updateAllRenderers();
            }
        }
        if (((Boolean)this.mc.gameSettings.worldHoleFix.value).booleanValue()) {
            this.chunkProvider.checkForMissingChunks();
        }
    }

    public void func_711_c(int i, int j, int k, int l, int i1, int j1) {
        for (int k1 = 0; k1 < this.field_1057_z.size(); ++k1) {
            WorldBlockPositionType worldblockpositiontype = (WorldBlockPositionType)this.field_1057_z.get(k1);
            if (worldblockpositiontype.field_1202_a < i || worldblockpositiontype.field_1201_b < j || worldblockpositiontype.field_1207_c < k || worldblockpositiontype.field_1202_a > l || worldblockpositiontype.field_1201_b > i1 || worldblockpositiontype.field_1207_c > j1) continue;
            this.field_1057_z.remove(k1--);
        }
    }

    @Override
    protected IChunkProvider getChunkProvider() {
        this.field_20915_C = new ChunkProviderClient(this);
        return this.field_20915_C;
    }

    @Override
    public void setSpawnLocation() {
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
    }

    @Override
    protected void updateBlocksAndPlayCaveSounds() {
    }

    @Override
    public void scheduleBlockUpdate(int i, int j, int k, int l, int i1) {
    }

    @Override
    public boolean TickUpdates(boolean flag) {
        return false;
    }

    public void doPreChunk(int i, int j, boolean flag) {
        if (flag) {
            this.field_20915_C.prepareChunk(i, j);
        } else {
            this.field_20915_C.func_539_c(i, j);
        }
        if (!flag) {
            this.markBlocksDirty(i * 16, 0, j * 16, i * 16 + 15, net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS, j * 16 + 15);
        }
    }

    @Override
    public boolean entityJoinedWorld(Entity entity) {
        boolean flag = super.entityJoinedWorld(entity);
        this.field_20914_E.add(entity);
        if (!flag) {
            this.field_1053_F.add(entity);
        }
        return flag;
    }

    @Override
    public void setEntityDead(Entity entity) {
        super.setEntityDead(entity);
        this.field_20914_E.remove(entity);
    }

    @Override
    protected void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        if (this.field_1053_F.contains(entity)) {
            this.field_1053_F.remove(entity);
        }
    }

    @Override
    protected void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        if (this.field_20914_E.contains(entity)) {
            this.field_1053_F.add(entity);
        }
    }

    public void func_712_a(int i, Entity entity) {
        Entity entity1 = this.func_709_b(i);
        if (entity1 != null) {
            this.setEntityDead(entity1);
        }
        this.field_20914_E.add(entity);
        entity.entityId = i;
        if (!this.entityJoinedWorld(entity)) {
            this.field_1053_F.add(entity);
        }
        this.field_1055_D.addKey(i, entity);
    }

    public Entity func_709_b(int i) {
        return (Entity)this.field_1055_D.lookup(i);
    }

    public Entity removeEntityFromWorld(int i) {
        Entity entity = (Entity)this.field_1055_D.removeObject(i);
        if (entity != null) {
            this.field_20914_E.remove(entity);
            this.setEntityDead(entity);
        }
        return entity;
    }

    @Override
    public boolean setBlockMetadata(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        int j1 = this.getBlockMetadata(i, j, k);
        if (super.setBlockMetadata(i, j, k, l)) {
            this.field_1057_z.add(new WorldBlockPositionType(this, i, j, k, i1, j1));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlockAndMetadata(int i, int j, int k, int l, int i1) {
        int j1 = this.getBlockId(i, j, k);
        int k1 = this.getBlockMetadata(i, j, k);
        if (super.setBlockAndMetadata(i, j, k, l, i1)) {
            this.field_1057_z.add(new WorldBlockPositionType(this, i, j, k, j1, k1));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlock(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        int j1 = this.getBlockMetadata(i, j, k);
        if (super.setBlock(i, j, k, l)) {
            this.field_1057_z.add(new WorldBlockPositionType(this, i, j, k, i1, j1));
            return true;
        }
        return false;
    }

    public boolean func_714_c(int i, int j, int k, int l, int i1) {
        this.func_711_c(i, j, k, i, j, k);
        if (super.setBlockAndMetadata(i, j, k, l, i1)) {
            this.notifyBlockChange(i, j, k, l);
            return true;
        }
        return false;
    }

    @Override
    public void sendQuittingDisconnectingPacket() {
        this.sendQueue.func_28117_a(new Packet255KickDisconnect("Quitting"));
    }
}

