/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntityChest;
import net.minecraft.src.TileEntityDispenser;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenerator;

public class WorldGenLabyrinth
extends WorldGenerator {
    int dungeonSize = 0;
    int dungeonLimit;
    int dungeonCount = 0;
    boolean treasureGenerated = false;
    boolean libraryGenerated = false;
    int wallBlockA;
    int wallBlockB;
    int brickBlockA;
    int brickBlockB;
    int slabBlock;

    public WorldGenLabyrinth() {
        this.wallBlockA = Block.cobbleStone.blockID;
        this.wallBlockB = Block.cobbleStoneMossy.blockID;
        this.brickBlockA = Block.brickStonePolished.blockID;
        this.brickBlockB = Block.brickStonePolishedMossy.blockID;
        this.slabBlock = Block.slabStonePolished.blockID;
    }

    @Override
    public boolean generate(World world, Random random, int blockX, int blockY, int blockZ) {
        BiomeGenBase biome = world.getWorldChunkManager().getBiomeGenAt(blockX, blockZ);
        if (biome == BiomeGenBase.desert || biome == BiomeGenBase.outback) {
            this.wallBlockA = Block.sandstone.blockID;
            this.wallBlockB = Block.sandstone.blockID;
            this.brickBlockA = Block.brickSandstone.blockID;
            this.brickBlockB = Block.brickSandstone.blockID;
            this.slabBlock = Block.slabSandstone.blockID;
        }
        if (this.canReplace(world, blockX, blockY, blockZ)) {
            this.dungeonLimit = 1;
            this.generateBranch(world, random, blockX, blockY, blockZ);
            return true;
        }
        return false;
    }

    public void generateBranch(World world, Random random, int blockX, int blockY, int blockZ) {
        boolean generateTrapOnWall = false;
        for (int x = blockX - 2; x <= blockX + 2; ++x) {
            boolean xWallCheck = x == blockX - 2 || x == blockX + 2;
            for (int y = blockY - 2; y <= blockY + 1; ++y) {
                boolean yWallCheck = y == blockY - 2;
                for (int z = blockZ - 2; z <= blockZ + 2; ++z) {
                    boolean zWallCheck;
                    boolean bl = zWallCheck = z == blockZ - 2 || z == blockZ + 2;
                    if (!this.canReplace(world, x, y, z)) continue;
                    if (xWallCheck && zWallCheck) {
                        world.setBlockWithNotify(x, y, z, random.nextInt(4) == 0 ? this.brickBlockB : this.brickBlockA);
                    } else if (xWallCheck || zWallCheck) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockB);
                    } else if (yWallCheck) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockB);
                    } else {
                        world.setBlockWithNotify(x, y, z, 0);
                    }
                    if (generateTrapOnWall || !xWallCheck && !zWallCheck || x != blockZ && z != blockZ || y != blockY) continue;
                    world.setBlockWithNotify(x, y, z, Block.motionsensorIdle.blockID);
                    world.setBlockWithNotify(x, y - 1, z, Block.dispenserCobbleStone.blockID);
                    TileEntityDispenser tileEntityDispenser = (TileEntityDispenser)world.getBlockTileEntity(x, blockY - 1, z);
                    for (int k4 = 0; k4 < 3; ++k4) {
                        ItemStack itemstack = this.pickDispenserLootItem(random);
                        if (itemstack == null) continue;
                        tileEntityDispenser.setInventorySlotContents(random.nextInt(tileEntityDispenser.getSizeInventory()), itemstack);
                    }
                    generateTrapOnWall = true;
                }
            }
        }
        if (this.dungeonSize < 10) {
            ++this.dungeonSize;
            int corridorsToSpawn = random.nextInt(4);
            for (int i = 0; i <= corridorsToSpawn; ++i) {
                this.createCorridor(world, random, blockX, blockY, blockZ, random.nextInt(4), 0);
            }
        }
    }

    public void generateDrop(World world, Random random, int blockX, int blockY, int blockZ) {
        if (random.nextBoolean()) {
            this.generateDungeon(world, random, blockX, blockY, blockZ, false);
        }
        int dropHeight = random.nextInt(10) + 10;
        for (int x = blockX - 2; x <= blockX + 2; ++x) {
            for (int y = blockY - dropHeight; y <= blockY + 1; ++y) {
                for (int z = blockZ - 2; z <= blockZ + 2; ++z) {
                    boolean yWallCheck;
                    boolean xWallCheck = x == blockX - 2 || x == blockX + 2;
                    boolean zWallCheck = z == blockZ - 2 || z == blockZ + 2;
                    boolean bl = yWallCheck = y == blockY - dropHeight;
                    if (!this.canReplace(world, x, y, z)) continue;
                    if (xWallCheck || zWallCheck) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        continue;
                    }
                    if (yWallCheck) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        if (this.dungeonSize < 10) continue;
                        world.setBlockWithNotify(x, y + 1, z, Block.spikes.blockID);
                        continue;
                    }
                    if (x != blockX && z != blockZ && random.nextInt(20) == 0 && world.getBlockId(x, y + 1, z) != this.slabBlock) {
                        world.setBlockWithNotify(x, y, z, this.slabBlock);
                        continue;
                    }
                    world.setBlockWithNotify(x, y, z, 0);
                }
            }
        }
        if (this.dungeonSize < 10) {
            ++this.dungeonSize;
            int corridorsToSpawn = random.nextInt(4) + 1;
            for (int i = 1; i <= corridorsToSpawn; ++i) {
                this.createCorridor(world, random, blockX, blockY - (dropHeight - 2), blockZ, random.nextInt(4), 0);
            }
        }
    }

    private boolean canReplace(World world, int x, int y, int z) {
        if (y <= 11) {
            return false;
        }
        if (world.getBlockId(x, y, z) == this.brickBlockA || world.getBlockId(x, y, z) == Block.planksOak.blockID || world.getBlockId(x, y, z) == Block.cobweb.blockID || world.getBlockId(x, y, z) == Block.bookshelfPlanksOak.blockID || world.getBlockId(x, y, z) == Block.mobspawner.blockID || world.getBlockId(x, y, z) == this.brickBlockB) {
            return false;
        }
        if (world.getBlockId(x, y, z) == Block.motionsensorIdle.blockID || world.getBlockId(x, y, z) == Block.dispenserCobbleStone.blockID || world.getBlockId(x, y, z) == Block.motionsensorActive.blockID) {
            world.removeBlockTileEntity(x, y, z);
            world.setBlockWithNotify(x, y, z, 0);
            return true;
        }
        return world.getBlockMaterial(x, y, z) == Material.grass || world.getBlockMaterial(x, y, z) == Material.ground || world.getBlockMaterial(x, y, z) == Material.rock || world.getBlockMaterial(x, y, z) == Material.sand || world.getBlockMaterial(x, y, z) == Material.moss;
    }

    private void generateCorridor(World world, Random random, int blockX, int blockY, int blockZ, int rot, int corridorIteration) {
        int height = 2;
        int width = 2;
        int length = 2;
        for (int x = blockX - width; x <= blockX + width; ++x) {
            boolean xWallCheck = x == blockX - width || x == blockX + width;
            for (int y = blockY - height; y <= blockY + (height - 1); ++y) {
                boolean yWallCheck = y == blockY - height;
                for (int z = blockZ - length; z <= blockZ + length; ++z) {
                    boolean zWallCheck;
                    boolean bl = zWallCheck = z == blockZ - length || z == blockZ + length;
                    if (!this.canReplace(world, x, y, z) || (xWallCheck || zWallCheck || yWallCheck) && world.getBlockId(x, y + 1, z) == 0 && random.nextInt(3) > 0) continue;
                    if (rot == 0) {
                        if (xWallCheck) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        } else if (z == blockZ + length) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        } else if (yWallCheck) {
                            if (random.nextInt(3) == 0) {
                                world.setBlockWithNotify(x, y, z, this.wallBlockB);
                            } else {
                                world.setBlockWithNotify(x, y, z, this.wallBlockA);
                            }
                        } else {
                            world.setBlockWithNotify(x, y, z, 0);
                        }
                    } else if (rot == 1) {
                        if (x == blockX - width) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        } else if (zWallCheck) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        } else if (yWallCheck) {
                            if (random.nextInt(3) == 0) {
                                world.setBlockWithNotify(x, y, z, this.wallBlockB);
                            } else {
                                world.setBlockWithNotify(x, y, z, this.wallBlockA);
                            }
                        } else {
                            world.setBlockWithNotify(x, y, z, 0);
                        }
                    } else if (rot == 2) {
                        if (xWallCheck) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        } else if (z == blockZ - length) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        } else if (yWallCheck) {
                            if (random.nextInt(3) == 0) {
                                world.setBlockWithNotify(x, y, z, this.wallBlockB);
                            } else {
                                world.setBlockWithNotify(x, y, z, this.wallBlockA);
                            }
                        } else {
                            world.setBlockWithNotify(x, y, z, 0);
                        }
                    } else if (x == blockX + width) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockA);
                    } else if (zWallCheck) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockA);
                    } else if (yWallCheck) {
                        if (random.nextInt(3) == 0) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        }
                    } else {
                        world.setBlockWithNotify(x, y, z, 0);
                    }
                    if (y != blockY + (height - 1) || zWallCheck || xWallCheck || random.nextInt(20) != 0) continue;
                    world.setBlockWithNotify(x, y, z, Block.cobweb.blockID);
                }
            }
        }
        if (random.nextInt(2) == 0 && corridorIteration > 1) {
            if (random.nextInt(2) == 0) {
                this.generateBranch(world, random, blockX, blockY, blockZ);
            } else {
                this.generateDrop(world, random, blockX, blockY, blockZ);
            }
        } else if (random.nextInt(2) == 0 && corridorIteration > 1 && this.dungeonSize > 3 || this.dungeonSize >= 10 && this.dungeonCount < this.dungeonLimit) {
            this.createDungeon(world, random, blockX, blockY, blockZ, rot);
            ++this.dungeonCount;
        } else {
            if (random.nextInt(10) == 0 && corridorIteration > 1 && this.dungeonSize > 5) {
                return;
            }
            this.createCorridor(world, random, blockX, blockY, blockZ, rot, corridorIteration + 1);
        }
    }

    private void createCorridor(World world, Random random, int blockX, int blockY, int blockZ, int rot, int size) {
        if (rot == 0) {
            this.generateCorridor(world, random, blockX, blockY, blockZ + 4, 0, size);
        }
        if (rot == 1) {
            this.generateCorridor(world, random, blockX - 4, blockY, blockZ, 1, size);
        }
        if (rot == 2) {
            this.generateCorridor(world, random, blockX, blockY, blockZ - 4, 2, size);
        }
        if (rot == 3) {
            this.generateCorridor(world, random, blockX + 4, blockY, blockZ, 3, size);
        }
    }

    private void generateDungeon(World world, Random random, int blockX, int blockY, int blockZ, boolean doSpawner) {
        int chestZ;
        int size = 4;
        if (blockY < 10) {
            return;
        }
        for (int x = blockX - size; x <= blockX + size; ++x) {
            for (int y = blockY - 2; y <= blockY + 2; ++y) {
                for (int z = blockZ - size; z <= blockZ + size; ++z) {
                    boolean yWallCheck;
                    boolean xWallCheck = x == blockX - size || x == blockX + size;
                    boolean zWallCheck = z == blockZ - size || z == blockZ + size;
                    boolean bl = yWallCheck = y == blockY - 2;
                    if (!this.canReplace(world, x, y, z)) continue;
                    if (xWallCheck || zWallCheck) {
                        world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        continue;
                    }
                    if (yWallCheck) {
                        if (random.nextInt(5) == 0) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                            continue;
                        }
                        world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        continue;
                    }
                    world.setBlockWithNotify(x, y, z, 0);
                }
            }
        }
        int chestX = blockX + random.nextInt(size - 1) - (size - 1);
        if (this.canReplace(world, chestX, blockY - 2, chestZ = blockZ + random.nextInt(size - 1) - (size - 1))) {
            world.setBlockWithNotify(chestX, blockY - 1, chestZ, Block.chestPlanksOak.blockID);
            TileEntityChest tileentitychest = (TileEntityChest)world.getBlockTileEntity(chestX, blockY - 1, chestZ);
            for (int k4 = 0; k4 < 10; ++k4) {
                ItemStack itemstack = this.pickCheckLootItem(random);
                if (itemstack == null) continue;
                tileentitychest.setInventorySlotContents(random.nextInt(tileentitychest.getSizeInventory()), itemstack);
            }
        }
        if (doSpawner) {
            world.setBlockWithNotify(blockX, blockY - 1, blockZ, Block.mobspawner.blockID);
            TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.getBlockTileEntity(blockX, blockY - 1, blockZ);
            if (tileentitymobspawner != null) {
                tileentitymobspawner.setMobID(this.pickMobSpawner(random));
            }
        }
    }

    private void generateLibrary(World world, Random random, int blockX, int blockY, int blockZ) {
        int size = 10;
        int sideFacing = random.nextInt(2);
        if (blockY < 10) {
            return;
        }
        for (int x = blockX - size; x <= blockX + size; ++x) {
            for (int y = blockY - 2; y <= blockY + 3; ++y) {
                for (int z = blockZ - size; z <= blockZ + size; ++z) {
                    boolean yWallCheck;
                    int xRoom = x - blockX + size;
                    int zRoom = z - blockZ + size;
                    boolean xWallCheck = x == blockX - size || x == blockX + size;
                    boolean zWallCheck = z == blockZ - size || z == blockZ + size;
                    boolean bl = yWallCheck = y == blockY - 2;
                    if (!this.canReplace(world, x, y, z)) continue;
                    if (xWallCheck) {
                        if (zRoom % 4 != 0) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x, y, z, this.brickBlockA);
                        }
                    } else if (zWallCheck) {
                        if (xRoom % 4 != 0) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x, y, z, this.brickBlockA);
                        }
                    } else if (yWallCheck) {
                        if (x > blockX - 2 && x < blockX + 2 || z > blockZ - 2 && z < blockZ + 2) {
                            world.setBlockWithNotify(x, y, z, Block.planksOak.blockID);
                        } else if (random.nextInt(5) == 0) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        }
                        if (x > blockX - 3 && x < blockX + 3 && z > blockZ - 3 && z < blockZ + 3) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        }
                    } else if (y == blockY + 3) {
                        if (random.nextInt(5) == 0) {
                            world.setBlockWithNotify(x, y, z, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x, y, z, this.wallBlockA);
                        }
                    } else if (x > blockX - size && x < blockX + size || z > blockZ - size && z < blockX + size) {
                        if (!(xRoom % 4 == 0 || zRoom % 2 != 0 || x > blockX - 2 && x < blockX + 2 || z > blockZ - 1 && z < blockZ + 1 || y >= blockY + 2)) {
                            if (xRoom % 2 == 0) {
                                world.setBlockWithNotify(x, y, z, Block.bookshelfPlanksOak.blockID);
                            } else if (random.nextInt(5) == 0) {
                                world.setBlockWithNotify(x, y, z, Block.logOakMossy.blockID);
                            } else {
                                world.setBlockWithNotify(x, y, z, Block.logOak.blockID);
                            }
                        } else {
                            world.setBlockWithNotify(x, y, z, 0);
                        }
                    } else {
                        world.setBlockWithNotify(x, y, z, 0);
                    }
                    if (zRoom % 2 != 0 || x != blockX - 2 && x != blockX + 2 || z != blockZ - 2 && z != blockZ + 2) continue;
                    world.setBlockWithNotify(x, y, z, this.brickBlockA);
                }
            }
        }
        this.generateDrop(world, random, blockX, blockY, blockZ);
    }

    private void createDungeon(World world, Random random, int blockX, int blockY, int blockZ, int rot) {
        int dx = 0;
        int dz = 0;
        if (rot == 0) {
            dz = 1;
        }
        if (rot == 1) {
            dx = -1;
        }
        if (rot == 2) {
            dz = -1;
        }
        if (rot == 3) {
            dx = 1;
        }
        if (this.canReplace(world, blockX + dx * 5, blockY, blockZ + dz * 5)) {
            if (this.dungeonSize == 10 && !this.libraryGenerated) {
                this.libraryGenerated = true;
                this.generateLibrary(world, random, blockX + dx * 4, blockY, blockZ + dz * 4);
            } else {
                this.generateDungeon(world, random, blockX + dx * 4, blockY, blockZ + dz * 4, true);
            }
        }
    }

    private ItemStack pickDispenserLootItem(Random random) {
        int i = random.nextInt(6);
        if (i == 1 || i > 3) {
            return new ItemStack(Item.ammoArrow, random.nextInt(3) + 5);
        }
        if (i == 2 && random.nextInt(10) == 0) {
            return new ItemStack(Item.ammoArrowGold, 1);
        }
        if (i == 3 && random.nextInt(200) == 0) {
            return new ItemStack(Item.ammoChargeExplosive, 1);
        }
        return null;
    }

    private ItemStack pickCheckLootItem(Random random) {
        if (!this.treasureGenerated && this.dungeonSize > 7) {
            this.treasureGenerated = true;
            return new ItemStack(Item.armorQuiverGold);
        }
        int i = random.nextInt(16);
        if (i == 1) {
            return new ItemStack(Item.ingotIron, random.nextInt(6) + 1);
        }
        if (i == 2) {
            return new ItemStack(Item.ingotGold, random.nextInt(4) + 1);
        }
        if (i == 3) {
            return new ItemStack(Item.sulphur, random.nextInt(6) + 3);
        }
        if (i == 4 && random.nextInt(50) == 0) {
            return new ItemStack(Item.diamond, random.nextInt(3) + 1);
        }
        if (i == 5 && random.nextInt(100) == 0) {
            return new ItemStack(Item.foodAppleGold);
        }
        if (i == 6) {
            return new ItemStack(Item.dustRedstone, random.nextInt(4) + 1);
        }
        if (i == 7 && random.nextInt(10) == 0) {
            return new ItemStack(Item.itemsList[Item.record13.itemID + random.nextInt(9)]);
        }
        if (i == 8) {
            return new ItemStack(Item.foodApple);
        }
        if (i == 9) {
            return new ItemStack(Item.itemsList[Block.spongeDry.blockID], random.nextInt(4) + 1);
        }
        if (i == 10 && random.nextInt(20) == 0) {
            if (random.nextInt(10) == 0) {
                return new ItemStack(Item.handcannonLoaded);
            }
            return new ItemStack(Item.handcannonUnloaded);
        }
        if (i == 11 && random.nextInt(5) == 0) {
            return new ItemStack(Item.armorHelmetChainmail, 1, Item.armorHelmetChainmail.getMaxDamage() - random.nextInt(Item.armorHelmetChainmail.getMaxDamage() / 2));
        }
        if (i == 12 && random.nextInt(5) == 0) {
            return new ItemStack(Item.armorChestplateChainmail, 1, Item.armorChestplateChainmail.getMaxDamage() - random.nextInt(Item.armorChestplateChainmail.getMaxDamage() / 2));
        }
        if (i == 13 && random.nextInt(5) == 0) {
            return new ItemStack(Item.armorBootsChainmail, 1, Item.armorBootsChainmail.getMaxDamage() - random.nextInt(Item.armorBootsChainmail.getMaxDamage() / 2));
        }
        if (i == 14 && random.nextInt(5) == 0) {
            return new ItemStack(Item.armorLeggingsChainmail, 1, Item.armorLeggingsChainmail.getMaxDamage() - random.nextInt(Item.armorLeggingsChainmail.getMaxDamage() / 2));
        }
        if (i == 15 && random.nextInt(10) == 0) {
            return new ItemStack(Item.ingotSteelCrude, random.nextInt(3) + 1);
        }
        return null;
    }

    private String pickMobSpawner(Random random) {
        int i = random.nextInt(4);
        if (i == 0) {
            return "Skeleton";
        }
        if (i == 1) {
            return "Zombie";
        }
        return "ArmouredZombie";
    }
}

