/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockGrass;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenerator;

public class WorldGenTreeShapeCherry
extends WorldGenerator {
    protected int leavesID;
    protected int logID;
    protected int heightMod;

    public WorldGenTreeShapeCherry(int leavesID, int logID, int heightMod) {
        this.leavesID = leavesID;
        this.logID = logID;
        this.heightMod = heightMod;
    }

    @Override
    public boolean generate(World world, Random random, int i, int j, int k) {
        int l = random.nextInt(3) + this.heightMod;
        boolean flag = true;
        if (j < 1 || j + l + 1 > Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        for (int i1 = j; i1 <= j + 1 + l; ++i1) {
            int byte0 = 1;
            if (i1 == j) {
                byte0 = 0;
            }
            if (i1 >= j + 1 + l - 2) {
                byte0 = 2;
            }
            for (int i2 = i - byte0; i2 <= i + byte0 && flag; ++i2) {
                for (int l2 = k - byte0; l2 <= k + byte0 && flag; ++l2) {
                    if (i1 >= 0 && i1 < Minecraft.WORLD_HEIGHT_BLOCKS) {
                        int j3 = world.getBlockId(i2, i1, l2);
                        if (j3 == 0 || j3 == this.leavesID) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        int j1 = world.getBlockId(i, j - 1, k);
        if (!(Block.blocksList[j1] instanceof BlockGrass) && j1 != Block.dirt.blockID || j >= Minecraft.WORLD_HEIGHT_BLOCKS - l - 1) {
            return false;
        }
        world.setBlockWithNotify(i, j - 1, k, Block.dirt.blockID);
        for (int k1 = j - 3 + l; k1 <= j + l; ++k1) {
            int j2 = k1 - (j + l);
            int i3 = 1 - j2 / 2;
            for (int k3 = i - i3; k3 <= i + i3; ++k3) {
                int l3 = k3 - i;
                for (int i4 = k - i3; i4 <= k + i3; ++i4) {
                    int j4 = i4 - k;
                    if (Math.abs(l3) == i3 && Math.abs(j4) == i3 && (random.nextInt(2) == 0 || j2 == 0) || Block.opaqueCubeLookup[world.getBlockId(k3, k1, i4)]) continue;
                    if (random.nextInt(25) == 0) {
                        world.setBlockWithNotify(k3, k1, i4, Block.leavesCherryFlowering.blockID);
                        continue;
                    }
                    world.setBlockWithNotify(k3, k1, i4, this.leavesID);
                }
            }
        }
        for (int l1 = 0; l1 < l; ++l1) {
            int k2 = world.getBlockId(i, j + l1, k);
            if (k2 != 0 && k2 != this.leavesID) continue;
            world.setBlockWithNotify(i, j + l1, k, this.logID);
        }
        return true;
    }
}

