/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Season;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;
import net.minecraft.src.WorldChunkManager;

public abstract class WorldProvider {
    public World worldObj;
    public WorldChunkManager worldChunkMgr;
    public boolean hasNoSky = false;
    public float[] lightBrightnessTable = new float[32];
    private float[] colorsSunriseSunset = new float[4];

    public void onInitialLoad() {
        this.worldObj.setWorldTime(72000L);
    }

    public final void registerWorld(World world) {
        this.worldObj = world;
        this.registerWorldChunkManager();
        this.generateLightBrightnessTable();
        if (world.isNewWorld) {
            this.onInitialLoad();
        }
    }

    protected void generateLightBrightnessTable() {
        float f = 0.05f;
        for (int i = 0; i <= 31; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            if (i > 15) {
                f1 = 0.0f;
            }
            this.lightBrightnessTable[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }

    protected void registerWorldChunkManager() {
        this.worldChunkMgr = new WorldChunkManager(this.worldObj);
    }

    public abstract IChunkProvider getChunkProvider();

    public boolean canCoordinateBeSpawn(int i, int j) {
        int k = this.worldObj.getFirstUncoveredBlock(i, j);
        return k == Block.sand.blockID;
    }

    public float calculateCelestialAngle(long worldTick, float partialTicks) {
        Season otherSeason;
        float tickWithinCycle = (float)((int)(worldTick % (long)Minecraft.DAY_LENGTH_TICKS)) + partialTicks;
        float currDayLength = 0.5f;
        float otherDayLength = 0.5f;
        Season currSeason = this.worldObj.getCurrentSeason();
        Season season = otherSeason = this.worldObj.seasonProgress <= 0.5f ? this.worldObj.getLastSeason() : this.worldObj.getNextSeason();
        if (currSeason != null) {
            currDayLength = currSeason.dayLength;
            otherDayLength = otherSeason.dayLength;
        }
        float blendFactor = Math.abs(this.worldObj.seasonProgress - 0.5f);
        float dayLength = currDayLength + (otherDayLength - currDayLength) * blendFactor;
        float nightLength = 1.0f - dayLength;
        int dayLengthTicks = (int)((float)Minecraft.DAY_LENGTH_TICKS * dayLength);
        int nightLengthTicks = (int)((float)Minecraft.DAY_LENGTH_TICKS * nightLength);
        boolean isDay = tickWithinCycle < (float)dayLengthTicks;
        float partProgress = isDay ? tickWithinCycle / (float)dayLengthTicks : (tickWithinCycle - (float)dayLengthTicks) / (float)nightLengthTicks;
        float dayProgress = isDay ? partProgress / 2.0f : 0.5f + partProgress / 2.0f;
        if ((dayProgress -= 0.25f) < 0.0f) {
            dayProgress += 1.0f;
        }
        if (dayProgress > 1.0f) {
            dayProgress -= 1.0f;
        }
        float f2 = dayProgress;
        dayProgress = 1.0f - (float)((Math.cos((double)dayProgress * Math.PI) + 1.0) / 2.0);
        dayProgress = f2 + (dayProgress - f2) / 3.0f;
        return dayProgress;
    }

    public float[] calcSunriseSunsetColors(float f, float f1) {
        float f4;
        float f2 = 0.4f;
        float f3 = MathHelper.cos(f * 3.141593f * 2.0f) - 0.0f;
        if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
            float f5 = (f3 - f4) / f2 * 0.5f + 0.5f;
            float f6 = 1.0f - (1.0f - MathHelper.sin(f5 * 3.141593f)) * 0.99f;
            f6 *= f6;
            this.colorsSunriseSunset[0] = f5 * 0.3f + 0.7f;
            this.colorsSunriseSunset[1] = f5 * f5 * 0.7f + 0.2f;
            this.colorsSunriseSunset[2] = f5 * f5 * 0.0f + 0.2f;
            this.colorsSunriseSunset[3] = f6;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    public Vec3D func_4096_a(float f, float f1) {
        float f2 = MathHelper.cos(f * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = 0.7529412f;
        float f4 = 0.8470588f;
        float f5 = 1.0f;
        return Vec3D.createVector(f3 *= f2 * 0.94f + 0.06f, f4 *= f2 * 0.94f + 0.06f, f5 *= f2 * 0.91f + 0.09f);
    }

    public boolean canRespawnHere() {
        return true;
    }

    public float getCloudHeight() {
        return 108.0f;
    }

    public boolean func_28112_c() {
        return true;
    }
}

