/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.ChunkProviderOverworldHell;
import net.minecraft.src.ChunkProviderRetro;
import net.minecraft.src.Season;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.Weather;
import net.minecraft.src.WorldProvider;
import net.minecraft.src.WorldProviderFlat;
import net.minecraft.src.WorldProviderGeneric;
import net.minecraft.src.WorldProviderHell;
import net.minecraft.src.WorldProviderOverworld;
import net.minecraft.src.WorldProviderOverworldDeeper;
import net.minecraft.src.WorldProviderOverworldIslands;
import net.minecraft.src.WorldProviderOverworldParadise;
import net.minecraft.src.WorldProviderOverworldWoods;
import net.minecraft.src.WorldProviderSky;
import net.minecraft.src.WorldProviderVoid;

public class WorldType {
    public int id;
    public String name;
    public String languageKey;
    public WorldProvider worldProvider = null;
    public Season[] seasons;
    public Weather defaultWeather = Weather.weatherClear;
    public boolean enabled = true;
    public static WorldType[] worldTypes = new WorldType[14];
    public static WorldType overworld = new WorldType(0, "default").setLanguageKey("worldType.overworld").setWorldProvider(new WorldProviderOverworld()).setDefaultWeather(Weather.weatherClear).setSeasonList(Season.surfaceSpring, Season.surfaceSummer, Season.surfaceFall, Season.surfaceWinter);
    public static WorldType overworldIslands = new WorldType(1, "islands").setLanguageKey("worldType.islands").setWorldProvider(new WorldProviderOverworldIslands()).setDefaultWeather(Weather.weatherClear).setSeasonList(WorldType.overworld.seasons);
    public static WorldType overworldWinter = new WorldType(2, "winter").setLanguageKey("worldType.winter").setWorldProvider(new WorldProviderOverworld()).setDefaultWeather(Weather.weatherSnow).setSeasonList(Season.surfaceWinter);
    public static WorldType overworldFlat = new WorldType(3, "flat").setLanguageKey("worldType.flat").setWorldProvider(new WorldProviderFlat()).setDefaultWeather(Weather.weatherClear);
    public static WorldType overworldHell = new WorldType(4, "hell").setLanguageKey("worldType.hell").setWorldProvider(new WorldProviderGeneric(ChunkProviderOverworldHell.class)).setDefaultWeather(Weather.weatherHellClear).setSeasonList(Season.surfaceHell);
    public static WorldType overworldWoods = new WorldType(5, "woods").setLanguageKey("worldType.woods").setWorldProvider(new WorldProviderOverworldWoods()).setDefaultWeather(Weather.weatherWoodsClear).setSeasonList(WorldType.overworld.seasons);
    public static WorldType overworldParadise = new WorldType(6, "paradise").setLanguageKey("worldType.paradise").setWorldProvider(new WorldProviderOverworldParadise()).setSeasonList(Season.surfaceSpring);
    public static WorldType overworldRetro = new WorldType(7, "retro").setLanguageKey("worldType.retro").setWorldProvider(new WorldProviderGeneric(ChunkProviderRetro.class)).setSeasonList(new Season[0]);
    public static WorldType overworldRuins = new WorldType(8, "ruins").setLanguageKey("worldType.ruins");
    public static WorldType overworldDungeonCrawler = new WorldType(9, null).setLanguageKey("worldType.dungeons");
    public static WorldType overworldDeeper = new WorldType(10, "extended").setLanguageKey("worldType.deeper").setWorldProvider(new WorldProviderOverworldDeeper()).setDefaultWeather(Weather.weatherClear).setSeasonList(WorldType.overworld.seasons);
    public static WorldType nether = new WorldType(11, "nether").setWorldProvider(new WorldProviderHell());
    public static WorldType paradise = new WorldType(12, "paradise").setWorldProvider(new WorldProviderSky()).setSeasonList(Season.surfaceSpring);
    public static WorldType voidWorld = new WorldType(13, "void").setLanguageKey("worldType.void").setWorldProvider(new WorldProviderVoid()).setDefaultWeather(Weather.weatherClear).setSeasonList(WorldType.overworld.seasons);

    public WorldType(int id, String name) {
        this.id = id;
        this.name = name;
        WorldType.worldTypes[id] = this;
    }

    public static WorldType getByName(String name) {
        for (int i = 0; i < worldTypes.length; ++i) {
            if (worldTypes[i] == null || WorldType.worldTypes[i].worldProvider == null || WorldType.worldTypes[i].name == null || !WorldType.worldTypes[i].name.equals(name)) continue;
            return worldTypes[i];
        }
        return null;
    }

    public WorldType setLanguageKey(String languageKey) {
        this.languageKey = languageKey;
        return this;
    }

    public WorldType setWorldProvider(WorldProvider worldProvider) {
        this.worldProvider = worldProvider;
        return this;
    }

    public WorldType setSeasonList(Season ... seasons) {
        this.seasons = seasons;
        return this;
    }

    public WorldType setDefaultWeather(Weather weather) {
        this.defaultWeather = weather;
        return this;
    }

    public static WorldType get(int i) {
        return worldTypes[i];
    }

    public String toString() {
        return this.languageKey != null ? StringTranslate.getInstance().translateKey(this.languageKey + ".name") : this.name;
    }
}

