/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command;

public class ChatColor {
    public static final ChatColor[] colors = new ChatColor[16];
    public static final ChatColor white = new ChatColor(0).setNames("White");
    public static final ChatColor orange = new ChatColor(1).setNames("Orange");
    public static final ChatColor magenta = new ChatColor(2).setNames("Magenta");
    public static final ChatColor lightBlue = new ChatColor(3).setNames("Light Blue", "Aqua");
    public static final ChatColor yellow = new ChatColor(4).setNames("Yellow");
    public static final ChatColor lime = new ChatColor(5).setNames("Lime", "Lime Green");
    public static final ChatColor pink = new ChatColor(6).setNames("Pink");
    public static final ChatColor gray = new ChatColor(7).setNames("Gray", "Grey");
    public static final ChatColor lightGray = new ChatColor(8).setNames("Light Gray", "Light Grey", "Silver");
    public static final ChatColor cyan = new ChatColor(9).setNames("Cyan", "Turquoise");
    public static final ChatColor purple = new ChatColor(10).setNames("Purple");
    public static final ChatColor blue = new ChatColor(11).setNames("Blue");
    public static final ChatColor brown = new ChatColor(12).setNames("Brown");
    public static final ChatColor green = new ChatColor(13).setNames("Green");
    public static final ChatColor red = new ChatColor(14).setNames("Red");
    public static final ChatColor black = new ChatColor(15).setNames("Black");
    public final int id;
    public final String code;
    private String[] names;

    public ChatColor(int id) {
        ChatColor.colors[id] = this;
        this.id = id;
        this.code = "" + "0123456789ABCDEF".charAt(id);
    }

    public ChatColor setNames(String ... names) {
        this.names = names;
        return this;
    }

    public static ChatColor getColor(String name) {
        for (ChatColor color : colors) {
            for (String name2 : color.names) {
                if (!name.equalsIgnoreCase(ChatColor.simpleName(name2))) continue;
                return color;
            }
        }
        return null;
    }

    private static String simpleName(String str) {
        str = str.toLowerCase();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c < 'a' || c > 'z') continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public String[] getNames() {
        return this.names;
    }

    public String toString() {
        return "\u00a7" + this.code;
    }

    public static ChatColor get(int id) {
        return colors[id];
    }
}

