/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.server.MinecraftServer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.Packet72UpdatePlayerProfile;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.ServerCommand;

public class ColorCommand
extends ServerCommand {
    public ColorCommand(MinecraftServer server) {
        super(server, "color", "colour", "c");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        byte newColor;
        int i;
        if (!sender.isPlayer()) {
            throw new CommandError("Must be used by a player!");
        }
        EntityPlayerMP player = (EntityPlayerMP)sender.getPlayer();
        if (args.length == 0) {
            ChatColor color = ChatColor.get(player.chatColor);
            sender.sendMessage(ChatColor.lightGray + "Your color is " + color + color.getNames()[0]);
            StringBuilder builder = new StringBuilder();
            builder.append(ChatColor.lightGray + "Available Colors: ");
            int c = 0;
            for (ChatColor color2 : ChatColor.colors) {
                if (c > 0) {
                    builder.append(", ");
                }
                builder.append(color2).append(color2.getNames()[0]);
                ++c;
            }
            sender.sendMessage(builder.toString());
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("set")) {
            String[] args2 = new String[args.length - 1];
            for (i = 1; i < args.length; ++i) {
                args2[i - 1] = args[i];
            }
            args = args2;
        }
        StringBuilder enteredColorStr = new StringBuilder();
        for (i = 0; i < args.length; ++i) {
            enteredColorStr.append(args[i].toLowerCase());
        }
        String enteredColor = enteredColorStr.toString();
        ChatColor color = ChatColor.getColor(enteredColor);
        if (color == null) {
            throw new CommandError("Can't find color: \"" + enteredColor + "\"");
        }
        player.chatColor = newColor = (byte)color.id;
        player.hadNicknameSet = true;
        player.mcServer.configManager.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(player.username, player.nickname, player.score, newColor, true, player.isOperator()));
        sender.sendMessage(ChatColor.lightGray + "You changed your color to " + color + color.getNames()[0]);
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/color");
        sender.sendMessage("/color <color>");
    }
}

