/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import b100.utils.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.MathHelper;
import net.minecraft.src.WorldGenerator;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.helper.ReflectionHelper;

public class GenerateCommand
extends Command {
    private static Map<String, Class<? extends WorldGenerator>> worldGenerators = new HashMap<String, Class<? extends WorldGenerator>>();

    public GenerateCommand() {
        super("generate", "gen");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        int i;
        if (!sender.isPlayer()) {
            throw new CommandError("Must be used by a player!");
        }
        EntityPlayer player = sender.getPlayer();
        if (args.length < 1) {
            return false;
        }
        if (args[0].equalsIgnoreCase("list")) {
            sender.sendMessage(ChatColor.lightGray + "Available feature generators: ");
            Set<String> keys = worldGenerators.keySet();
            StringBuilder string = new StringBuilder();
            int i2 = 0;
            for (String key : keys) {
                if (i2 > 0) {
                    string.append(", ");
                }
                string.append(key);
                ++i2;
            }
            sender.sendMessage(string.toString());
            return true;
        }
        Class<? extends WorldGenerator> worldGenClass = GenerateCommand.getWorldGenerator(args[0]);
        if (worldGenClass == null) {
            throw new CommandError("Generator " + args[0] + " doesn't exist!");
        }
        ArrayList<Object> genArgs = null;
        Constructor<?> constructor = null;
        for (Constructor<?> c : worldGenClass.getConstructors()) {
            if (c.getParameterCount() != args.length - 1) continue;
            ArrayList<Object> genArgsTemp = new ArrayList<Object>();
            i = 0;
            for (Parameter parameter : c.getParameters()) {
                Class<?> type = parameter.getType();
                String arg = args[i + 1];
                if (type == String.class) {
                    genArgsTemp.add(arg);
                } else if (type == Integer.TYPE) {
                    genArgsTemp.add(Integer.parseInt(arg));
                } else {
                    Block block;
                    if (type != Block.class) throw new RuntimeException("Can't parse type: " + type.getName());
                    try {
                        block = Block.blocksList[Integer.parseInt(arg)];
                    }
                    catch (Exception e) {
                        block = Block.getBlockByName(arg);
                    }
                    if (block == null) throw new CommandError("Can't find block: " + arg);
                    genArgsTemp.add(block);
                }
                ++i;
            }
            constructor = c;
            genArgs = genArgsTemp;
        }
        if (constructor == null) {
            sender.sendMessage("Generator " + worldGenClass.getSimpleName() + " requires arguments: ");
            for (Constructor<?> c : worldGenClass.getConstructors()) {
                StringBuilder argString = new StringBuilder();
                i = 0;
                for (Parameter parameter : c.getParameters()) {
                    if (i > 0) {
                        argString.append(", ");
                    }
                    argString.append(parameter.getName()).append(" (").append(parameter.getType().getSimpleName()).append(")");
                    ++i;
                }
                sender.sendMessage(argString.toString());
            }
            return true;
        }
        WorldGenerator generator = GenerateCommand.createWorldGenerator(worldGenClass, constructor, genArgs);
        if (generator.generate(handler.getWorld(player), new Random(), MathHelper.floor_double(player.posX), MathHelper.floor_double(player.posY), MathHelper.floor_double(player.posZ))) return true;
        throw new CommandError("Could not spawn feature here!");
    }

    public static WorldGenerator createWorldGenerator(Class<? extends WorldGenerator> worldGenClass, Constructor<?> constructor, List<Object> genArgs) {
        if (genArgs.size() != constructor.getParameterCount()) {
            throw new RuntimeException("Invalid Parameter Count!");
        }
        try {
            return (WorldGenerator)constructor.newInstance(Utils.toArray(Object.class, genArgs));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<? extends WorldGenerator> getWorldGenerator(String name) {
        for (Map.Entry<String, Class<? extends WorldGenerator>> entry : worldGenerators.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/generate <feature> [params...]");
        sender.sendMessage("/generate <list>");
    }

    static {
        try {
            for (Class<?> clazz : ReflectionHelper.getAllClasses(className -> className.startsWith("net.minecraft.src"))) {
                if (!WorldGenerator.class.isAssignableFrom(clazz) || clazz == WorldGenerator.class) continue;
                Class<?> worldGenClass = clazz;
                worldGenerators.put(clazz.getSimpleName().substring(8), worldGenClass);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

