/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.server.MinecraftServer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.ServerCommand;

public class WhoisCommand
extends ServerCommand {
    public WhoisCommand(MinecraftServer server) {
        super(server, "whois", "who");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        StringBuilder enteredNicknameStr = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            enteredNicknameStr.append(args[i]).append(" ");
        }
        String enteredNickname = enteredNicknameStr.substring(0, enteredNicknameStr.length() - 1);
        if (enteredNickname.length() > 16) {
            enteredNickname = enteredNickname.substring(0, 16);
        }
        for (EntityPlayerMP player : this.server.configManager.playerEntities) {
            if (!player.nickname.equals(enteredNickname)) continue;
            sender.sendMessage(player.getDisplayName() + ChatColor.white + "'s username is " + player.username);
            return true;
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/whois <nickname>");
    }
}

