/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.helper;

import net.minecraft.src.EntityLiving;
import net.minecraft.src.MathHelper;

public enum Direction {
    NORTH(0, false),
    EAST(1, false),
    SOUTH(2, false),
    WEST(3, false),
    UP(4, true),
    DOWN(5, true);

    public final int index;
    private Direction opposite;
    public final boolean vertical;

    private Direction(int index, boolean vertical) {
        this.index = index;
        this.vertical = vertical;
    }

    public static Direction getDirection(int index) {
        return Direction.values()[index];
    }

    public static Direction getVerticalDirection(double rotationPitch) {
        if (rotationPitch < 0.0) {
            return UP;
        }
        return DOWN;
    }

    public static Direction getVerticalDirection(EntityLiving entity) {
        if (entity.rotationLockVertical != null) {
            return entity.rotationLockVertical;
        }
        return Direction.getVerticalDirection(entity.rotationPitch);
    }

    public static Direction getHorizontalDirection(double rotationYaw) {
        return Direction.getDirection(MathHelper.floor_double(rotationYaw / 90.0 + 0.5) & 3);
    }

    public static Direction getHorizontalDirection(EntityLiving entity) {
        if (entity.rotationLockHorizontal != null) {
            return entity.rotationLockHorizontal;
        }
        return Direction.getHorizontalDirection(entity.rotationYaw);
    }

    public static Direction getDirection(EntityLiving entity) {
        if (entity.rotationLock != null) {
            return entity.rotationLock;
        }
        return Direction.getDirection(entity.rotationYaw, entity.rotationPitch);
    }

    public static Direction getDirection(double rotationYaw, double rotationPitch) {
        if (rotationPitch < -45.0) {
            return UP;
        }
        if (rotationPitch > 45.0) {
            return DOWN;
        }
        return Direction.getHorizontalDirection(rotationYaw);
    }

    public static Direction getHorizontalDirectionForSide(int side) {
        return NORTH;
    }

    public Direction getOpposite() {
        return this.opposite;
    }

    public int getIndex() {
        return this.index;
    }

    public Direction rotate(int i) {
        if (this == UP) {
            return UP;
        }
        if (this == DOWN) {
            return DOWN;
        }
        return Direction.getDirection(this.getIndex() + i & 3);
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public boolean isHorizontal() {
        return !this.vertical;
    }

    public static int getLegacySide(Direction dir) {
        if (dir == UP) {
            return 0;
        }
        if (dir == DOWN) {
            return 1;
        }
        if (dir == NORTH) {
            return 2;
        }
        if (dir == EAST) {
            return 5;
        }
        if (dir == SOUTH) {
            return 3;
        }
        if (dir == WEST) {
            return 4;
        }
        return -1;
    }

    public static int getLegacySide2(Direction dir) {
        if (dir == NORTH) {
            return 1;
        }
        if (dir == EAST) {
            return 2;
        }
        if (dir == SOUTH) {
            return 0;
        }
        if (dir == WEST) {
            return 3;
        }
        return -1;
    }

    public int meta() {
        return Direction.getLegacySide(this);
    }

    public static Direction getDirectionForLegacySide(int l) {
        if (l == 0) {
            return UP;
        }
        if (l == 1) {
            return DOWN;
        }
        if (l == 2) {
            return NORTH;
        }
        if (l == 3) {
            return SOUTH;
        }
        if (l == 4) {
            return WEST;
        }
        if (l == 5) {
            return EAST;
        }
        return null;
    }

    static {
        Direction.NORTH.opposite = SOUTH;
        Direction.SOUTH.opposite = NORTH;
        Direction.EAST.opposite = WEST;
        Direction.WEST.opposite = EAST;
        Direction.UP.opposite = DOWN;
        Direction.DOWN.opposite = UP;
    }
}

