/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.input;

import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.minecraft.client.Minecraft;
import net.minecraft.src.input.MouseInput;
import net.minecraft.src.input.controller.ControllerInput;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class InputHandler {
    public static List<ControllerInput> controllers;

    public static void init(Minecraft minecraft) {
        try {
            System.out.println("Creating Mouse & Keyboard");
            Keyboard.create();
            Mouse.create();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!((Boolean)minecraft.gameSettings.disableJInput.value).booleanValue()) {
            try {
                System.out.println("Initizalizing Controllers");
                ControllerEnvironment controllerEnvironment = ControllerEnvironment.getDefaultEnvironment();
                System.out.println("ControllerEnvironment: " + controllerEnvironment);
                Controller[] devices = controllerEnvironment.getControllers();
                System.out.println(devices.length + " Devices");
                System.out.println("Available Devices: ");
                for (Controller device : devices) {
                    if (device == null) continue;
                    System.out.println(device.getName() + " (" + device.getType() + ")");
                }
                ArrayList<ControllerInput> controllerList = new ArrayList<ControllerInput>();
                for (Controller controller : devices) {
                    if (controller.getType() == Controller.Type.GAMEPAD) {
                        controllerList.add(new ControllerInput(minecraft, controller));
                    }
                    if (controller.getType() != Controller.Type.MOUSE || minecraft.mouseInput != null) continue;
                    minecraft.mouseInput = new MouseInput(minecraft, controller);
                }
                controllers = controllerList;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("JInput disabled in options.txt!");
        }
        if (minecraft.mouseInput == null) {
            System.out.println("Raw Mouse Input Not Supported!");
            minecraft.mouseInput = new MouseInput(minecraft, null);
        }
    }

    public ControllerInput getController(String name) {
        for (ControllerInput controllerInput : controllers) {
            if (!controllerInput.getController().getName().equalsIgnoreCase(name)) continue;
            return controllerInput;
        }
        return null;
    }

    public static Component getComponent(Controller controller, String id) {
        if (controller == null) {
            return null;
        }
        for (Component component : controller.getComponents()) {
            if (!component.getIdentifier().toString().equalsIgnoreCase(id)) continue;
            return component;
        }
        return null;
    }
}

